/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetHelper;
import oracle.ide.model.Project;
import oracle.ide.panels.Navigable;

public abstract class ContentSetProvider {
    private String _key;
    private final String _shortLabel;

    public ContentSetProvider(String key, String shortLabel) {
        this._key = key;
        this._shortLabel = shortLabel;
    }

    public final String getKey() {
        return this._key;
    }

    public final String getShortLabel() {
        return this._shortLabel;
    }

    public boolean applicationLevelContent() {
        return false;
    }

    public boolean displayFoldersAsPackages() {
        return false;
    }

    public boolean alwaysShowEmptyFolders() {
        return false;
    }

    public boolean canContainJavaSources() {
        return false;
    }

    public boolean canExtendURLPath(Project project) {
        return true;
    }

    public ContentSetHelper getContentSetHelper() {
        return new ContentSetHelper(this._key);
    }

    public boolean isFlatLevelEnabled() {
        return this.canContainJavaSources();
    }

    @Deprecated
    public void initContentSet(ContentSet contentSet, URL projectDir, Context context) {
    }

    public abstract Navigable getNavigable();

    public String toString() {
        return this._shortLabel;
    }

    void setKey(String key) {
        this._key = key;
    }
}

