/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.AbstractFileContentRecognizerTemplate;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RecognizersHook;
import oracle.javatools.data.HashStructure;

class ContentRecognizerHookHelper {
    static Map<File, List<AbstractFileContentRecognizerTemplate.FileContentRule>> findContentMappingsByExtension(HashStructure hs) {
        return Collections.unmodifiableMap(ContentRecognizerHookHelper.buildContentMappings(hs));
    }

    private static Map<File, List<AbstractFileContentRecognizerTemplate.FileContentRule>> buildContentMappings(HashStructure hs) {
        HashMap<File, List<AbstractFileContentRecognizerTemplate.FileContentRule>> mappings = new HashMap<File, List<AbstractFileContentRecognizerTemplate.FileContentRule>>();
        List contentRecognizers = hs.getAsList("content-recognizer");
        if (contentRecognizers == null) {
            return mappings;
        }
        for (Object o : contentRecognizers) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            ContentRecognizerHookHelper.addContentMapping(childHs, mappings);
        }
        return mappings;
    }

    private static void addContentMapping(HashStructure hs, Map<File, List<AbstractFileContentRecognizerTemplate.FileContentRule>> mappings) {
        List contents = hs.getAsList("content");
        if (contents == null) {
            return;
        }
        for (Object o : contents) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String protocol = childHs.getString("protocol/#text");
            String extension = childHs.getString("extension/#text");
            File fileExtension = null;
            if (extension == null || extension.length() == 0) continue;
            fileExtension = Recognizer.sanitizeExtension(extension);
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(childHs);
            MetaClass metaClass = adapter.getMetaClass("node-type/#text");
            RecognizersHook.addToMultimap(mappings, fileExtension, new AbstractFileContentRecognizerTemplate.FileContentRule(protocol, fileExtension, ContentRecognizerHookHelper.contents(childHs), metaClass));
        }
    }

    static List<AbstractFileContentRecognizerTemplate.ContentToLookFor> contents(HashStructure hs) {
        ArrayList<AbstractFileContentRecognizerTemplate.ContentToLookFor> contents = new ArrayList<AbstractFileContentRecognizerTemplate.ContentToLookFor>();
        List contentsList = hs.getAsList("contents");
        if (contentsList == null) {
            return contents;
        }
        for (Object o : contentsList) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            contents.addAll(ContentRecognizerHookHelper.contentToLookFor(childHs));
        }
        return contents;
    }

    private static List<AbstractFileContentRecognizerTemplate.ContentToLookFor> contentToLookFor(HashStructure hs) {
        ArrayList<AbstractFileContentRecognizerTemplate.ContentToLookFor> contents = new ArrayList<AbstractFileContentRecognizerTemplate.ContentToLookFor>();
        List containsList = hs.getAsList("contains");
        if (containsList == null) {
            return contents;
        }
        for (Object o : containsList) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String text = childHs.getString("text/#text");
            int position = childHs.getInt("position/#text");
            contents.add(new AbstractFileContentRecognizerTemplate.ContentToLookFor(text, position));
        }
        return contents;
    }

    private ContentRecognizerHookHelper() {
    }
}

