/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.migration.NodeMigratorHelperReference;
import oracle.javatools.data.HashStructure;

public class NodeMigratorHook
extends HashStructureHook {
    public static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "node-migrator-hook");
    private Map<String, List<NodeMigratorHelperReference>> migratorMap = new HashMap<String, List<NodeMigratorHelperReference>>();

    public static NodeMigratorHook getHook() {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        return (NodeMigratorHook)registry.getHook(HOOK_NAME);
    }

    public NodeMigratorHook() {
        super(true);
    }

    public synchronized List<NodeMigratorHelperReference> nodeMigrators(MigratorType migratorName) {
        List<NodeMigratorHelperReference> migrators = this.migratorMap.get(migratorName.toString());
        if (migrators == null) {
            migrators = this.buildMigratorList(migratorName);
            this.migratorMap.put(migratorName.toString(), migrators);
        }
        return Collections.unmodifiableList(migrators);
    }

    private List<NodeMigratorHelperReference> buildMigratorList(MigratorType migratorName) {
        HashStructure rootHash = this.getHashStructure();
        List migratorsHashes = rootHash.getAsList(migratorName.toString().toLowerCase() + "-migrators");
        return this.migratorsIn(migratorsHashes);
    }

    private List<NodeMigratorHelperReference> migratorsIn(List migratorsHashes) {
        ArrayList<NodeMigratorHelperReference> refs = new ArrayList<NodeMigratorHelperReference>();
        if (migratorsHashes == null) {
            return refs;
        }
        for (Object o : migratorsHashes) {
            if (!(o instanceof HashStructure)) continue;
            refs.addAll(this.migratorsIn((HashStructure)o));
        }
        return refs;
    }

    private List<NodeMigratorHelperReference> migratorsIn(HashStructure migratorsHash) {
        ArrayList<NodeMigratorHelperReference> refs = new ArrayList<NodeMigratorHelperReference>();
        List migrators = migratorsHash.getAsList("migrator");
        if (migrators == null) {
            return refs;
        }
        for (Object o : migrators) {
            if (!(o instanceof HashStructure)) continue;
            refs.add(this.migratorFrom((HashStructure)o));
        }
        return refs;
    }

    private NodeMigratorHelperReference migratorFrom(HashStructure migrator) {
        String key = migrator.getString("key/#text");
        String version = migrator.getString("version/#text");
        if (version == null) {
            version = "11.1.1.1.0";
        }
        List tsl = migrator.getAsList("technologyKey");
        ArrayList<String> techKeys = new ArrayList<String>();
        if (tsl != null) {
            for (Object ts : tsl) {
                String tk;
                if (!(ts instanceof HashStructure) || (tk = ((HashStructure)ts).getString("#text")) == null) continue;
                techKeys.add(tk.trim());
            }
        }
        String weight = migrator.getString("weight/#text");
        MetaClass type = LazyClassAdapter.getInstance(migrator).getMetaClass("class/#text");
        if (key == null || key.length() == 0) {
            key = type.getClassName();
        }
        return new NodeMigratorHelperReference(key, version, type, weight != null ? Integer.valueOf(Integer.parseInt(weight)) : null, techKeys);
    }

    public static enum MigratorType {
        APPLICATION,
        PROJECT;

    }
}

