/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.Color;
import java.awt.Cursor;
import java.net.URL;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.log.StyledMessage;

public abstract class Href
extends StyledMessage {
    protected final URL _url;
    private static int hrefColor;
    private static SimpleAttributeSet attributeSet;

    public Href(String text, URL url) {
        this(text, url, Href.getDefaultAttributeSet());
    }

    public Href(String text, URL url, AttributeSet attributeSet) {
        super(attributeSet, text);
        this._url = url;
    }

    public final URL getURL() {
        return this._url;
    }

    public abstract void go();

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public static synchronized SimpleAttributeSet getDefaultAttributeSet() {
        if (attributeSet == null) {
            attributeSet = new SimpleAttributeSet();
            StyleConstants.setUnderline(attributeSet, true);
        }
        EnvironOptions environOptions = EnvironOptions.getInstance(Preferences.getPreferences());
        if (hrefColor == 0 || hrefColor != environOptions.getLogHrefColor()) {
            hrefColor = environOptions.getLogHrefColor();
            StyleConstants.setForeground(attributeSet, new Color(hrefColor));
        }
        return attributeSet;
    }
}

