/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.Layouts;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;

final class LayoutActivator
implements Observer {
    private JLabel _label;
    private ComboBoxModel _model;
    private Layouts _layouts;
    private IdeLayout _lastActive;
    private boolean _modelInit;

    private void whenSelectionChanges() {
        Layout layout = this.getSelectedLayout();
        if (!this._modelInit && layout != null && this._layouts.getActive() != layout && layout.getOwner().isActive()) {
            this._layouts.activateLayout(layout);
        }
        if (layout != null) {
            this.getLabel().setText(layout.getName());
        }
    }

    public LayoutActivator(Layouts layouts) {
        this._layouts = layouts;
    }

    public JComponent getGUI() {
        return this.getLabel();
    }

    public Layout getSelectedLayout() {
        Layout ret = null;
        if (this._model != null) {
            ret = (Layout)this._model.getSelectedItem();
        }
        return ret;
    }

    public void setSelectedLayout(Layout layout) {
        if (this._model != null) {
            this._model.setSelectedItem(layout);
            this.whenSelectionChanges();
        }
    }

    public void update() {
        this.initModel(this._layouts.getActiveLayout());
    }

    public void hide() {
        JComponent gui = this.getGUI();
        if (gui != null) {
            gui.setVisible(false);
            if (this._lastActive != null) {
                this._lastActive.detach(this);
            }
        }
    }

    public void show() {
        JComponent gui = this.getGUI();
        if (gui != null && !gui.isVisible()) {
            this.update();
            gui.setVisible(true);
        }
    }

    @Override
    public void update(Object observed, UpdateMessage change) {
        int msgID;
        if (observed == this._lastActive && (msgID = change.getMessageID()) == UpdateMessage.STRUCTURE_CHANGED) {
            this.update();
        }
    }

    protected void initModel(IdeLayout layout) {
        if (this._lastActive != null) {
            this._lastActive.detach(this);
        }
        this._lastActive = layout;
        this._lastActive.attach(this);
        Vector<Layout> items = new Vector<Layout>();
        items.add(layout.getDefaults());
        this.addItems(layout, items);
        this._model = new DefaultComboBoxModel(items);
        Layout active = layout.getActiveLayout() != null ? layout.getActiveLayout() : layout.getDefaults();
        this._modelInit = true;
        this._model.setSelectedItem(active);
        this.whenSelectionChanges();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                LayoutActivator.this.getGUI().updateUI();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
        this._modelInit = false;
    }

    protected IdeLayout getLastActive() {
        return this._lastActive;
    }

    private JLabel getLabel() {
        if (this._label == null) {
            this._label = new JLabel();
            Border border = this.getMouseOutBorder();
            this._label.setBorder(border);
        }
        return this._label;
    }

    private Border getMouseOutBorder() {
        return BorderFactory.createEmptyBorder(3, 3, 3, 3);
    }

    private void addItems(Element layout, List list) {
        Iterator<Element> children = layout.getChildren();
        if (children != null) {
            while (children.hasNext()) {
                Element child = children.next();
                list.add(child);
                this.addItems(child, list);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

