/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutListener;
import oracle.ide.layout.URL2String;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;

public abstract class AbstractLayoutListener
implements LayoutListener {
    private HashMap views = new HashMap();

    @Override
    public synchronized void close(Layout layout) {
        this.save(layout);
        for (View view : this.views.values()) {
            view.close();
        }
    }

    @Override
    public synchronized View getView(ViewId id) {
        return (View)this.views.get(id.getId());
    }

    @Override
    public synchronized void addView(ViewId id, View view) {
        this.views.put(id.getId(), view);
    }

    @Override
    public synchronized void removeView(View view) {
        this.views.remove(view.getId());
    }

    @Override
    public synchronized void addOpenedViews(Layout layout, List openedList) {
        Iterator iterator = this.views.values().iterator();
        while (iterator.hasNext()) {
            openedList.add(iterator.next());
        }
    }

    protected boolean isVisible(String viewId, Layout layout) {
        String visProp = viewId + ".visible";
        String visVal = layout.getProperty(visProp, null);
        Boolean visible = false;
        if (visVal != null && visVal.length() > 0) {
            visible = Boolean.valueOf(visVal);
        }
        return visible;
    }

    public static URL getURL(String urlProp, PropertyAccess layout) {
        String urlStr = layout.getProperty(urlProp, null);
        URL url = null;
        if (urlStr != null && urlStr.length() > 0) {
            url = URL2String.toURL(urlStr);
        }
        return url;
    }

    public static Node getNode(String urlProp, PropertyAccess layout, boolean always) {
        URL url = AbstractLayoutListener.getURL(urlProp, layout);
        Node node = null;
        if (url != null && (always || URLFileSystem.exists((URL)url))) {
            try {
                node = NodeFactory.findOrCreate(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return node;
    }

    public static Node getNode(String urlProp, Layout layout) {
        return AbstractLayoutListener.getNode(urlProp, layout, true);
    }

    public static Project getProject(String viewId, Layout layout) {
        String prop = viewId + ".project";
        return (Project)AbstractLayoutListener.getNode(prop, layout);
    }

    public static Workspace getWorkspace(String viewId, Layout layout) {
        String prop = viewId + ".workspace";
        return (Workspace)AbstractLayoutListener.getNode(prop, layout);
    }
}

