/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.util.ArrayList;
import oracle.ide.Ide;
import oracle.ide.controller.ActionFilter;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MultiInputMap;

public final class MultiMapAdapter {
    private static final ArrayList<ActionFilter> _filters = new ArrayList();

    private static void fillMap(MultiInputMap mm, KeyStrokeMap ksm) {
        mm.clear();
        for (KeyStrokes kss : ksm.keySet()) {
            Integer bind = ksm.getBindingFor(kss);
            if (!MultiMapAdapter.actionIsVisible(bind)) continue;
            mm.put(kss, (Object)bind);
        }
    }

    private static boolean actionIsVisible(Integer bind) {
        if (!_filters.isEmpty()) {
            String cmdName = Ide.findCmdName(bind);
            for (ActionFilter filter : _filters) {
                if (filter.accept(cmdName)) continue;
                return false;
            }
        }
        return true;
    }

    private static MultiInputMap getMap(KeyStrokeMap ksm) {
        MultiInputMap mm = new MultiInputMap();
        if (ksm != null) {
            MultiMapAdapter.fillMap(mm, ksm);
        }
        return mm;
    }

    public static void addActionFilter(ActionFilter filter) {
        if (filter == null) {
            throw new NullPointerException("The filter cannot be null.");
        }
        _filters.add(filter);
    }

    public static void removeActionFilter(ActionFilter filter) {
        _filters.remove(filter);
    }

    public static MultiInputMap getGlobalMap(KeyStrokeOptions kso) {
        MultiInputMap mm = MultiMapAdapter.getMap(kso.getGlobalKeyMap());
        return mm;
    }

    public static void fillGlobalMap(MultiInputMap mim, KeyStrokeOptions kso) {
        KeyStrokeMap globalKeyMap = kso.getGlobalKeyMap();
        if (globalKeyMap != null) {
            MultiMapAdapter.fillMap(mim, globalKeyMap);
        }
    }

    public static MultiInputMap getLocalMap(KeyStrokeOptions kso, KeyStrokeContext ksc) {
        KeyStrokeMap localKeyMap = kso.getLocalKeyMap(ksc);
        MultiInputMap mm = MultiMapAdapter.getMap(localKeyMap);
        return mm;
    }

    public static void fillLocalMap(MultiInputMap mim, KeyStrokeOptions kso, KeyStrokeContext ksc) {
        KeyStrokeMap localKeyMap = kso.getLocalKeyMap(ksc);
        if (localKeyMap != null) {
            MultiMapAdapter.fillMap(mim, localKeyMap);
        }
    }
}

