/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.util.logging.Logger;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContext;

final class ActionElement
implements Comparable<ActionElement> {
    final IdeAction _act;
    final KeyStrokeContext _ksc;
    final boolean _bGlobal;
    private String _internalName;
    private static final Logger LOGGER = Logger.getLogger(ActionElement.class.getName());

    ActionElement(KeyStrokeContext ksc, IdeAction act, boolean bGlobal) {
        this._ksc = ksc;
        this._act = act;
        this._bGlobal = bGlobal;
    }

    public final String toString() {
        if (this._internalName == null) {
            String s = (String)this._act.getValue("NoCtxName");
            if (s != null && !s.isEmpty()) {
                this._internalName = s;
                return this._internalName;
            }
            String name = (String)this._act.getValue("Name");
            if (name != null) {
                this._internalName = name;
                return this._internalName;
            }
            int commandId = this._act.getCommandId();
            String command = this._act.getCommand();
            String message = "Action has no name: Command id = " + commandId + " ; Command = " + command;
            Object[] keys = this._act.getKeys();
            if (keys != null) {
                StringBuilder b = new StringBuilder(message);
                b.append(" (");
                String delim = "";
                for (Object o : keys) {
                    b.append(delim);
                    b.append(o);
                    b.append(" = ");
                    b.append(this._act.getValue(o.toString()));
                    delim = "; ";
                }
                b.append(")");
                message = b.toString();
            }
            LOGGER.warning(message);
            this._internalName = "";
        }
        return this._internalName;
    }

    @Override
    public int compareTo(ActionElement o) {
        return Integer.valueOf(this._act.getCommandId()).compareTo(o._act.getCommandId());
    }
}

