/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension.rules.functions;

import java.util.Map;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleFunctionParameter;

public final class PropertyHasValue
extends RuleFunction {
    private static final String _NAME_KEY = "property-name";
    private static final String _VALUE_KEY = "property-value";
    private static final String _PARTIAL_MATCH_KEY = "partial-match";

    @Override
    public boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        RuleFunctionParameter paramName = this.getRequiredParameterOrThrow(parameters, _NAME_KEY);
        RuleFunctionParameter paramValue = this.getRequiredParameterOrThrow(parameters, _VALUE_KEY);
        String val = String.valueOf(System.getProperty(paramName.getValue()));
        if (this.partialMatch(parameters)) {
            return val != null && !val.isEmpty() && val.toLowerCase().indexOf(paramValue.getValue().toLowerCase()) != -1;
        }
        return paramValue.getValue().equalsIgnoreCase(val);
    }

    private final boolean partialMatch(Map<String, RuleFunctionParameter> parameters) {
        RuleFunctionParameter param = parameters.get(_PARTIAL_MATCH_KEY);
        if (param != null) {
            return Boolean.valueOf(param.getValue());
        }
        return false;
    }
}

