/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension.rules.functions;

import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;

public final class ContextHasDependencyExplorableNode
extends RuleFunction {
    private static final Set<String> NON_SEARCHABLE_TYPES = new HashSet<String>();

    @Override
    public boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        Node node = ruleContext.getIdeContext().getNode();
        if (node == null) {
            return false;
        }
        URL url = node.getURL();
        if (url == null) {
            return false;
        }
        return ContextHasDependencyExplorableNode.canSearchAdfDependencies(url);
    }

    public static boolean canSearchAdfDependencies(URL url) {
        if (!"file".equals(url.getProtocol())) {
            return false;
        }
        return !NON_SEARCHABLE_TYPES.contains(URLFileSystem.getSuffix((URL)url));
    }

    static {
        NON_SEARCHABLE_TYPES.add(".java");
        NON_SEARCHABLE_TYPES.add(".properties");
        NON_SEARCHABLE_TYPES.add(".jws");
        NON_SEARCHABLE_TYPES.add(".jpr");
        NON_SEARCHABLE_TYPES.add(".gif");
        NON_SEARCHABLE_TYPES.add(".jpg");
        NON_SEARCHABLE_TYPES.add(".png");
    }
}

