/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.ExtensionProcessorContext;
import oracle.ide.extension.ExtensionProcessorPlugin;

public class PropertiesExtensionProcessorPlugin
extends ExtensionProcessorPlugin {
    private File file;
    private Map<String, String> values;

    public PropertiesExtensionProcessorPlugin(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getSupportedMacros(ExtensionProcessorContext context) {
        if (this.values == null) {
            this.values = new HashMap<String, String>();
            Properties properties = new Properties();
            InputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(this.file));
                if (this.file.getName().endsWith(".xml")) {
                    properties.loadFromXML(stream);
                } else {
                    properties.load(stream);
                }
                File directory = this.file.getParentFile();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String value = (String)entry.getValue();
                    if (value.startsWith("file:")) {
                        int end;
                        StringBuilder builder = new StringBuilder();
                        int start = 0;
                        while ((end = value.indexOf(44, start)) >= 0) {
                            builder.append(this.resolve(value.substring(start, end).trim(), directory));
                            builder.append(',');
                            start = end + 1;
                        }
                        builder.append(this.resolve(value.substring(start), directory));
                        value = builder.toString();
                    }
                    this.values.put((String)entry.getKey(), value);
                }
            }
            catch (IOException e) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "exception loading extension macro definitions from " + this, e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "exception closing " + this, e);
                    }
                }
            }
        }
        return this.values.keySet();
    }

    private String resolve(String path, File directory) {
        if (path.startsWith("file:") && (path = path.substring("file:".length())).length() > 0 && !new File(path).isAbsolute()) {
            path = new File(directory, path).getAbsolutePath();
        }
        return path;
    }

    @Override
    public String expandValue(ExtensionProcessorContext context, String macroName) {
        return this.values.get(macroName);
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }
}

