/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.GraphicsEnvironment;
import javax.swing.SwingUtilities;
import oracle.ide.controller.IdeAction;
import oracle.ide.osgi.boot.api.SplashScreen;
import org.openide.util.Lookup;

public abstract class WindowManagerStartingController {
    private static WindowManagerStartingController controller;
    private static boolean initialized;

    public static synchronized WindowManagerStartingController getInstance() {
        if (controller == null && !initialized) {
            controller = (WindowManagerStartingController)Lookup.getDefault().lookup(WindowManagerStartingController.class);
        }
        initialized = true;
        return controller;
    }

    public abstract boolean isStarting();

    public boolean isSplashScreenShowing() {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        SplashScreen splashScreen = SplashScreen.getInstance();
        return splashScreen != null ? splashScreen.isShowing() : false;
    }

    protected void afterStarted() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WindowManagerStartingController.destroySplashScreen();
                WindowManagerStartingController.showTipOfTheDay();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static void destroySplashScreen() {
        if (SplashScreen.getInstance() != null) {
            SplashScreen.getInstance().destroy();
        }
    }

    private static void showTipOfTheDay() {
        IdeAction action = IdeAction.find("oracle.jdevimpl.help.tipOfDayOnStartup");
        if (action != null) {
            try {
                action.performAction();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static {
        initialized = false;
    }
}

