/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Animator;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableDragContext;
import oracle.ide.docking.DockableDragSource;
import oracle.ide.docking.DockableDropTarget;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.Drawer;
import oracle.ide.docking.DrawerBundle;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.docking.DrawerDecorator;
import oracle.ide.docking.DrawerLayoutUtil;
import oracle.ide.docking.DrawerUI;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.docking.DrawerWindowLayout;
import oracle.ide.docking.DrawerWindowModel;
import oracle.ide.docking.DrawerWindowTray;
import oracle.ide.docking.LazyDrawerUpdateProvider;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

final class DrawerWindowUI
extends JPanel
implements DockableDropTarget {
    private static final int COLLAPSE_SMALL_DRAWERS_THRESHOLD = 20;
    private static boolean actionsCreated;
    private final List<Drawer> hidden = new ArrayList<Drawer>();
    private static final int PREVIOUS_SIZE_NOT_SET = -1;
    private final DockableDragSource dragSource = new DockableDragSourceImpl();
    private final DrawerWindow drawerWindow;
    private final BottomComponent bottomComponent;
    private List<Double> drawerRatios;
    private int dropFeedbackPos = -1;
    private Point relativeStartPoint;
    private DockableDragContext dockableDragContext;
    private DrawerUI activeDrawer;
    private int previousHeight = -1;
    private int previousWidth = -1;
    private final DrawerWindowLayout layout = new DrawerWindowLayout(this);
    private DrawerWindowTray tray;
    private boolean expandOneDrawerAtATime;
    private boolean hideHandleIfOnlyOneDrawerShown;
    private boolean expandDrawerOnActivation;
    private AtomicInteger invalidateDisabledCounter = new AtomicInteger(0);

    private static void createActions() {
        if (actionsCreated) {
            return;
        }
        String menuWord = DrawerBundle.get("DRAWER_MENU");
        if (Themes.isThemed()) {
            DrawerWindowUI.createAction(DrawerWindow.DROP_DOWN_ACTION_ID, menuWord);
        } else {
            DrawerWindowUI.createDropdownAction(DrawerWindow.DROP_DOWN_ACTION_ID, menuWord);
        }
        DrawerWindowUI.createAction(DrawerWindow.MINIMIZE_ACTION_ID, DrawerBundle.get("DRAWER_MINIMIZE"));
        DrawerWindowUI.createAction(DrawerWindow.CLOSE_ACTION_ID, DrawerBundle.get("DRAWER_CLOSE"));
        actionsCreated = true;
    }

    public static IdeAction createAction(int cmdId, String name, ArrayResourceBundle bundle, int key) {
        return IdeAction.get(cmdId, (String)null, name, null, null, bundle, key, null, true);
    }

    private static IdeAction createDropdownAction(int cmdId, String name) {
        return IdeAction.get(cmdId, null, name, null, null, OracleIcons.getIcon((String)"extras/dropdown.png"), null, true);
    }

    private static IdeAction createAction(int cmdId, String name) {
        return IdeAction.get(cmdId, null, name, null, null, null, null, true);
    }

    Component bottomComponent() {
        return this.bottomComponent;
    }

    int dropFeedbackPos() {
        return this.dropFeedbackPos;
    }

    public DrawerWindowUI(DrawerWindow drawerWindow) {
        DrawerWindowUI.createActions();
        this.drawerWindow = drawerWindow;
        this.bottomComponent = new BottomComponent();
        this.setUpAndAddBottomComponent();
        this.setUpMaps();
        this.setOpaque(false);
        this.registerListener();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DrawerWindowUI.this.updatePreviousHeight(e.getComponent().getHeight());
                DrawerWindowUI.this.updatePreviousWidth(e.getComponent().getWidth());
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (DrawerWindowUI.this.activeDrawer != null) {
                    DrawerWindowUI.this.expandIfNecessary(DrawerWindowUI.this.activeDrawer);
                    DrawerWindowUI.this.activeDrawer.requestFocusInWindow();
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (SwingUtilities.isEventDispatchThread() && "ancestor".equals(evt.getPropertyName()) && evt.getNewValue() == null && DrawerWindowUI.this.tray != null && DrawerWindowUI.this.tray.visible()) {
                    DrawerWindowUI.this.tray.collapse();
                }
            }
        });
    }

    private void updatePreviousHeight(int previousHeight) {
        this.previousHeight = previousHeight;
    }

    private void updatePreviousWidth(int previousWidth) {
        this.previousWidth = previousWidth;
    }

    private void setUpAndAddBottomComponent() {
        this.bottomComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerWindowUI.this.trayClicked();
            }
        });
        this.add(this.bottomComponent);
    }

    void expandOneDrawerAtATime() {
        this.expandOneDrawerAtATime = true;
    }

    void hideHandleIfOnlyOneDrawerShown() {
        this.hideHandleIfOnlyOneDrawerShown = true;
    }

    void expandDrawerOnActivation() {
        this.expandDrawerOnActivation = true;
    }

    void updateDrawerHandlesVisibility() {
        if (!this.hideHandleIfOnlyOneDrawerShown) {
            return;
        }
        List<DrawerUI> visibleDrawers = this.visibleDrawers();
        if (visibleDrawers.isEmpty()) {
            return;
        }
        if (visibleDrawers.size() == 1) {
            DrawerUI onlyDrawer = visibleDrawers.get(0);
            onlyDrawer.hideHandle();
            onlyDrawer.expanded(true);
            return;
        }
        for (DrawerUI drawer : visibleDrawers) {
            drawer.showHandle();
        }
    }

    private void trayClicked() {
        this.tray = new DrawerWindowTray(this);
        for (Drawer drawer : this.model().drawers()) {
            if (!drawer.minimizedButVisible()) continue;
            this.tray.addEntry(drawer);
        }
        if (!this.tray.isEmpty()) {
            this.tray.expand();
        }
    }

    private void setUpMaps() {
        AbstractAction minimizeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof DrawerWindowUI) {
                    DrawerUI drawerUI = DrawerWindowUI.this.focusedDrawer();
                    if (DrawerWindowUI.this.focusedDrawer() == null) {
                        return;
                    }
                    View view = drawerUI.getView();
                    if (view == null) {
                        return;
                    }
                    DrawerWindowUI.this.drawerWindow.minimize(view);
                    DrawerWindowUI.this.drawerWindow.activate(view, true);
                }
            }

            @Override
            public boolean isEnabled() {
                return DrawerWindowUI.this.visibleDrawers().size() > 1;
            }
        };
        AbstractAction previousPanelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerWindowUI.this.previousPanel();
            }
        };
        AbstractAction nextPanelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerWindowUI.this.nextPanel();
            }
        };
        AbstractAction closePanelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerWindowUI.this.closePanel();
            }
        };
        AbstractAction openPanelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerWindowUI.this.openPanel();
            }
        };
        AbstractAction focusNextComponent = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerUI drawerUI = DrawerWindowUI.this.focusedDrawer();
                if (drawerUI != null) {
                    drawerUI.focusToolbar();
                }
            }
        };
        this.setUpInputMap(previousPanelAction, nextPanelAction, openPanelAction, closePanelAction, minimizeAction, focusNextComponent);
        this.setUpActionMap(previousPanelAction, nextPanelAction, openPanelAction, closePanelAction, minimizeAction, focusNextComponent);
    }

    private void setUpInputMap(AbstractAction ... actions) {
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(38, 1), actions[0]);
        inputMap.put(KeyStroke.getKeyStroke(40, 1), actions[1]);
        inputMap.put(KeyStroke.getKeyStroke(39, 1), actions[2]);
        inputMap.put(KeyStroke.getKeyStroke(37, 1), actions[3]);
    }

    private void setUpActionMap(AbstractAction previousPanelAction, AbstractAction nextPanelAction, AbstractAction openPanelAction, AbstractAction closePanelAction, AbstractAction minimizeAction, AbstractAction focusToolbar) {
        ActionMap actionMap = this.getActionMap();
        actionMap.put(previousPanelAction, previousPanelAction);
        actionMap.put(nextPanelAction, nextPanelAction);
        actionMap.put(minimizeAction, minimizeAction);
        actionMap.put(openPanelAction, openPanelAction);
        actionMap.put(closePanelAction, closePanelAction);
    }

    private void registerListener() {
        DrawerWindowModel model = this.model();
        Listener listener = new Listener();
        model.addListener(listener);
        if (model.hasDrawers()) {
            listener.intervalAdded(new ListDataEvent(model, 1, 0, model.drawerCount() - 1));
        }
    }

    private void addDrawer(final Drawer drawer) {
        final DrawerUI drawerUI = drawer.drawerUI();
        final DockableWindow view = drawer.view();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                drawerUI.updateDropDownButton(DrawerWindowUI.this.createDropDown(drawer, view));
            }
        });
        Ide.getMainWindow().registerView(view);
        if (view instanceof DrawerDecorator) {
            Ide.getMainWindow().registerView(view.getViewWithoutDecoration());
        }
        if (!drawer.visible()) {
            return;
        }
        this.addDrawer(drawerUI);
        DockStation.getDockStation().addToCache(view);
    }

    private MenuToolButton createDropDown(Drawer drawer, View view) {
        MenuToolButton dropDown = !Themes.isThemed() ? new MyMenuToolButton((ToggleAction)IdeAction.newLocalAction(DrawerWindow.DROP_DOWN_ACTION_ID, view)) : new MenuToolButton(IdeAction.newLocalAction(DrawerWindow.DROP_DOWN_ACTION_ID, view));
        dropDown.setPaintPopUpIndicator(false);
        if (view instanceof DockableWindow) {
            DockableWindow dockableWindow = (DockableWindow)view;
            for (JComponent c : dockableWindow.getHeaderComponents()) {
                dropDown.add(c);
            }
        }
        if (dropDown.getPopupMenu().getComponentCount() > 0) {
            dropDown.getPopupMenu().addSeparator();
        }
        dropDown.addPopupItem(IdeAction.newLocalAction(DrawerWindow.MINIMIZE_ACTION_ID, view));
        if (drawer.canBeClosed()) {
            dropDown.addPopupItem(IdeAction.newLocalAction(DrawerWindow.CLOSE_ACTION_ID, view));
        }
        dropDown.setBorder(BorderFactory.createEmptyBorder());
        dropDown.setContentAreaFilled(false);
        dropDown.setBorderPainted(false);
        dropDown.setOpaque(false);
        dropDown.setFocusable(false);
        return dropDown;
    }

    private void runWithInvalidateDisabled(Runnable runnable) {
        this.invalidateDisabledCounter.incrementAndGet();
        try {
            runnable.run();
        }
        finally {
            this.invalidateDisabledCounter.decrementAndGet();
        }
    }

    void addDrawer(final DrawerUI drawerUI) {
        this.runWithInvalidateDisabled(new Runnable(){

            @Override
            public void run() {
                DrawerWindowUI.this.add(drawerUI);
                DrawerWindowUI.this.visibleDrawerCountChanged();
                List<DrawerUI> drawers = DrawerWindowUI.this.visibleDrawers();
                if (drawers.size() != 1) {
                    return;
                }
                drawerUI.expanded(true);
            }
        });
    }

    private void removeDrawer(Drawer drawer) {
        DockStation.getDockStation().removeFromCache(drawer.uniqueName());
        Ide.getMainWindow().unregisterView(drawer.view());
        DrawerUI drawerUI = drawer.drawerUI();
        if (drawerUI != null) {
            this.removeDrawer(drawerUI);
        }
    }

    void removeDrawer(DrawerUI drawerUI) {
        this.remove(drawerUI);
        this.visibleDrawerCountChanged();
    }

    private void visibleDrawerCountChanged() {
        List<DrawerUI> drawers = this.visibleDrawers();
        boolean minimizable = drawers.size() > 1;
        for (DrawerUI drawer : drawers) {
            drawer.minimizable(minimizable);
        }
    }

    private void previousPanel() {
        this.previousOrNextPanel(-1, false);
    }

    private void nextPanel() {
        this.previousOrNextPanel(1, false);
    }

    void previousOrNextPanel(int direction, boolean expand) {
        DrawerUI focusedDrawer = this.focusedDrawer();
        if (focusedDrawer == null) {
            return;
        }
        List<DrawerUI> drawers = this.visibleDrawers();
        int focusedDrawerIndex = drawers.indexOf(focusedDrawer);
        focusedDrawer.deactivate();
        int activateDrawerIndex = (focusedDrawerIndex + direction + drawers.size()) % drawers.size();
        DrawerUI activateDrawer = drawers.get(activateDrawerIndex);
        if (expand) {
            List<DrawerUI> expandedDrawers = this.expandedDrawers();
            expandedDrawers.remove(activateDrawer);
            this.toggleWithAnimation(this.drawerList(activateDrawer), expandedDrawers);
        }
        activateDrawer.focusDrawerLabel();
        this.ensureHighlightConsistency(activateDrawer);
    }

    private void ensureHighlightConsistency(DrawerUI selected) {
        for (DrawerUI d : this.visibleDrawers()) {
            if (selected == d) {
                d.activate();
                continue;
            }
            d.deactivate();
        }
    }

    private void closePanel() {
        DrawerUI focusedDrawer = this.focusedDrawer();
        if (focusedDrawer == null) {
            return;
        }
        focusedDrawer.deactivate();
        List<DrawerUI> expandedDrawers = this.expandedDrawers();
        expandedDrawers.remove(focusedDrawer);
        this.toggleWithAnimation(expandedDrawers, this.drawerList(focusedDrawer));
        focusedDrawer.focusDrawerLabel();
        focusedDrawer.activate();
    }

    private void openPanel() {
        DrawerUI focusedDrawer = this.focusedDrawer();
        if (focusedDrawer == null) {
            return;
        }
        List<DrawerUI> collapsedDrawers = this.visibleDrawers();
        List<DrawerUI> expandedDrawers = this.expandedDrawers();
        expandedDrawers.add(focusedDrawer);
        collapsedDrawers.removeAll(expandedDrawers);
        this.toggleWithAnimation(expandedDrawers, collapsedDrawers);
        if (focusedDrawer == null || focusedDrawer.focusableFromHosted() == null) {
            return;
        }
        focusedDrawer.focusableFromHosted().requestFocus();
    }

    private DrawerUI focusedDrawer() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        for (DrawerUI drawer : this.visibleDrawers()) {
            if (!SwingUtilities.isDescendingFrom(focusOwner, drawer)) continue;
            return drawer;
        }
        return null;
    }

    List<DrawerUI> visibleDrawers() {
        ArrayList<DrawerUI> drawers = new ArrayList<DrawerUI>();
        for (Drawer drawer : this.model().drawers()) {
            if (!drawer.visible()) continue;
            drawers.add(drawer.drawerUI());
        }
        return drawers;
    }

    private int minimizedButVisibleDrawerCount() {
        int count = 0;
        for (Drawer drawer : this.model().drawers()) {
            if (!drawer.minimizedButVisible()) continue;
            ++count;
        }
        return count;
    }

    List<DrawerUI> expandedDrawers() {
        ArrayList<DrawerUI> drawers = new ArrayList<DrawerUI>();
        for (DrawerUI drawer : this.visibleDrawers()) {
            if (!drawer.expanded()) continue;
            drawers.add(drawer);
        }
        return drawers;
    }

    private DrawerWindowModel model() {
        return this.drawerWindow.model();
    }

    void expand(DrawerUI drawer) {
        this.expand(this.drawerList(drawer));
    }

    void expand(DrawerUI drawer, double ratio) {
        drawer.ratio(ratio);
        this.expand(this.drawerList(drawer));
    }

    void expand(List<DrawerUI> drawers) {
        this.toggleWithAnimation(drawers, null);
    }

    void toggleWithAnimation(List<DrawerUI> toExpand, List<DrawerUI> toCollapse) {
        this.toggle(toExpand, toCollapse, true);
    }

    void toggleWithoutAnimation(List<DrawerUI> toExpand, List<DrawerUI> toCollapse) {
        this.toggle(toExpand, toCollapse, false);
    }

    private void toggle(List<DrawerUI> toExpand, List<DrawerUI> toCollapse, boolean animate) {
        if (toExpand != null) {
            for (DrawerUI drawerUI : toExpand) {
                this.replaceEmptyDrawer(drawerUI, DrawerState.EXPAND);
            }
        }
        if (animate && !Themes.isThemed()) {
            this.animateToggle(toExpand, toCollapse);
        } else {
            this.setExpansionRatio(toExpand, 1.0);
            this.setExpansionRatio(toCollapse, 0.0);
            this.invalidateAndValidate();
        }
    }

    private void animateToggle(List<DrawerUI> toExpand, List<DrawerUI> toCollapse) {
        if (!this.isShowing()) {
            return;
        }
        Animator.animate(30, 400L, 10, 0.6, 0.14, this.toggleAnimationListener(toExpand, toCollapse));
    }

    private PropertyChangeListener toggleAnimationListener(List<DrawerUI> toExpand, List<DrawerUI> toCollapse) {
        final List<DrawerUI> e = toExpand;
        final List<DrawerUI> c = toCollapse;
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                double expansionRatio = (Double)evt.getNewValue();
                DrawerWindowUI.this.setExpansionRatio(e, expansionRatio);
                DrawerWindowUI.this.setExpansionRatio(c, 1.0 - expansionRatio);
                DrawerWindowUI.this.invalidateAndValidate();
                if (Themes.isThemed()) {
                    Graphics g = DrawerWindowUI.this.getGraphics();
                    DrawerWindowUI.this.paint(g);
                    g.dispose();
                } else {
                    DrawerWindowUI.this.repaint();
                }
            }
        };
    }

    private void setExpansionRatio(List<DrawerUI> drawers, double expansionRatio) {
        if (drawers == null) {
            return;
        }
        for (DrawerUI drawer : drawers) {
            drawer.expansionRatio(expansionRatio);
        }
    }

    void toggleVisibility(DrawerUI drawer) {
        if (this.expandOneDrawerAtATime) {
            this.toggleVisibilityClosingOneAtATime(drawer);
            return;
        }
        this.toggleVisibilityTreeViewLike(drawer);
    }

    void activate(DrawerUI drawer) {
        this.deactivateActiveDrawer();
        drawer.activate();
        this.activeDrawer = drawer;
    }

    void expandIfNecessary(DrawerUI drawer) {
        if (drawer.expanded() || !this.expandDrawerOnActivation) {
            return;
        }
        this.toggleVisibility(drawer);
    }

    void deactivateActiveDrawer() {
        if (this.activeDrawer != null) {
            this.deactivate(this.activeDrawer);
        }
        this.activeDrawer = null;
    }

    void deactivate(DrawerUI drawer) {
        drawer.deactivate();
    }

    private void toggleVisibilityTreeViewLike(DrawerUI drawer) {
        ArrayList<DrawerUI> toExpand = new ArrayList<DrawerUI>(this.expandedDrawers());
        ArrayList<DrawerUI> toCollapse = new ArrayList<DrawerUI>();
        if (!drawer.expanded()) {
            for (DrawerUI d : toExpand) {
                d.shouldNotRotateIcon();
            }
            this.activate(drawer);
            toExpand.add(drawer);
        } else {
            toCollapse.add(drawer);
            this.deactivate(drawer);
            this.deactivateActiveDrawer();
            toExpand.remove(drawer);
            if (!toExpand.isEmpty()) {
                this.activate((DrawerUI)toExpand.get(0));
                for (DrawerUI d : toExpand) {
                    d.shouldNotRotateIcon();
                }
            }
        }
        this.toggleWithAnimation(toExpand, toCollapse);
        for (DrawerUI d : toExpand) {
            d.shouldRotateIcon();
        }
    }

    private void toggleVisibilityClosingOneAtATime(DrawerUI drawer) {
        if (!drawer.expanded()) {
            this.toggleWithAnimation(this.drawerList(drawer), this.expandedDrawers());
            return;
        }
        this.toggleWithAnimation(null, this.drawerList(drawer));
    }

    private DrawerUI firstCollapsedDrawer() {
        for (DrawerUI drawer : this.visibleDrawers()) {
            if (drawer.expanded()) continue;
            return drawer;
        }
        return null;
    }

    void mousePressed(DrawerUI drawer, MouseEvent event) {
        List<DrawerUI> drawers = this.visibleDrawers();
        int drawerCount = drawers.size();
        this.drawerRatios = new ArrayList<Double>(drawerCount);
        for (int i = 0; i < drawerCount; ++i) {
            this.drawerRatios.add(drawers.get(i).ratio());
        }
        this.onMousePressed(drawer, event);
    }

    private void onMousePressed(DrawerUI drawer, MouseEvent event) {
        this.relativeStartPoint = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), drawer);
    }

    void mouseReleased(DrawerUI drawer, MouseEvent event) {
        this.onMouseReleased(drawer, event);
        this.closeSmallDrawers();
        this.drawerRatios = null;
    }

    private void onMouseReleased(DrawerUI drawer, MouseEvent event) {
        if (this.dockableDragContext == null) {
            return;
        }
        Point ptScreen = event.getPoint();
        SwingUtilities.convertPointToScreen(ptScreen, event.getComponent());
        this.dockableDragContext.endDrag(ptScreen, this.mouseEventModifiersWithoutCtrlMask(event));
        this.dockableDragContext = null;
    }

    private void closeSmallDrawers() {
        ArrayList<DrawerUI> toCollapse = new ArrayList<DrawerUI>();
        for (DrawerUI drawer : this.expandedDrawers()) {
            if (this.heightOf(drawer) >= 20) continue;
            toCollapse.add(drawer);
        }
        if (toCollapse.isEmpty()) {
            return;
        }
        this.toggleWithAnimation(null, toCollapse);
    }

    private int heightOf(DrawerUI drawer) {
        return drawer.getHeight() - drawer.titlebarHeight();
    }

    void mouseDragged(DrawerUI drawer, MouseEvent event) {
        this.onMouseDragged(drawer, event);
    }

    private void onMouseDragged(DrawerUI drawer, MouseEvent event) {
        if (this.relativeStartPoint == null) {
            return;
        }
        Point ptScreen = event.getPoint();
        SwingUtilities.convertPointToScreen(ptScreen, event.getComponent());
        if (this.dockableDragContext == null) {
            this.initDockableDragContext(drawer, ptScreen);
        }
        if (!this.containsScreenPoint(ptScreen)) {
            return;
        }
        this.dockableDragContext.mouseMoved(ptScreen, this.mouseEventModifiersWithoutCtrlMask(event));
        for (DrawerUI expandedDrawerUI : this.expandedDrawers()) {
            this.replaceEmptyDrawer(expandedDrawerUI, DrawerState.DONOTHING);
        }
    }

    private int mouseEventModifiersWithoutCtrlMask(MouseEvent event) {
        if (!event.isControlDown()) {
            return event.getModifiers();
        }
        return BitField.unset(event.getModifiers(), 2);
    }

    private void initDockableDragContext(DrawerUI drawer, Point ptScreen) {
        this.dockableDragContext = DockStation.getDockStation().createDockableDragContext(this.dragSource);
        this.dockableDragContext.setDockables(new Dockable[]{this.view(drawer)});
        this.dockableDragContext.setStartPoint(ptScreen);
        Dimension drawerSize = drawer.getSize();
        this.dockableDragContext.setPreferredSizes(drawerSize, drawerSize);
    }

    private DockableWindow view(DrawerUI drawer) {
        return this.drawerWindow.view(drawer);
    }

    void minimizeWithAnimation(DrawerUI drawer) {
        this.minimize(drawer, true);
    }

    private void minimize(DrawerUI drawer, boolean animate) {
        this.remove(drawer);
        List<DrawerUI> toExpand = this.toExpandWhenMiminizing(drawer);
        if (toExpand != null) {
            this.expand(toExpand);
            if (!toExpand.isEmpty()) {
                this.activate(toExpand.get(0));
            }
        }
        this.updateTrayIcon(false);
        this.visibleDrawerCountChanged();
        this.showMinimizedDrawerInVisibleTry();
        this.invalidateAndRevalidate();
        this.bottomComponent.requestFocus();
    }

    private void showMinimizedDrawerInVisibleTry() {
        if (this.tray == null || !this.tray.visible()) {
            return;
        }
        this.tray.clear();
        for (Drawer d : this.model().drawers()) {
            if (!d.minimizedButVisible()) continue;
            this.tray.addEntry(d);
        }
    }

    private List<DrawerUI> toExpandWhenMiminizing(DrawerUI toMinimize) {
        List<DrawerUI> expanded = this.expandedDrawers();
        if (expanded.size() > 1) {
            return null;
        }
        if (expanded.size() == 1 && !expanded.contains(toMinimize)) {
            return null;
        }
        return this.drawerList(this.firstCollapsedDrawer());
    }

    private PropertyChangeListener minimizeAnimationListener(final DrawerUI drawer) {
        final Rectangle sourceBounds = drawer.getBounds();
        final Rectangle destBounds = this.bottomComponent.getBounds();
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                double r = (Double)evt.getNewValue();
                int x = (int)((double)sourceBounds.x + (double)(destBounds.x - sourceBounds.x) * r);
                int y = (int)((double)sourceBounds.y + (double)(destBounds.y - sourceBounds.y) * r);
                int width = (int)((double)sourceBounds.width + (double)(destBounds.width - sourceBounds.width) * r);
                int height = (int)((double)sourceBounds.height + (double)(destBounds.height - sourceBounds.height) * r);
                drawer.setBounds(x, y, width, height);
                Graphics g = DrawerWindowUI.this.getGraphics();
                DrawerWindowUI.this.paint(g);
                g.dispose();
            }
        };
    }

    void maximize(DrawerUI drawer) {
        List<DrawerUI> toCollapse = this.expandedDrawers();
        toCollapse.remove(drawer);
        List<DrawerUI> toExpand = drawer.expanded() ? null : this.drawerList(drawer);
        this.toggleWithAnimation(toExpand, toCollapse);
    }

    void addDropFeedback(int position) {
        this.dropFeedbackPos = position;
        this.invalidateAndValidate();
    }

    private void invalidateAndValidate() {
        this.invalidate();
        this.validate();
    }

    void removeDropFeedback() {
        this.addDropFeedback(-1);
    }

    void beStored(StructuredPropertyAccess p) {
        for (DrawerUI drawer : this.visibleDrawers()) {
            DefaultStructuredPropertyAccess propertyAccess = new DefaultStructuredPropertyAccess("Drawer");
            propertyAccess.setProperty("Ratio", Double.toString(drawer.ratio()));
            if (drawer.expanded()) {
                propertyAccess.setBooleanProperty("Expanded", true);
            }
            p.appendChild(propertyAccess);
        }
    }

    void loadLayout(StructuredPropertyAccess layout) {
        List<DrawerUI> drawers = this.visibleDrawers();
        Iterator childNodes = layout.getChildNodes("Drawer");
        for (int i = 0; i < drawers.size() && childNodes.hasNext(); ++i) {
            StructuredPropertyAccess propertyAccess = (StructuredPropertyAccess)childNodes.next();
            double ratio = Double.parseDouble(propertyAccess.getProperty("Ratio", "0"));
            boolean expanded = propertyAccess.getBooleanProperty("Expanded", false);
            DrawerUI drawer = drawers.get(i);
            drawer.ratio(ratio);
            drawer.expanded(expanded);
        }
        this.updateTrayIcon();
    }

    void updateTrayIcon() {
        this.updateTrayIcon(!this.hasMinimizedDrawers());
    }

    private boolean hasMinimizedDrawers() {
        for (Drawer drawer : this.model().drawers()) {
            if (!drawer.minimized()) continue;
            return true;
        }
        return false;
    }

    void restoreWithoutAnimation(Drawer drawer) {
        this.restore(drawer, false);
    }

    void restoreFromMinimizedTray(Drawer drawer, boolean emptyTray) {
        this.restoreWithoutAnimation(drawer);
        this.updateTrayIcon(emptyTray);
        this.updateDrawerHandlesVisibility();
    }

    private Icon emptyTrayIcon() {
        return OracleIcons.getIcon((String)"arrows-default.png");
    }

    private Icon notEmptyTrayIcon() {
        return OracleIcons.getIcon((String)"arrows-closed.png");
    }

    private void updateTrayIcon(boolean emptyTray) {
        String toolTip = emptyTray ? "" : DrawerBundle.get("DRAWER_SEE_MINIMIZED_ITEMS");
        this.bottomComponent.setToolTipText(toolTip);
        this.bottomComponent.updateState(emptyTray);
        Icon icon = emptyTray ? this.emptyTrayIcon() : this.notEmptyTrayIcon();
        this.bottomComponent.setIcon(icon);
    }

    private void restore(Drawer drawer, boolean animate) {
        DrawerUI drawerUI = drawer.drawerUI();
        this.add(drawerUI);
        drawerUI.expanded(false);
        drawer.state(DrawerConfig.State.VISIBLE);
        this.validate();
        ArrayList<DrawerUI> allDrawersToExpand = new ArrayList<DrawerUI>();
        allDrawersToExpand.add(drawerUI);
        allDrawersToExpand.addAll(this.expandedDrawers());
        List<DrawerUI> allDrawersToCollapse = this.visibleDrawers();
        allDrawersToCollapse.removeAll(allDrawersToExpand);
        this.toggle(allDrawersToExpand, allDrawersToCollapse, animate);
        this.activate(drawerUI);
        this.visibleDrawerCountChanged();
    }

    void show(Drawer drawer) {
        this.hidden.remove(drawer);
        this.add(drawer.drawerUI());
        if (DrawerConfig.State.HIDDEN_AND_MINIMIZED.equals((Object)drawer.state())) {
            this.minimize(drawer.drawerUI(), false);
            drawer.state(DrawerConfig.State.MINIMIZED);
        } else {
            drawer.state(DrawerConfig.State.VISIBLE);
        }
        this.visibleDrawerCountChanged();
        this.invalidateAndRevalidate();
    }

    private void invalidateAndRevalidate() {
        this.invalidate();
        this.revalidate();
    }

    void hide(Drawer drawer) {
        this.visibleDrawerCountChanged();
        this.remove(drawer.drawerUI());
        this.invalidateAndRevalidate();
        this.hidden.add(drawer);
        if (drawer.minimized()) {
            this.hideMinimized(drawer);
            return;
        }
        drawer.state(DrawerConfig.State.HIDDEN);
    }

    private void hideMinimized(Drawer drawer) {
        drawer.state(DrawerConfig.State.HIDDEN_AND_MINIMIZED);
        this.updateTrayIcon(this.minimizedButVisibleDrawerCount() == 0);
    }

    private int heightDelta() {
        if (this.previousHeight == -1) {
            return 0;
        }
        return this.getHeight() - this.previousHeight;
    }

    @Override
    public void doLayout() {
        if (this.invalidateDisabledCounter.get() > 0) {
            return;
        }
        int heightDelta = this.heightDelta();
        if (heightDelta != 0) {
            this.updateBottomComponentBounds(this.getInsets());
            this.layout.normalLayout();
            this.resizeTray();
            this.updatePreviousHeight(this.getHeight());
            return;
        }
        this.updateBottomComponentBounds(this.getInsets());
        this.layout.normalLayout();
        this.resizeTray();
    }

    private void resizeTray() {
        if (this.tray != null && this.tray.visible()) {
            this.tray.updatePositionAndSize();
        }
    }

    private void updateBottomComponentBounds(Insets insets) {
        Dimension size = this.bottomComponent.getPreferredSize();
        int y = this.getHeight() - insets.bottom - size.height;
        this.bottomComponent.setBounds(0, y, this.getWidth(), size.height);
    }

    private void onDragCanceled() {
        this.relativeStartPoint = null;
        this.dockableDragContext = null;
    }

    private List<DrawerUI> drawerList(DrawerUI drawer) {
        if (drawer == null) {
            return null;
        }
        return Collections.singletonList(drawer);
    }

    @Override
    public boolean dragEnter(DockableDragContext context, Point point) {
        return this.dragOrAccept(context, point, false);
    }

    @Override
    public boolean dragOver(DockableDragContext context, Point point) {
        return this.dragOrAccept(context, point, false);
    }

    @Override
    public void dragExit(DockableDragContext context) {
        this.removeDropFeedback();
    }

    @Override
    public void acceptDrop(DockableDragContext context, Point point) {
    }

    private Drawer dragged(DockableDragContext context) {
        Dockable[] dockables = context.getDockables();
        if (dockables == null || dockables.length == 0 && !(dockables[0] instanceof DockableWindow)) {
            return null;
        }
        DockableWindow dragged = (DockableWindow)dockables[0];
        int index = this.model().indexOf(dragged);
        if (index == -1) {
            return null;
        }
        return this.model().drawerAt(index);
    }

    private boolean dragOrAccept(DockableDragContext context, Point point, boolean accept) {
        Drawer drawer = this.dragged(context);
        if (drawer == null) {
            return false;
        }
        DrawerUI draggedDrawer = drawer.drawerUI();
        if (this.isDropReorder(point, draggedDrawer)) {
            this.removeDropFeedback();
            Dimension drawerSize = draggedDrawer.getSize();
            this.dockableDragContext.setPreferredSizes(drawerSize, drawerSize);
            return true;
        }
        return true;
    }

    private boolean isDropReorder(Point point, DrawerUI drawer) {
        if (!this.containsScreenPoint(point)) {
            return false;
        }
        int delta = this.newPoint((Point)point, (Component)drawer).y - this.relativeStartPoint.y;
        DrawerUI previous = null;
        DrawerUI next = null;
        List<DrawerUI> drawers = this.visibleDrawers();
        int drawerIndex = drawers.indexOf(drawer);
        if (drawerIndex < 0) {
            return false;
        }
        if (delta < 0) {
            for (int i = drawerIndex - 1; previous == null && i >= 0; --i) {
                if (!drawers.get(i).expanded()) continue;
                previous = drawers.get(i);
            }
            next = drawer;
        } else {
            if (drawerIndex > 0) {
                previous = drawers.get(drawerIndex - 1);
            }
            for (int i = drawerIndex; next == null && i < drawers.size(); ++i) {
                if (!drawers.get(i).expanded()) continue;
                next = drawers.get(i);
            }
        }
        if (next == null && this.expandedDrawers().isEmpty()) {
            next = drawers.get(drawers.size() - 1);
            next.expansionRatio(1.0);
        }
        if (previous == null || next == null) {
            return false;
        }
        this.insideDrag(previous, next, delta);
        return true;
    }

    protected final void insideDrag(DrawerUI drawer1, DrawerUI drawer2, int delta) {
        List<DrawerUI> drawers = this.visibleDrawers();
        double allocatableHeight = this.allocatableHeight(drawers);
        double newRatio1 = this.newRatio(allocatableHeight, drawer1, delta);
        double newRatio2 = this.newRatio(allocatableHeight, drawer2, -delta);
        if (newRatio1 * allocatableHeight < 1.0) {
            newRatio2 += this.recalculateRatioAndCloseDrawer(drawer1);
        }
        if (newRatio2 * allocatableHeight < 1.0) {
            newRatio1 += this.recalculateRatioAndCloseDrawer(drawer2);
        }
        if (newRatio1 * allocatableHeight >= 1.0 && newRatio2 * allocatableHeight >= 1.0) {
            this.expandAndSetRatio(drawer1, newRatio1);
            this.expandAndSetRatio(drawer2, newRatio2);
        }
        this.invalidateAndValidate();
    }

    private double recalculateRatioAndCloseDrawer(DrawerUI drawer) {
        if (drawer == null) {
            return 0.0;
        }
        double r = drawer.ratio();
        drawer.expanded(false);
        double ratio = this.drawerRatios.get(this.indexOf(drawer));
        if (ratio > 0.0) {
            drawer.ratio(ratio);
        }
        return r;
    }

    private void expandAndSetRatio(DrawerUI drawer, double ratio) {
        drawer.expanded(true);
        drawer.ratio(ratio);
    }

    private double allocatableHeight(List<DrawerUI> drawers) {
        int height = this.getHeight();
        Insets insets = this.getInsets();
        int titlebarHeights = 0;
        for (DrawerUI drawer : drawers) {
            titlebarHeights += drawer.titlebarHeight();
        }
        return height - (insets.top + insets.bottom) - titlebarHeights;
    }

    private double newRatio(double allocatableHeight, DrawerUI drawer, int delta) {
        return drawer.ratio() + (double)delta / allocatableHeight;
    }

    private boolean containsScreenPoint(Point point) {
        return this.contains(this.newPoint(point));
    }

    private Point newPoint(Point src) {
        return this.newPoint(src, this);
    }

    private Point newPoint(Point src, Component c) {
        Point point = new Point(src);
        SwingUtilities.convertPointFromScreen(point, c);
        return point;
    }

    private int indexOf(DrawerUI visible) {
        return this.visibleDrawers().indexOf(visible);
    }

    void deactivateAll() {
        for (DrawerUI drawerUI : this.visibleDrawers()) {
            drawerUI.deactivate();
        }
    }

    private void replaceEmptyDrawer(DrawerUI drawerUI, DrawerState state) {
        if (drawerUI.getView().getViewWithoutDecoration() instanceof DrawerWindow.ProxyDrawer) {
            StructuredPropertyAccess spa = DrawerLayoutUtil.getDrawerData(drawerUI.getView().getId());
            Drawer drawer = this.drawerWindow.createDrawer(spa, DrawerLayoutUtil.getGlobal(), false);
            this.drawerWindow.removeIfPresent(drawerUI.getView().getViewWithoutDecoration());
            DockableWindow hostDockable = (DockableWindow)this.drawerWindow.getCachedDockable();
            if (hostDockable instanceof LazyDrawerUpdateProvider) {
                ((LazyDrawerUpdateProvider)((Object)hostDockable)).afterLazyDrawerLoaded(drawer.view());
            }
            switch (state) {
                case EXPAND: {
                    this.drawerWindow.expand(drawer.view().getViewWithoutDecoration());
                    break;
                }
                case DEMINIMIZE: {
                    this.restoreFromMinimizedTray(drawer, true);
                }
            }
        }
    }

    private class MyMenuToolButton
    extends MenuToolButton {
        private Dimension dim;

        public MyMenuToolButton(ToggleAction buttonAction) {
            super(buttonAction);
            this.dim = new Dimension(15, 10);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.getIcon().paintIcon(this, g, 3, 3);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.dim;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.dim;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.dim;
        }

        private boolean isMouseOver() {
            ButtonModel model = this.getModel();
            return model.isRollover();
        }

        @Override
        protected void paintBorder(Graphics g) {
            if (this.isMouseOver()) {
                this.setBorderPainted(true);
                this.setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));
            } else {
                this.setBorderPainted(false);
            }
            super.paintBorder(g);
        }
    }

    private static enum DrawerState {
        EXPAND,
        DEMINIMIZE,
        DONOTHING;

    }

    private class Listener
    implements ListDataListener {
        private Listener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            int index0 = e.getIndex0();
            int index1 = e.getIndex1();
            for (int i = 0; i <= index1 - index0; ++i) {
                DrawerWindowUI.this.addDrawer(DrawerWindowUI.this.model().drawerAt(index0 + i));
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            int index0 = e.getIndex0();
            int index1 = e.getIndex1();
            for (int i = 0; i <= index1 - index0; ++i) {
                DrawerWindowUI.this.removeDrawer(DrawerWindowUI.this.model().drawerAt(index0 + i));
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            throw new UnsupportedOperationException();
        }
    }

    private class DockableDragSourceImpl
    implements DockableDragSource {
        private DockableDragSourceImpl() {
        }

        @Override
        public void canceled() {
            DrawerWindowUI.this.onDragCanceled();
        }
    }

    private static class BottomComponent
    extends JButton {
        State state = State.EMPTY;

        BottomComponent() {
            this.setBorderPainted(false);
            this.setBorderPainted(true);
            this.setContentAreaFilled(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            if (Themes.isThemed()) {
                this.setPreferredSize(new Dimension(10, DrawerWindowTray.getDrawerTrayHeight()));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
                this.setHorizontalAlignment(4);
            }
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!state.equals((Object)State.FULL_MOUSE_EXITED)) {
                        return;
                    }
                    state = State.FULL_MOUSE_ENTERED;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!state.equals((Object)State.FULL_MOUSE_ENTERED)) {
                        return;
                    }
                    state = State.FULL_MOUSE_EXITED;
                    this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Insets insets = this.getInsets();
            int width = this.getWidth();
            int height = this.getHeight();
            String strState = this.state.toString();
            if (this.state == State.FULL_MOUSE_EXITED && this.hasFocus()) {
                strState = State.FULL_MOUSE_ENTERED.toString();
            }
            if (Themes.isThemed()) {
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties("handler", strState.toLowerCase());
                Painter painter = properties.getPainter("bg");
                painter.paint(g, insets.left, insets.top, width, height);
                if (strState != State.FULL_MOUSE_ENTERED.toString()) {
                    properties = Themes.getActiveTheme().getStateProperties("handleredge1", "empty");
                    painter = properties.getPainter("bg");
                    painter.paint(g, insets.left, insets.top, width, height);
                    properties = Themes.getActiveTheme().getStateProperties("handleredge2", "empty");
                    painter = properties.getPainter("bg");
                    painter.paint(g, insets.left, insets.top, width, height);
                }
                properties = Themes.getActiveTheme().getStateProperties("handler", this.state == State.EMPTY ? "default" : "closed");
                Icon icon = properties.getIcon("icon");
                int inset = Themes.getActiveTheme().getStateProperties("handler", "icon").getInt("inset");
                icon.paintIcon(this, g, width - icon.getIconWidth() - inset, (height - icon.getIconHeight()) / 2);
            } else {
                if (strState != State.FULL_MOUSE_ENTERED.toString()) {
                    g.setColor(UIManager.getColor("Panel.background"));
                } else {
                    g.setColor(UIManager.getColor("TextPane.selectionBackground"));
                }
                g.fillRect(insets.left, insets.top, width - insets.left - insets.right, height);
                Icon icon = this.getIcon();
                if (icon != null) {
                    icon.paintIcon(this, g, width - icon.getIconWidth() - 4, height - icon.getIconHeight() - 1);
                }
            }
        }

        void updateState(boolean empty) {
            this.setFocusable(!empty);
            this.state = empty ? State.EMPTY : State.FULL_MOUSE_EXITED;
        }

        @Override
        public boolean isFocusable() {
            return this.state == State.EMPTY ? false : super.isFocusable();
        }

        static enum State {
            EMPTY,
            FULL_MOUSE_ENTERED,
            FULL_MOUSE_EXITED;

        }
    }
}

