/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.ide.controls.Animator;
import oracle.ide.docking.Drawer;
import oracle.ide.docking.DrawerBundle;
import oracle.ide.docking.DrawerWindowUI;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.Pair;

final class DrawerWindowTray
extends JPanel {
    private static final int THEME_MODE_HANDLE_HEIGHT = 14;
    private static int _sHandleHeight = -1;
    private static final String PERMANENT_FOCUS_OWNER_PROPERTY = "permanentFocusOwner";
    private boolean mouseOver;
    private final Listeners listeners = new Listeners();
    private final DrawerWindowUI drawerWindowUI;
    private final JLayeredPane layeredPane;
    private final JScrollPane scrollPane;
    private final JList drawerList;
    private final DefaultListModel drawerListModel = new DefaultListModel();
    private Handle drawerHandle;
    private boolean visible;
    private Component _savedFocusComponent;
    private AnimationRectangleCache animationCacheData = new AnimationRectangleCache();

    boolean visible() {
        return this.visible;
    }

    DrawerWindowTray(DrawerWindowUI drawerWindowUI) {
        super(new BorderLayout());
        this.drawerWindowUI = drawerWindowUI;
        this.layeredPane = this.rootPaneContainer(drawerWindowUI).getLayeredPane();
        this.drawerList = new JList(this.drawerListModel);
        if (Themes.isThemed()) {
            this.drawerList.setOpaque(false);
        } else {
            this.drawerList.setBackground(this.getBackground());
            this.drawerList.setSelectionBackground(UIManager.getColor("TextPane.selectionBackground"));
        }
        this.scrollPane = new JScrollPane(this.drawerList);
        this.scrollPane.setOpaque(false);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.registerListListeners();
        this.setBorders();
        this.drawerHandle = new Handle(0);
        this.add((Component)this.content(), "Center");
    }

    private void registerListListeners() {
        this.drawerList.addMouseListener(this.listeners);
        this.drawerList.setCellRenderer(new CellRenderer());
        this.drawerList.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = DrawerWindowTray.this.drawerList.locationToIndex(e.getPoint());
                DrawerWindowTray.this.drawerList.setSelectedIndex(index);
            }
        });
        this.drawerList.addKeyListener(this.listeners);
    }

    private void setBorders() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scrollPane.setBorder(null);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (Themes.isThemed()) {
            ThemeProperties properties = Themes.getActiveTheme().getStateProperties("minimized", "normal");
            Painter painter = properties.getPainter("bg");
            Insets insets = this.getInsets();
            painter.paint(g, insets.left, insets.top, this.getWidth(), this.getHeight());
        } else {
            super.paintComponent(g);
        }
    }

    private JPanel content() {
        JPanel panel = new JPanel(new BorderLayout());
        ContentPanel bottomPanel = new ContentPanel(new BorderLayout(), "minimized", "minimized1");
        ContentPanel topPanel = new ContentPanel(new GridBagLayout(), "minimized2", "minimized3");
        topPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DrawerWindowTray.this.collapse();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DrawerWindowTray.this.mouseOver = true;
                e.getComponent().getParent().repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DrawerWindowTray.this.mouseOver = false;
                e.getComponent().getParent().repaint();
            }
        });
        TransparentPanel tpanel = new TransparentPanel();
        tpanel.setLayout((LayoutManager)new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        topPanel.add((Component)this.minimizedLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, insets, 0, 0));
        topPanel.add((Component)this.drawerHandle, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        tpanel.add((Component)topPanel, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        bottomPanel.setBorder(JavatoolsBorderFactory.createTopBorder((Color)Color.WHITE, (int)1));
        bottomPanel.add(this.scrollPane);
        tpanel.add((Component)bottomPanel, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        panel.add((Component)tpanel);
        return panel;
    }

    private JLabel minimizedLabel() {
        JLabel label = new JLabel(DrawerBundle.get("DRAWER_MINIMIZED"));
        label.setBackground(Color.GRAY);
        label.setBorder(null);
        label.setAlignmentX(0.5f);
        return label;
    }

    static int getDrawerTrayHeight() {
        if (_sHandleHeight == -1) {
            _sHandleHeight = Themes.isThemed() ? Themes.getActiveTheme().getPartProperties("handler").getInt("height") : 14;
        }
        return _sHandleHeight;
    }

    void addEntry(Drawer drawer) {
        String label = drawer.tabName();
        this.drawerListModel.addElement(new DrawerPair(label, drawer));
    }

    private void onRestore() {
        Pair pair = (Pair)this.drawerList.getSelectedValue();
        if (pair != null) {
            Drawer drawer = (Drawer)pair.second;
            this.drawerListModel.removeElement(pair);
            this.drawerWindowUI.restoreFromMinimizedTray(drawer, this.isEmpty());
            this.collapse();
            drawer.drawerUI().requestFocus();
        }
    }

    void clear() {
        this.drawerListModel.removeAllElements();
    }

    boolean isEmpty() {
        return this.drawerList.getModel().getSize() == 0;
    }

    void collapse() {
        this.layeredPane.removeComponentListener(this.listeners);
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.removePropertyChangeListener(PERMANENT_FOCUS_OWNER_PROPERTY, this.listeners);
        Rectangle from = this.getBounds();
        Rectangle to = new Rectangle(from.x, from.y + from.height, from.width, 0);
        if (!Themes.isThemed()) {
            Animator.animate(30, 500L, new AnimationListener(this.layeredPane, from, to));
        }
        this.layeredPane.remove(this);
        this.layeredPane.repaint();
        this.visible = false;
        if (this._savedFocusComponent != null) {
            this._savedFocusComponent.requestFocus();
        }
        this._savedFocusComponent = null;
        this.animationCacheData.clear();
    }

    final void expand() {
        this._savedFocusComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        this.visible = true;
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.layeredPane.add((Component)this, JLayeredPane.MODAL_LAYER);
        this.animateExpansion();
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(PERMANENT_FOCUS_OWNER_PROPERTY, this.listeners);
        this.layeredPane.addComponentListener(this.listeners);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.drawerList.requestFocus();
    }

    private void animateExpansion() {
        Rectangles rectanglesWhenExpanded = new Rectangles();
        Animator.animate(30, 500L, new AnimationListener(this, rectanglesWhenExpanded.from, rectanglesWhenExpanded.to));
    }

    void updatePositionAndSize() {
        this.setBounds((DrawerWindowTray)this.new Rectangles().to);
    }

    private RootPaneContainer rootPaneContainer(Component parent) {
        return (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, parent));
    }

    private class Rectangles {
        final Rectangle from;
        final Rectangle to;

        Rectangles() {
            int theHeightToExpand;
            int dlm = DrawerWindowTray.this.drawerListModel.size();
            if (!(DrawerWindowTray.this.drawerListModel.size() == 0 || DrawerWindowTray.this.animationCacheData.populated() && ((DrawerWindowTray)DrawerWindowTray.this).animationCacheData.numberOfListElements == DrawerWindowTray.this.drawerListModel.size())) {
                int singleCellHeight = DrawerWindowTray.this.animationCacheData.hasPrecomputedCellHeight() ? ((DrawerWindowTray)DrawerWindowTray.this).animationCacheData.singleCellHeight : DrawerWindowTray.this.drawerList.getHeight() / DrawerWindowTray.this.drawerListModel.size();
                int rowsToShow = Math.min(DrawerWindowTray.this.drawerListModel.size(), 3);
                theHeightToExpand = (int)Math.ceil(singleCellHeight * (rowsToShow + 1) + DrawerWindowTray.this.drawerHandle.getHeight());
                ((DrawerWindowTray)DrawerWindowTray.this).animationCacheData.singleCellHeight = singleCellHeight;
                ((DrawerWindowTray)DrawerWindowTray.this).animationCacheData.rectangleHeight = theHeightToExpand;
                ((DrawerWindowTray)DrawerWindowTray.this).animationCacheData.numberOfListElements = DrawerWindowTray.this.drawerListModel.size();
            } else {
                theHeightToExpand = ((DrawerWindowTray)DrawerWindowTray.this).animationCacheData.rectangleHeight;
            }
            int preferredHeight = Math.min(DrawerWindowTray.this.drawerWindowUI.getHeight(), theHeightToExpand);
            Point pt = SwingUtilities.convertPoint(DrawerWindowTray.this.drawerWindowUI, 0, DrawerWindowTray.this.drawerWindowUI.getHeight(), DrawerWindowTray.this.layeredPane);
            this.from = new Rectangle(pt.x, pt.y, DrawerWindowTray.this.drawerWindowUI.getWidth(), 0);
            this.to = new Rectangle(pt.x, pt.y - preferredHeight, DrawerWindowTray.this.drawerWindowUI.getWidth(), preferredHeight);
        }
    }

    private class AnimationRectangleCache {
        int rectangleHeight = -1;
        int numberOfListElements = -1;
        int singleCellHeight = -1;

        private AnimationRectangleCache() {
        }

        void clear() {
            this.rectangleHeight = -1;
            this.numberOfListElements = -1;
            this.singleCellHeight = -1;
        }

        boolean populated() {
            return this.rectangleHeight != -1;
        }

        boolean hasPrecomputedCellHeight() {
            return this.singleCellHeight != -1;
        }
    }

    private class DrawerPair
    extends Pair<String, Drawer> {
        public DrawerPair(String label, Drawer drawer) {
            super((Object)label, (Object)drawer);
        }

        public String toString() {
            String stringResult = null;
            if (this.first != null) {
                stringResult = (String)this.first;
            } else if (this.second != null) {
                stringResult = ((Drawer)this.second).toString();
            }
            return stringResult;
        }
    }

    private class ContentPanel
    extends JPanel {
        private String _top;
        private String _bottom;

        public ContentPanel(LayoutManager layout, String top, String bottom) {
            super(layout);
            this._top = top;
            this._bottom = bottom;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (Themes.isThemed()) {
                String state = DrawerWindowTray.this.mouseOver ? "mouseover" : "normal";
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties(this._top, state);
                Painter painter = properties.getPainter("bg");
                Insets insets = this.getInsets();
                int w = this.getWidth() - insets.left - insets.right;
                int h = this.getHeight() - insets.top - insets.bottom;
                painter.paint(g, insets.left, insets.top, w, h / 2);
                properties = Themes.getActiveTheme().getStateProperties(this._bottom, state);
                painter = properties.getPainter("bg");
                painter.paint(g, insets.left, insets.top + h / 2, w, h / 2);
            } else {
                Insets insets = this.getInsets();
                if (this._top.equals("minimized2")) {
                    g.setColor(UIManager.getColor("TextPane.selectionBackground"));
                } else {
                    g.setColor(UIManager.getColor("TextPane.selectionBackground"));
                }
                g.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            }
        }
    }

    private static class CellRenderer
    extends JPanel
    implements ListCellRenderer {
        private final JLabel text = new JLabel();
        private boolean selected;
        private boolean mouseDown;

        CellRenderer() {
            super(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.weightx = 1.0;
            c.gridy = 0;
            c.gridx = 0;
            c.insets = new Insets(2, 5, 2, 5);
            this.text.setHorizontalAlignment(2);
            this.add((Component)this.text, c);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.text.setText(value.toString());
            }
            this.selected = isSelected;
            this.mouseDown = cellHasFocus;
            this.text.setFont(list.getFont());
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            String state = null;
            if (this.selected) {
                if (Themes.isThemed()) {
                    state = this.mouseDown ? "mousedown" : "mouseover";
                    ThemeProperties properties = Themes.getActiveTheme().getStateProperties("minimized", state);
                    Painter painter = properties.getPainter("bg");
                    this.text.setForeground(properties.getColor("foreground"));
                    properties = Themes.getActiveTheme().getStateProperties("minimized", "element");
                    Insets insets = properties.getInsets("inset");
                    painter.paint(g, insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                } else {
                    state = this.mouseDown ? "mousedown" : "mouseover";
                    Insets insets = this.getInsets();
                    if (state.equals("mouseover")) {
                        g.setColor(Color.ORANGE);
                        g.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                    } else {
                        g.setColor(UIManager.getColor("TextPane.selectionBackground").brighter());
                        g.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                    }
                }
            }
        }
    }

    private class AnimationListener
    implements PropertyChangeListener {
        private final JComponent layeredPane;
        private final Rectangle from;
        private final Rectangle to;

        public AnimationListener(JComponent component, Rectangle from, Rectangle to) {
            this.layeredPane = component;
            this.from = from;
            this.to = to;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            double v = (Double)evt.getNewValue();
            DrawerWindowTray.this.setBounds(Animator.getRectangle(v, this.from, this.to));
            this.layeredPane.revalidate();
            this.layeredPane.repaint();
        }
    }

    private class Handle
    extends JPanel {
        private final int orientation;

        public Handle(int orientation) {
            this.orientation = orientation;
            this.setPreferredSize(new Dimension(10, DrawerWindowTray.getDrawerTrayHeight()));
            if (Themes.isThemed()) {
                this.setPreferredSize(new Dimension(10, DrawerWindowTray.getDrawerTrayHeight()));
            } else {
                this.setPreferredSize(new Dimension(10, 10));
                this.setBorder(BorderFactory.createBevelBorder(0));
            }
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DrawerWindowTray.this.collapse();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    DrawerWindowTray.this.mouseOver = true;
                    Handle.this.getParent().repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    DrawerWindowTray.this.mouseOver = false;
                    Handle.this.getParent().repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (Themes.isThemed()) {
                this.paintWithTheme(g);
            } else {
                this.paintWithoutTheme(g);
            }
        }

        @Override
        protected void paintBorder(Graphics g) {
            if (Themes.isThemed()) {
                super.paintBorder(g);
            }
        }

        private void paintWithTheme(Graphics g) {
            ThemeProperties properties = Themes.getActiveTheme().getStateProperties("handler", "opened");
            int width = this.getWidth();
            int height = this.getHeight();
            Icon icon = properties.getIcon("icon");
            int inset = Themes.getActiveTheme().getStateProperties("handler", "icon").getInt("inset");
            icon.paintIcon(this, g, width - icon.getIconWidth() - inset, (height - icon.getIconHeight()) / 2);
        }

        private void paintWithoutTheme(Graphics g) {
            g.setColor(new Color(0, 0, 0, 0));
            Insets insets = this.getInsets();
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom;
            g.fillRect(insets.left, insets.top, width, height);
            OracleIcons.getIcon((String)"arrows-opened.png").paintIcon(this, g, 0, 2);
        }
    }

    private class Listeners
    implements PropertyChangeListener,
    ComponentListener,
    MouseListener,
    KeyListener {
        private Listeners() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (!DrawerWindowTray.PERMANENT_FOCUS_OWNER_PROPERTY.equals(e.getPropertyName())) {
                return;
            }
            Component permanentFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (permanentFocusOwner == null) {
                return;
            }
            if (SwingUtilities.isDescendingFrom(permanentFocusOwner, DrawerWindowTray.this)) {
                return;
            }
            DrawerWindowTray.this.collapse();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            DrawerWindowTray.this.drawerWindowUI.doLayout();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DrawerWindowTray.this.onRestore();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                int index = DrawerWindowTray.this.drawerList.locationToIndex(e.getPoint());
                if (index < 0) {
                    return;
                }
                Rectangle r = DrawerWindowTray.this.drawerList.getCellBounds(index, index);
                if (r.contains(e.getPoint())) {
                    DrawerWindowTray.this.drawerList.setSelectedIndex(index);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if ('\n' == e.getKeyChar()) {
                DrawerWindowTray.this.onRestore();
            }
            if ('\u001b' == e.getKeyChar()) {
                DrawerWindowTray.this.collapse();
            }
        }
    }
}

