/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import oracle.ide.docking.DrawerUI;

public final class DrawerLabel
extends JLabel
implements FocusListener {
    private boolean paintBorder;
    private boolean mouseOver;
    private static final Color BORDER_COLOR = new Color(177, 206, 235);

    DrawerLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.setFocusable(true);
    }

    public boolean isExpanded() {
        DrawerUI parent = (DrawerUI)this.getParent();
        return parent != null && parent.expanded();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.paintBorder = true;
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.paintBorder = false;
        this.repaint();
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        super.removeFocusListener(l);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.paintBorder && !this.mouseOver) {
            g.setColor(BORDER_COLOR);
            g.drawRoundRect(this.getX() + 1, this.getY() + 2, this.getWidth() - 2, this.getHeight() - 5, 2, 2);
        }
    }

    void setMouseOver(boolean mouseOver) {
        this.mouseOver = mouseOver;
    }
}

