/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.Site;
import oracle.ide.docking.TitleChangeEvent;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.Layout;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.ViewId;
import oracle.ide.util.BitField;
import oracle.ide.view.View;

public abstract class DockableWindow
extends DockableView {
    private ArrayList titleChangeListener = new ArrayList(2);
    private Site site = new Site();
    private int type = 0;

    static void installDockableListener() {
        DockStation dockStation = DockStation.getDockStation();
        if (dockStation != null) {
            dockStation.addDockableListener(new ShowHideTranslator(), null);
        }
    }

    protected DockableWindow() {
    }

    protected DockableWindow(View decorated) {
        super(decorated);
    }

    protected DockableWindow(String viewId) {
        this(Ide.getMainWindow().getIdeMainWindowView(), viewId);
    }

    protected DockableWindow(View owner, String viewId) {
        this.setOwner(owner);
        this.setId(viewId);
        Layouts.getLayouts().addView(new ViewId(viewId), this);
    }

    protected DockableWindow(IdeMainWindow owner, String viewId) {
        this(viewId);
    }

    protected Dockable getCachedDockable() {
        ViewId id = new ViewId(this.getId());
        return DockStation.getDockStation().getDockable(id);
    }

    @Override
    public void close() {
        Dockable cachedDockable = this.getCachedDockable();
        if (cachedDockable != null) {
            DockStation.getDockStation().close(cachedDockable);
        }
    }

    @Override
    public void show() {
        this.setDockableVisible(true);
    }

    @Override
    public boolean isVisible() {
        boolean ret = false;
        DockStation dockStation = DockStation.getDockStation();
        Dockable dockable = this.getCachedDockable();
        if (dockable != null) {
            int status = dockStation.getDockableStatus(dockable);
            ret = BitField.isSet(status, 32);
        }
        return ret;
    }

    @Override
    public void setDockableVisible(boolean bVisible) {
        DockStation.getDockStation().setDockableVisible(this.getId(), bVisible);
    }

    @Override
    public void updateTitle(Object object) {
        this.fireTitleChangeListener();
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public String getUniqueName() {
        return this.getId();
    }

    @Override
    public Site getSite() {
        return this.site;
    }

    @Override
    public void setSite(Site site) {
        this.site = site;
    }

    @Override
    public JComponent getHostedComponent() {
        JComponent result = null;
        try {
            result = (JComponent)this.getGUI();
        }
        catch (Throwable t) {
            FeedbackManager.reportException("Failed to load a window", t);
        }
        return result;
    }

    @Override
    public DropTargetListener getTabDropListener() {
        return null;
    }

    @Override
    public String getMenuTitle() {
        return this.getTabName();
    }

    public List<JComponent> getHeaderComponents() {
        if (this.isDecorated() && this.getDecorated() instanceof DockableWindow) {
            return ((DockableWindow)this.getDecorated()).getHeaderComponents();
        }
        return Collections.emptyList();
    }

    @Override
    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    @Override
    public void addTitleChangeListener(TitleChangeListener l) {
        this.titleChangeListener.add(l);
    }

    @Override
    public void removeTitleChangeListener(TitleChangeListener l) {
        if (this.titleChangeListener.contains(l)) {
            this.titleChangeListener.remove(l);
        }
    }

    public void stateChange(int newState) {
        switch (newState) {
            case 1: {
                Ide.getMainWindow().registerView(this);
                break;
            }
            case 2: {
                Ide.getMainWindow().unregisterView(this);
                break;
            }
            case 3: {
                Ide.getMainWindow().unregisterView(this);
                super.close();
            }
        }
    }

    protected void fireTitleChangeListener() {
        TitleChangeEvent event = new TitleChangeEvent(this);
        for (int i = 0; i < this.titleChangeListener.size(); ++i) {
            TitleChangeListener listener = (TitleChangeListener)this.titleChangeListener.get(i);
            listener.titleChange(event);
        }
    }

    private void _stateChange(int newState) {
        this.stateChange(newState);
    }

    protected void dockableHidden(DockableEvent e) {
        this._stateChange(2);
        if (BitField.isSet(e.getContext(), 16)) {
            this._stateChange(3);
        }
    }

    protected void dockableShown(DockableEvent e) {
        this._stateChange(1);
    }

    public boolean isDrawer() {
        return false;
    }

    static class ShowHideTranslator
    implements DockableListener {
        ShowHideTranslator() {
        }

        @Override
        public void dockableHidden(DockableEvent e) {
            Dockable src = e.getSource();
            if (src instanceof DockableWindow) {
                DockableWindow dw = (DockableWindow)src;
                dw.dockableHidden(e);
            }
        }

        @Override
        public void dockableShown(DockableEvent e) {
            Dockable src = e.getSource();
            if (src instanceof DockableWindow) {
                DockableWindow dw = (DockableWindow)src;
                dw.dockableShown(e);
            }
        }
    }
}

