/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;

public class SimpleInputDialog
implements DocumentListener,
VetoableChangeListener {
    private Component _parent;
    private JLabel _nameLabel;
    private JTextComponent _nameField;
    private JLabel _statusLabel;
    private JComponent _panel;
    private JEWTDialog _dlg;
    private int _buttonMask = 7;

    public SimpleInputDialog() {
        this(null);
    }

    public SimpleInputDialog(Component parent) {
        this._parent = parent;
        this._nameLabel = new JLabel();
        this._nameLabel.setAlignmentX(0.0f);
        this._nameField = this.createInputComponent();
        this._nameField.setAlignmentX(0.0f);
        this._nameField.getDocument().addDocumentListener(this);
        this._panel = Box.createVerticalBox();
        this._panel.add(Box.createVerticalStrut(5));
        this._panel.add(this._nameLabel);
        this._panel.add(Box.createVerticalStrut(3));
        if (this._nameField instanceof JEditorPane || this._nameField instanceof JTextArea) {
            JScrollPane scrollPane = new JScrollPane(this._nameField);
            scrollPane.setAlignmentX(0.0f);
            this._panel.add(scrollPane);
        } else {
            this._panel.add(this._nameField);
        }
        if (this.enableStatus()) {
            this._panel.add(Box.createVerticalStrut(3));
            this._statusLabel = new JLabel(" ");
            this._statusLabel.setAlignmentX(0.0f);
            this._panel.add(this._statusLabel);
        }
    }

    public String getInputValue() {
        return this._nameField.getText();
    }

    public void setInputValue(String value) {
        this._nameField.setText(value);
    }

    public int getButtonMask() {
        return this._buttonMask;
    }

    public void setButtonMask(int buttonMask) {
        this._buttonMask = buttonMask;
    }

    protected boolean enableStatus() {
        return false;
    }

    protected void setStatus(String value) {
        if (this._statusLabel != null) {
            this._statusLabel.setText(value == null ? " " : value);
        }
    }

    protected JTextComponent createInputComponent() {
        return new JTextField("", 20);
    }

    public boolean show(String title, String label, String helpID) {
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog(this._parent, this._panel, null, title, 7);
        this._dlg.setDefaultButton(1);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        this._dlg.setOKButtonEnabled(this.canOk());
        this._dlg.setButtonMask(helpID != null ? this._buttonMask : this._buttonMask - (this._buttonMask & 4));
        if ((this._buttonMask & 2) == 0) {
            this._dlg.setDefaultCloseOperation(0);
        }
        ResourceUtils.resLabel((JLabel)this._nameLabel, (Component)this._nameField, (String)label);
        this._dlg.setInitialFocus((Component)this._nameField);
        HelpSystem.getHelpSystem().registerTopic(this._panel, helpID);
        return WizardLauncher.runDialog((JDialog)this._dlg);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.enableOk();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.enableOk();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.enableOk();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && !this.validate(this.getInputValue())) {
            throw new PropertyVetoException("no", evt);
        }
    }

    protected JEWTDialog getDialog() {
        return this._dlg;
    }

    protected boolean canOk() {
        return this.getInputValue().length() != 0;
    }

    protected boolean validate(String input) {
        return true;
    }

    private void enableOk() {
        if (this._dlg != null) {
            this._dlg.setOKButtonEnabled(this.canOk());
        }
    }
}

