/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tabbedpane;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.ide.controls.ControlsBundle;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.tabbedpane.CloseTabListener;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.TranslucentIcon;

public class TabTitleComponent
extends JPanel {
    private static final Icon CLOSE_BUTTON = OracleIcons.getIcon((String)"extras/close-default.png");
    private static final Icon CLOSE_BUTTON_ACTIVE = OracleIcons.getIcon((String)"extras/close-default-black.png");
    private final JTabbedPane tabbedPane;
    private JLabel titleLabel;
    private JLabel iconLabel;
    private ShowHideCloseButtonMouseListener showHideCloseButtonMouseListener;
    private final List<CloseTabListener> closeTabListeners = new ArrayList<CloseTabListener>();

    public static TabTitleComponent addNewTitleComponentToLastTab(JTabbedPane tabbedPane) {
        int tabCount = tabbedPane.getTabCount();
        if (tabCount == 0) {
            throw new AssertionError((Object)"The JTabbedPane does not have tabs");
        }
        return TabTitleComponent.addNewTitleComponent(tabbedPane, tabCount - 1);
    }

    public static TabTitleComponent addNewTitleComponent(JTabbedPane tabbedPane, int tabIndex) {
        TabTitleComponent c = new TabTitleComponent(tabbedPane);
        tabbedPane.setTabComponentAt(tabIndex, c);
        IconLabel iconLabel = new IconLabel(c);
        TitleLabel titleLabel = new TitleLabel(c);
        AbstractButton closeButton = TabTitleComponent.createCloseButton();
        c.configure(iconLabel, titleLabel, closeButton);
        return c;
    }

    private TabTitleComponent(JTabbedPane tabbedPane) {
        super(new GridBagLayout());
        if (tabbedPane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.tabbedPane = tabbedPane;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    private static AbstractButton createCloseButton() {
        SmallSquareButton b = new SmallSquareButton();
        b.setModel(new DefaultButtonModel());
        String close = ControlsBundle.get("CLOSE_ACTION");
        b.setToolTipText(close);
        return b;
    }

    private void configure(JLabel iconLabel, JLabel titleLabel, AbstractButton closeButton) {
        this.iconLabel = iconLabel;
        this.titleLabel = titleLabel;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        if (iconLabel.getIcon() != null) {
            this.add((Component)iconLabel, c);
            ++c.gridx;
        }
        this.add((Component)titleLabel, c);
        ++c.gridx;
        this.add(Box.createHorizontalGlue(), c);
        closeButton.addActionListener(new CloseTabActionListener(this));
        ++c.gridx;
        this.add((Component)closeButton, c);
        this.setShowHideCloseButtonMouseListener(closeButton);
    }

    private void setShowHideCloseButtonMouseListener(AbstractButton closeButton) {
        this.showHideCloseButtonMouseListener = new ShowHideCloseButtonMouseListener(this, closeButton);
        this.addMouseListener(this.showHideCloseButtonMouseListener);
        this.titleLabel.addMouseListener(this.showHideCloseButtonMouseListener);
        closeButton.addMouseListener(this.showHideCloseButtonMouseListener);
    }

    public synchronized void addCloseTabListener(CloseTabListener l) {
        if (this.closeTabListeners.contains(l)) {
            return;
        }
        this.closeTabListeners.add(l);
    }

    public synchronized void removeCloseTabListener(CloseTabListener l) {
        this.closeTabListeners.remove(l);
    }

    @Override
    public void setFont(Font font) {
        if (this.titleLabel != null) {
            this.titleLabel.setFont(font);
            return;
        }
        super.setFont(font);
    }

    @Override
    public Font getFont() {
        if (this.titleLabel != null) {
            return this.titleLabel.getFont();
        }
        return super.getFont();
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        if (null != this.titleLabel) {
            this.titleLabel.addMouseListener(l);
        }
        if (null != this.iconLabel) {
            this.iconLabel.addMouseListener(l);
        }
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        if (null != this.titleLabel) {
            this.titleLabel.removeMouseListener(l);
        }
        if (null != this.iconLabel) {
            this.iconLabel.removeMouseListener(l);
        }
    }

    public void closeTab() {
        int i = this.tabbedPane.indexOfTabComponent(this);
        if (i == -1) {
            return;
        }
        boolean close = true;
        for (CloseTabListener l : this.closeTabListeners) {
            boolean b = l.beforeClosingTab(this.tabbedPane, i);
            if (b) continue;
            close = false;
        }
        if (close) {
            this.tabbedPane.remove(i);
        }
    }

    private static class CloseTabActionListener
    implements ActionListener {
        private final TabTitleComponent owner;

        CloseTabActionListener(TabTitleComponent owner) {
            this.owner = owner;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.owner.closeTab();
        }
    }

    private static class IconLabel
    extends JLabel {
        private final TabTitleComponent owner;

        IconLabel(TabTitleComponent owner) {
            this.owner = owner;
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }

        @Override
        public Icon getIcon() {
            return this.iconFromTabbedPane();
        }

        private Icon iconFromTabbedPane() {
            if (this.owner == null) {
                return null;
            }
            JTabbedPane tabbedPane = this.owner.tabbedPane;
            int i = tabbedPane.indexOfTabComponent(this.owner);
            if (i != -1) {
                return tabbedPane.getIconAt(i);
            }
            return null;
        }
    }

    private static class TitleLabel
    extends JLabel {
        private final TabTitleComponent owner;

        TitleLabel(TabTitleComponent owner) {
            this.owner = owner;
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }

        @Override
        public String getText() {
            return this.titleFromTabbedPane();
        }

        private String titleFromTabbedPane() {
            if (this.owner == null) {
                return null;
            }
            JTabbedPane tabbedPane = this.owner.tabbedPane;
            int i = tabbedPane.indexOfTabComponent(this.owner);
            if (i != -1) {
                return tabbedPane.getTitleAt(i);
            }
            return null;
        }
    }

    private static class ShowHideCloseButtonMouseListener
    extends MouseAdapter {
        private final TabTitleComponent owner;
        private final AbstractButton closeButton;
        private Icon closeIcon;
        private TranslucentIcon shadedCloseIcon;

        ShowHideCloseButtonMouseListener(TabTitleComponent owner, AbstractButton closeButton) {
            this.owner = owner;
            this.closeButton = closeButton;
            closeButton.setIcon(CLOSE_BUTTON);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getSource() == this.closeButton) {
                this.closeButton.setIcon(CLOSE_BUTTON_ACTIVE);
            }
            this.showCloseButton();
        }

        private void showCloseButton() {
            this.closeButton.setVisible(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.closeButton.setIcon(CLOSE_BUTTON);
        }

        private void hideCloseButton() {
            this.closeButton.setVisible(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == this.owner || e.getSource() == this.owner.titleLabel) {
                JTabbedPane tabbedPane = this.owner.tabbedPane;
                int i = tabbedPane.indexOfTabComponent(this.owner);
                tabbedPane.setSelectedIndex(i);
                tabbedPane.requestFocusInWindow();
            }
        }
    }
}

