/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

public class DefaultListComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel,
Serializable {
    private final List objects;
    private Object selectedObject;

    public DefaultListComboBoxModel() {
        this.objects = new ArrayList();
    }

    public DefaultListComboBoxModel(Object[] items) {
        this.objects = new ArrayList(items.length);
        int c = items.length;
        for (int i = 0; i < c; ++i) {
            this.objects.add(items[i]);
        }
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    public DefaultListComboBoxModel(List v) {
        this.objects = new ArrayList(v);
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public int getSize() {
        return this.objects.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (index >= 0 && index < this.objects.size()) {
            return this.objects.get(index);
        }
        return null;
    }

    public int getIndexOf(Object anObject) {
        return this.objects.indexOf(anObject);
    }

    public void addElement(Object anObject) {
        this.objects.add(anObject);
        this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        if (this.objects.size() == 1 && this.selectedObject == null && anObject != null) {
            this.setSelectedItem(anObject);
        }
    }

    public void insertElementAt(Object anObject, int index) {
        this.objects.add(index, anObject);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.objects.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void removeElement(Object anObject) {
        int index = this.objects.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeAllElements() {
        if (this.objects.size() > 0) {
            int firstIndex = 0;
            int lastIndex = this.objects.size() - 1;
            this.objects.clear();
            this.selectedObject = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        }
    }
}

