/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.javaxide.Util;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.data.HashStructure;

public final class ContextMenuListenersHook
extends HashStructureHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "context-menu-listeners");
    private static final Map<String, LazyContextMenuListener> _listeners = new HashMap<String, LazyContextMenuListener>();
    protected static final Logger LOGGER = Logger.getLogger(ContextMenuListenersHook.class.getName());

    ContextMenuListenersHook() {
    }

    public ContextMenuListener getListener(String siteId) {
        LazyContextMenuListener listener = _listeners.get(siteId);
        if (listener == null) {
            listener = this.buildListenerForSite(siteId);
        }
        return listener;
    }

    public void addListenerForSite(String siteId, MetaClass listenerClass) {
        LazyContextMenuListener listener = (LazyContextMenuListener)this.getListener(siteId);
        listener.add(listenerClass);
    }

    private LazyContextMenuListener buildListenerForSite(String siteId) {
        LazyContextMenuListener listener = new LazyContextMenuListener();
        _listeners.put(siteId, listener);
        ContextMenuListenersHook hook = this;
        hook.addHashStructureHookListener(new MyListener(siteId));
        return listener;
    }

    private static void populateListener(LazyContextMenuListener listener, HashStructure hash, String siteId) {
        List sites = hash.getAsList("site");
        if (sites != null) {
            for (HashStructure hsSite : sites) {
                List listeners;
                String idref = hsSite.getString("idref");
                if (!idref.contains(siteId) || (listeners = hsSite.getAsList("listener-class")) == null) continue;
                for (HashStructure hsListener : listeners) {
                    LazyClassAdapter lca = LazyClassAdapter.getInstance(hsListener);
                    listener.add(lca.getMetaClass("#text"));
                }
            }
        }
    }

    public static class MyListener
    implements HashStructureHookListener {
        private String _siteId;
        private boolean _attachProcessed = false;

        public MyListener(String siteId) {
            this._siteId = siteId;
        }

        @Override
        public void listenerAttached(HashStructureHookEvent e) {
            if (!this._attachProcessed) {
                this.processData(e.getCombinedHashStructure());
                this._attachProcessed = true;
            }
        }

        @Override
        public void elementVisited(HashStructureHookEvent e) {
            this.processData(e.getNewElementHashStructure());
        }

        private void processData(HashStructure hash) {
            LazyContextMenuListener listener = (LazyContextMenuListener)_listeners.get(this._siteId);
            if (listener != null) {
                ContextMenuListenersHook.populateListener(listener, hash, this._siteId);
            }
        }
    }

    private static class LazyContextMenuListener
    implements ContextMenuListener {
        private CopyOnWriteArrayList<MetaClass> _metaListeners = new CopyOnWriteArrayList();
        private CopyOnWriteArrayList<ContextMenuListener> _listenerInstances = new CopyOnWriteArrayList();

        private LazyContextMenuListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(MetaClass listener) {
            CopyOnWriteArrayList<MetaClass> copyOnWriteArrayList = this._metaListeners;
            synchronized (copyOnWriteArrayList) {
                this._metaListeners.addIfAbsent(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<ContextMenuListener> getListeners() {
            if (!this._metaListeners.isEmpty()) {
                PerformanceLogger logger = PerformanceLogger.get();
                CopyOnWriteArrayList<MetaClass> metaListeners = null;
                CopyOnWriteArrayList<MetaClass> copyOnWriteArrayList = this._metaListeners;
                synchronized (copyOnWriteArrayList) {
                    metaListeners = new CopyOnWriteArrayList<MetaClass>(this._metaListeners);
                    this._metaListeners.clear();
                }
                for (MetaClass mc : metaListeners) {
                    long start = System.nanoTime();
                    try {
                        ContextMenuListener listener = Util.createInstance(mc, ContextMenuListener.class);
                        if (listener == null) continue;
                        this._listenerInstances.add(listener);
                    }
                    finally {
                        logger.log("createLazyContextMenuListener", mc.getClassName(), System.nanoTime() - start);
                    }
                }
            }
            return this._listenerInstances;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void menuWillShow(ContextMenu contextMenu) {
            PerformanceLogger logger = PerformanceLogger.get();
            for (ContextMenuListener l : this.getListeners()) {
                long time = System.nanoTime();
                try {
                    l.menuWillShow(contextMenu);
                }
                catch (RuntimeException re) {
                    LOGGER.log(Level.SEVERE, "Exception in lazy context menu listener", re);
                }
                finally {
                    logger.log("ContextMenuListener.menuWillShow", l.getClass().getName(), System.nanoTime() - time);
                }
            }
        }

        @Override
        public void menuWillHide(ContextMenu contextMenu) {
            for (ContextMenuListener l : this.getListeners()) {
                try {
                    l.menuWillHide(contextMenu);
                }
                catch (RuntimeException re) {
                    LOGGER.log(Level.SEVERE, "Exception in lazy context menu listener", re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleDefaultAction(Context context) {
            PerformanceLogger logger = PerformanceLogger.get();
            for (ContextMenuListener l : this.getListeners()) {
                long time = System.nanoTime();
                try {
                    boolean result = l.handleDefaultAction(context);
                    if (!result) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (RuntimeException re) {
                    LOGGER.log(Level.SEVERE, "Exception in lazy context menu listener", re);
                }
                finally {
                    logger.log("ContextMenuListener.handleDefaultAction", l.getClass().getName(), System.nanoTime() - time);
                }
            }
            return false;
        }
    }
}

