/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.controller.ContextMenuListener;
import oracle.javatools.util.Pair;

public abstract class ContextMenuListenerSupport {
    public static ContextMenuListenerSupport createInstance() {
        return new ContextMenuListenerSupport(){
            private final List<Pair<Class, ContextMenuListener>> listeners = new CopyOnWriteArrayList<Pair<Class, ContextMenuListener>>();

            @Override
            public void addContextMenuListener(ContextMenuListener l, Class cls) {
                if (l == null) {
                    return;
                }
                this.listeners.add((Pair<Class, ContextMenuListener>)new Pair((Object)cls, (Object)l));
            }

            @Override
            public void removeContextMenuListener(ContextMenuListener l) {
                if (l == null) {
                    return;
                }
                ArrayList<Pair<Class, ContextMenuListener>> listenersToRemove = new ArrayList<Pair<Class, ContextMenuListener>>();
                for (Pair<Class, ContextMenuListener> listener : this.listeners) {
                    if (listener.getSecond() != l) continue;
                    listenersToRemove.add(listener);
                }
                this.listeners.removeAll(listenersToRemove);
            }

            @Override
            public List<Pair<Class, ContextMenuListener>> getContextMenuListeners() {
                return this.listeners;
            }
        };
    }

    public abstract void addContextMenuListener(ContextMenuListener var1, Class var2);

    public abstract void removeContextMenuListener(ContextMenuListener var1);

    public abstract List<Pair<Class, ContextMenuListener>> getContextMenuListeners();
}

