/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.component;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.ComponentArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class URLPanel
extends JPanel {
    private JLabel _lbl = new JLabel();
    private JTextField _fld = new JTextField();
    private URL _url;
    private JEWTDialog _dlg;
    private static final String ADD_URL_HELP_ID = "f1_idedaddurl_html";

    public URLPanel() {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this._lbl, (Component)this._fld, (String)ComponentArb.getString(17));
        this._fld.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                URLPanel.this._updateOK();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                URLPanel.this._updateOK();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                URLPanel.this._updateOK();
            }
        });
        this.add((Component)this._lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 2, 2), 0, 0));
        this.add((Component)this._fld, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void _updateOK() {
        if (this._dlg != null) {
            this._dlg.setOKButtonEnabled(this._fld.getText().trim().length() > 0);
        }
    }

    private boolean commit() {
        String txt = this._fld.getText();
        try {
            this._url = new URL(txt);
        }
        catch (MalformedURLException mue) {
            MessageDialog.error((Component)this, (Object)ComponentArb.format(15, txt), (String)IdeArb.getString(235), null);
            this._fld.requestFocus();
        }
        return this._url != null;
    }

    private URL getURL() {
        return this._url;
    }

    public URL promptForURL(Component parent) {
        VetoableChangeListener l = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && !URLPanel.this.commit()) {
                    throw new PropertyVetoException("no", evt);
                }
            }
        };
        HelpSystem.getHelpSystem().registerTopic(this, ADD_URL_HELP_ID);
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog(parent, this, this._fld, ComponentArb.getString(16), 7);
        this._dlg.addVetoableChangeListener(l);
        this._dlg.setOKButtonEnabled(false);
        return this._dlg.runDialog() ? this.getURL() : null;
    }
}

