/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.AddContentCommand;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RecognizerException;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class SaveAsCommand
extends Command {
    protected static final int OK_NAME_CHANGED = 0;
    protected static final int OK_NAME_UNCHANGED = 1;
    protected static final int CANCELED = 2;
    protected Context _context;
    protected Class _nodeClass;
    protected Folder _elementOwner;
    protected URL _newURL;
    protected Node _duplicate;
    private URL _tempFileURL;
    protected boolean _noPlaceToAdd;
    protected ContentSet _sourceContentSet;

    public SaveAsCommand() {
        this(12);
    }

    protected SaveAsCommand(int cmdId) {
        super(cmdId, 2);
    }

    @Override
    public int doit() throws Exception {
        int status = this.doSaveAs(IdeArb.getString(346));
        return status == 0 ? 0 : 1;
    }

    static Folder getElementOwner(Element element, Context context) {
        return Workspaces.findOwner(element, context);
    }

    protected URL validateNewURL(Recognizer recognizer, URL newURL, URL oldURL) {
        try {
            String oldExt = URLFileSystem.getSuffix((URL)oldURL);
            String newExt = URLFileSystem.getSuffix((URL)newURL);
            if (ModelUtil.hasLength((String)oldExt) && !ModelUtil.hasLength((String)newExt)) {
                return recognizer.validate(newURL, oldURL);
            }
            recognizer.validate(newURL, oldURL);
            return newURL;
        }
        catch (RecognizerException e) {
            String msg = e.getLocalizedMessage();
            if (msg == null || msg.length() == 0) {
                msg = IdeArb.format(245, URLFileSystem.getPlatformPathName((URL)newURL));
            }
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(240), null);
            return null;
        }
    }

    protected boolean saveFileDlgOK(Context context, Node doc, String dialogTitle) {
        SaveURLChooser urlChooser = new SaveURLChooser();
        DialogUtil.initURLChooser(urlChooser, context);
        Node element = context.getNode();
        urlChooser.setSelectedURL(element.getURL());
        Object explicitSelectedURLObj = context.getProperty("selectedURL");
        if (explicitSelectedURLObj instanceof URL) {
            urlChooser.setSelectedURL((URL)explicitSelectedURLObj);
        }
        this.setDefaultFilter(urlChooser, element.getURL());
        int returnVal = urlChooser.showSaveDialog((Component)((Object)Ide.getMainWindow()), dialogTitle);
        return returnVal == 0;
    }

    private void setDefaultFilter(URLChooser chooser, URL defaultURL) {
        URLFilter[] filters = chooser.getChooseableURLFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (!filters[i].accept(defaultURL)) continue;
            chooser.setURLFilter(filters[i]);
        }
    }

    protected int doSaveAs(String dialogTitle) {
        int result = 2;
        this._context = this.getContext();
        Node doc = this._context.getNode();
        if (doc == null) {
            return result;
        }
        this.getOwningContentSet(doc);
        if (!this.saveFileDlgOK(this._context, doc, dialogTitle)) {
            return result;
        }
        if (this._newURL == null) {
            return result;
        }
        if (this._nodeClass != doc.getData().getClass()) {
            if (this._duplicate == null) {
                result = this.convertToNewNode(doc);
            } else if (this._duplicate != doc) {
                result = this.convertToDupNode(doc);
            }
        } else if (this._duplicate == null) {
            result = this.saveAsNewNode(doc);
        } else if (this._duplicate != doc) {
            result = this.saveAsDupNode(doc);
        } else {
            doc.setURL(this._newURL);
            doc.markDirty(true);
            try {
                doc.save();
            }
            catch (IOException e) {
                System.err.println("**** ERROR: IOException trying to save " + doc.getURL());
                System.err.println("****        Reason: " + e.getLocalizedMessage());
            }
            result = 1;
        }
        if (!(result != 0 || this._elementOwner == null || !(this._elementOwner instanceof Dirtyable) || this._elementOwner instanceof Workspace || this._elementOwner == this.context.getProject() && this._elementOwner instanceof Project)) {
            ((Dirtyable)this._elementOwner).markDirty(true);
        }
        this.removeTempFile();
        return result;
    }

    protected int convertToNewNode(Node doc) {
        int result = 2;
        URL oldURL = doc.getURL();
        try {
            if (this._tempFileURL == null && !this.saveTempFile(doc, this._newURL)) {
                return 2;
            }
            if (URLFileSystem.exists((URL)this._newURL) && !URLFileSystem.delete((URL)this._newURL) || !URLFileSystem.renameTo((URL)this._tempFileURL, (URL)this._newURL)) {
                String msg = IdeArb.format(249, oldURL.getPath());
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(240), null);
                return 2;
            }
            Node node = NodeFactory.findOrCreate(this._nodeClass, this._newURL);
            node.open();
            result = 0;
            if (this._noPlaceToAdd || this._context.getView() instanceof Editor) {
                this.openEditor(node);
            }
        }
        catch (Exception e) {
            String msg = IdeArb.format(248, oldURL.getPath(), e.toString());
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(240), null);
        }
        return result;
    }

    protected int convertToDupNode(Node doc) {
        return this.saveAsDupNode(doc);
    }

    protected int saveAsNewNode(Node doc) {
        URL oldURL = doc.getURL();
        try {
            boolean oldDirty = doc.isDirty();
            if (oldDirty || doc.isNew()) {
                if (this._tempFileURL == null && !this.saveTempFile(doc, this._newURL)) {
                    return 2;
                }
                if (URLFileSystem.exists((URL)this._newURL) && !URLFileSystem.delete((URL)this._newURL) || !URLFileSystem.renameTo((URL)this._tempFileURL, (URL)this._newURL)) {
                    String msg = IdeArb.format(249, oldURL.getPath());
                    MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(240), null);
                    return 2;
                }
            } else {
                if (URLFileSystem.exists((URL)this._newURL) && !URLFileSystem.delete((URL)this._newURL)) {
                    String msg = IdeArb.format(249, oldURL.getPath());
                    MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(240), null);
                    return 2;
                }
                URLFileSystem.copy((URL)oldURL, (URL)this._newURL);
            }
            Node node = NodeFactory.findOrCreate(this._newURL);
            node.open();
            if (this._noPlaceToAdd || this._context.getView() instanceof Editor) {
                this.openEditor(node);
            }
            return 0;
        }
        catch (Exception e) {
            String msg = IdeArb.format(248, oldURL.getPath(), e.toString());
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(240), null);
            return 2;
        }
    }

    protected int saveNode(Node doc) {
        URL oldURL = doc.getURL();
        doc.setURL(this._newURL);
        if (!URLFileSystem.isReadOnly((URL)this._newURL) || URLFileSystem.setReadOnly((URL)this._newURL, (boolean)false)) {
            doc.markDirty(true);
            doc.isReadOnly();
            try {
                doc.save();
            }
            catch (IOException e) {
                doc.setURL(oldURL);
                System.err.println("**** ERROR: IOException trying to save " + doc.getURL());
                System.err.println("****        Reason: " + e.getLocalizedMessage());
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int saveAsDupNode(Node doc) {
        int result = 0;
        if (doc instanceof Workspace) {
            return this.saveAsWorkspaceDupNode((Workspace)doc);
        }
        result = this.verifyCloseChildren(doc);
        if (result != 0) {
            return result;
        }
        URL oldURL = doc.getURL();
        InputStream inputStream = null;
        try {
            this._duplicate.close();
            if (doc.isNew() || doc.isDirty()) {
                inputStream = this.getInputStreamNoWarn(doc);
                URLFileSystem.copy((InputStream)inputStream, (URL)this._newURL);
            } else {
                URLFileSystem.copy((URL)oldURL, (URL)this._newURL);
            }
            this._duplicate.open();
            boolean addDup = false;
            if (this._elementOwner != null) {
                this._elementOwner.remove(doc);
                if (this._elementOwner != SaveAsCommand.getElementOwner(this._duplicate, this._context) && this._elementOwner.canAdd(this._duplicate)) {
                    this._elementOwner.add(this._duplicate);
                    addDup = true;
                }
            } else if (this._noPlaceToAdd || this._context.getView() instanceof Editor) {
                this.openEditor(this._duplicate);
            }
            RenameMessage.fireObjectRenamed(doc, oldURL, doc, addDup ? this._duplicate : null, this._context);
            if (this._elementOwner instanceof Subject) {
                Subject subject = (Subject)((Object)this._elementOwner);
                RenameMessage.fireChildRenamed(subject, oldURL, doc, addDup ? this._duplicate : null, this._context);
            }
            result = 0;
        }
        catch (Exception e) {
            try {
                String msg = IdeArb.format(248, oldURL.getPath(), e.toString());
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(240), null);
            }
            catch (Throwable throwable) {
                IdeUtil.close(inputStream);
                throw throwable;
            }
            IdeUtil.close(inputStream);
        }
        IdeUtil.close(inputStream);
        return result;
    }

    private int saveAsWorkspaceDupNode(Workspace workspaceToBeSavedAs) {
        int result = 0;
        List workspaceChildren = workspaceToBeSavedAs.getListOfChildren();
        URL oldURL = workspaceToBeSavedAs.getURL();
        try {
            this._duplicate.close();
            if (workspaceToBeSavedAs.isNew()) {
                workspaceToBeSavedAs.save();
            }
            URL activeProjectURL = workspaceToBeSavedAs.getActiveProjectURL();
            Node oldNode = new Node(oldURL);
            URLFileSystem.copy((URL)oldURL, (URL)this._newURL);
            workspaceToBeSavedAs.setURL(this._newURL);
            workspaceToBeSavedAs.setActiveProjectURL(activeProjectURL);
            workspaceToBeSavedAs.setListOfChildren(workspaceChildren);
            result = this.verifyCloseChildren(workspaceToBeSavedAs);
            if (result != 0) {
                return result;
            }
            workspaceToBeSavedAs.close();
            workspaceToBeSavedAs.save();
            workspaceToBeSavedAs.open();
            RenameMessage.fireObjectRenamed(workspaceToBeSavedAs, oldURL, workspaceToBeSavedAs, null, this._context);
            if (this._elementOwner instanceof Subject) {
                Subject subject = (Subject)((Object)this._elementOwner);
                RenameMessage.fireChildRenamed(subject, oldURL, oldNode, (Node)workspaceToBeSavedAs, this._context);
            }
            result = 0;
        }
        catch (Exception e) {
            String msg = IdeArb.format(248, oldURL.getPath(), e.toString());
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(240), null);
        }
        return result;
    }

    protected boolean isSameFile(URL newURL, URL elementURL) {
        return URLFileSystem.equals((URL)newURL, (URL)elementURL);
    }

    protected boolean approveNewURL(URL selectedURL) {
        this._newURL = selectedURL;
        if (selectedURL != null) {
            String msg;
            boolean sameName;
            if (selectedURL.getPath().indexOf("*") >= 0) {
                String msg2 = IdeArb.format(245, URLFileSystem.getPlatformPathName((URL)selectedURL));
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg2, (String)IdeArb.getString(240), null);
                return false;
            }
            if (!URLFileSystem.exists((URL)selectedURL) && !URLFileSystem.canCreate((URL)selectedURL)) {
                String msg3 = IdeArb.format(245, URLFileSystem.getPlatformPathName((URL)selectedURL));
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg3, (String)IdeArb.getString(240), null);
                return false;
            }
            Node elem = this._context.getNode();
            URL elemURL = elem.getURL();
            this._elementOwner = SaveAsCommand.getElementOwner(elem, this._context);
            Recognizer newRecognizer = Recognizer.findRecognizer(selectedURL);
            Recognizer oldRecognizer = Recognizer.findRecognizer(elemURL);
            if (this.isSuffixEqual(selectedURL, elemURL)) {
                newRecognizer = oldRecognizer;
                this._nodeClass = elem.getData().getClass();
            }
            if (newRecognizer == null) {
                if (oldRecognizer != null) {
                    this._newURL = this.validateNewURL(oldRecognizer, selectedURL, elemURL);
                    if (this._newURL == null) {
                        return false;
                    }
                    this._nodeClass = oldRecognizer.recognize(this._newURL);
                } else {
                    this._newURL = selectedURL;
                    this._nodeClass = Recognizer.recognizeURL(this._newURL);
                }
                if (this._nodeClass == null) {
                    if (this.saveTempFile(elem, this._newURL)) {
                        this._nodeClass = Recognizer.recognizeURL(this._tempFileURL);
                        if (this._nodeClass == null) {
                            this._nodeClass = Recognizer.getDefaultNodeType();
                        }
                    } else {
                        this._nodeClass = Recognizer.getDefaultNodeType();
                    }
                }
            } else {
                this._newURL = this.validateNewURL(newRecognizer, selectedURL, elemURL);
                if (this._newURL == null) {
                    this.removeTempFile();
                    return false;
                }
                if (this._nodeClass == null) {
                    this._nodeClass = newRecognizer.recognize(this._newURL);
                }
            }
            if ((sameName = this.isSameFile(this._newURL, elemURL)) && URLFileSystem.exists((URL)elemURL)) {
                String msg4 = IdeArb.getString(252);
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg4, (String)IdeArb.getString(240), null);
                this.removeTempFile();
                return false;
            }
            this._duplicate = NodeFactory.find(this._newURL);
            String newURLStr = URLFileSystem.getPlatformPathName((URL)this._newURL);
            if (this._duplicate != null && this._duplicate != elem) {
                msg = null;
                if (this._elementOwner != null && this._elementOwner.containsChild(this._duplicate)) {
                    msg = IdeArb.format(251, newURLStr);
                } else if (this._duplicate.isOpen()) {
                    msg = IdeArb.format(250, newURLStr);
                }
                if (msg != null) {
                    MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(240), null);
                    this.removeTempFile();
                    return false;
                }
            }
            if (URLFileSystem.exists((URL)this._newURL) && !URLFileSystem.equals((URL)this._newURL, (URL)elemURL)) {
                msg = IdeArb.format(242, newURLStr);
                int result = MessageDialog.confirmOrCancel((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(244));
                if (result != 1) {
                    this.removeTempFile();
                    return false;
                }
                if (URLFileSystem.isReadOnly((URL)this._newURL)) {
                    msg = IdeArb.format(247, newURLStr);
                    MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(240), null);
                    this.removeTempFile();
                    return false;
                }
            }
            if (this._nodeClass != elem.getData().getClass() && newRecognizer != null && !newRecognizer.canConvert(elemURL, this._newURL)) {
                msg = IdeArb.format(241, elemURL.getFile(), this._newURL.getFile());
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(240), null);
                this.removeTempFile();
                return false;
            }
            if (this.validateLocation()) {
                return true;
            }
            this.removeTempFile();
            return false;
        }
        this.removeTempFile();
        return false;
    }

    private int verifyCloseChildren(Node doc) {
        if (!doc.mayHaveChildren()) {
            return 0;
        }
        CloseNodeCommand cmd = new CloseNodeCommand();
        cmd.setContext(this._context);
        return cmd.close(doc, false, true);
    }

    private boolean validateLocation() {
        if (this._sourceContentSet == null) {
            return true;
        }
        if (this._sourceContentSet.canHaveMember(this._newURL)) {
            return true;
        }
        int choice = this.doesUserWantToSeeFile();
        if (choice == 1) {
            return this.selectContentSet();
        }
        return choice == 0;
    }

    private int doesUserWantToSeeFile() {
        return MessageDialog.confirmOrCancel((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.getString(453), (String)IdeArb.getString(244));
    }

    private boolean selectContentSet() {
        Context context = new Context(this.getContext().getWorkspace(), this.getContext().getProject());
        int status = 0;
        try {
            Node node = NodeFactory.findOrCreate(this._newURL);
            context.setNode(node);
            AddContentCommand cmd = new AddContentCommand();
            cmd.setContext(context);
            status = cmd.doit();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            t.printStackTrace();
        }
        return status != true;
    }

    private void openEditor(Node node) {
        Context newContext = new Context(this.getContext());
        newContext.setNode(node);
        Element[] selection = new Element[]{node};
        newContext.setSelection(selection);
        EditorUtil.openDefaultEditorInFrame(node, newContext);
    }

    private void removeTempFile() {
        if (this._tempFileURL != null) {
            URLFileSystem.delete((URL)this._tempFileURL);
            this._tempFileURL = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveTempFile(Node doc, URL newURL) {
        URL oldURL = doc.getURL();
        boolean oldDirty = doc.isDirty();
        String suffix = URLFileSystem.getSuffix((URL)newURL);
        URL tmpURL = null;
        try {
            if (!URLFileSystem.exists((URL)URLFileSystem.getParent((URL)newURL))) {
                URLFileSystem.mkdirs((URL)URLFileSystem.getParent((URL)newURL));
            }
            if ((tmpURL = URLFileSystem.createTempFile((String)"jdev", (String)suffix, (URL)URLFileSystem.getParent((URL)newURL))) == null) {
                return false;
            }
        }
        catch (IOException ioe) {
            return false;
        }
        if (!doc.isOpen()) {
            try {
                doc.open();
            }
            catch (IOException e) {
                System.err.println("**** ERROR: Unable to open " + doc.getURL());
                System.err.println("****        Reason: " + e.getLocalizedMessage());
                URLFileSystem.delete((URL)tmpURL);
                return false;
            }
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStreamNoWarn(doc);
            URLFileSystem.copy((InputStream)inputStream, (URL)tmpURL);
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            IdeUtil.close(inputStream);
        }
        this._tempFileURL = tmpURL;
        return true;
    }

    private InputStream getInputStreamNoWarn(Node node) throws IOException {
        if (node instanceof TextNode) {
            return ((TextNode)node).getInputStream(false);
        }
        return node.getInputStream();
    }

    private boolean isSuffixEqual(URL url1, URL url2) {
        if (url1 == null || url2 == null) {
            return false;
        }
        String newURLSuffix = URLFileSystem.getSuffix((URL)url1);
        String oldURLSuffix = URLFileSystem.getSuffix((URL)url2);
        if (newURLSuffix.length() == 0 && oldURLSuffix.length() == 0) {
            return false;
        }
        return newURLSuffix.equals(oldURLSuffix);
    }

    protected void getOwningContentSet(Node node) {
        ContentSetProviderReference[] refs;
        for (ContentSetProviderReference ref : refs = ProjectContent.getContentSetProviderReferences()) {
            String key = ref.key();
            ContentSet cs = ContentSet.getInstance(this.context.getProject(), key);
            if (!cs.canHaveMember(node.getURL())) continue;
            this._sourceContentSet = cs;
            break;
        }
    }

    private class SaveURLChooser
    extends URLChooser {
        private static final String HELP_TOPIC = "f1_idedsaveasrename_html";

        SaveURLChooser() {
            this.setHelpID(HELP_TOPIC);
        }

        @Override
        protected URL canonicalizeApprovalURL(URL url) {
            if (URLFileSystem.isDirectory((URL)url)) {
                return URLFileSystem.canonicalize((URL)url);
            }
            String fileName = URLFileSystem.getFileName((URL)url);
            URL dirURL = URLFileSystem.canonicalize((URL)URLFileSystem.getParent((URL)url));
            return URLFactory.newURL((URL)dirURL, (String)fileName);
        }

        @Override
        protected URL getApprovalFileListURL() {
            return null;
        }

        @Override
        protected boolean checkApprovalParentExists(URL url) {
            if (SaveAsCommand.this.getId() == 14) {
                return true;
            }
            return super.checkApprovalParentExists(url);
        }

        @Override
        public boolean approveSelection() {
            if (!super.approveSelection()) {
                return false;
            }
            URL selectedURL = this.getSelectedURL();
            return SaveAsCommand.this.approveNewURL(selectedURL);
        }
    }
}

