/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;

public final class LogWindowContentReader {
    private static final String LOG_WINDOW_OUTPUT_FILE_FOR_TESTING = "log-window.txt";

    public static void printLogWindowContentToFileForTestingOnly() {
        boolean redirectOutput = LogWindowContentReader.booleanProperty("ide.start.redirectoutput", false);
        if (!redirectOutput) {
            return;
        }
        String path = LogWindowContentReader.createFileInTempFolder(LogWindowContentReader.logOutputPath());
        BufferedWriter out = null;
        try {
            LogPage[] pages;
            out = new BufferedWriter(new FileWriter(path));
            LogManager logManager = LogManager.getLogManager();
            for (LogPage page : pages = logManager.getPages()) {
                if (!(page instanceof DefaultLogPage)) continue;
                DefaultLogPage p = (DefaultLogPage)page;
                StringBuilder buffer = new StringBuilder();
                p.asTextForTestingOnly(buffer);
                out.append(buffer.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static boolean booleanProperty(String name, boolean defaultValue) {
        String property = System.getProperty(name);
        if (property == null) {
            return defaultValue;
        }
        return Boolean.valueOf(property);
    }

    public static String logOutputPath() {
        return LogWindowContentReader.tempFolderPath() + LOG_WINDOW_OUTPUT_FILE_FOR_TESTING;
    }

    private static String createFileInTempFolder(String filePath) {
        File f = new File(filePath);
        if (f.exists()) {
            f.delete();
        }
        return filePath;
    }

    private static String tempFolderPath() {
        String path = System.getProperty("java.io.tmpdir");
        if (path.endsWith(File.separator) || path.endsWith("/")) {
            return path;
        }
        return path + File.separator;
    }

    private LogWindowContentReader() {
    }
}

