/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.bookmarks;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class BookmarkOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "BookmarkOptions";
    private static final String DISCARD_ON_CLOSE = "discardOnClose";
    private static final String DISCARD_ON_EXIT = "discardOnExit";
    public static final int TRAVERSE_CURRENT = 1;
    public static final int TRAVERSE_OPEN = 2;
    public static final int TRAVERSE_ALL = 3;
    private static final String TRAVERSE_BEHAVIOR = "traverseBehavior";
    public static final int MISSING_MOVE = 1;
    public static final int MISSING_DISCARD = 2;
    private static final String MISSING_LINE_BEHAVIOR = "missingLineBehavior";

    public BookmarkOptions() {
        this(HashStructure.newInstance());
    }

    private BookmarkOptions(HashStructure hash) {
        super(hash);
    }

    public static BookmarkOptions getInstance(PropertyStorage prefs) {
        return new BookmarkOptions(BookmarkOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public boolean getDiscardOnClose() {
        return this._hash.getBoolean(DISCARD_ON_CLOSE, false);
    }

    public void setDiscardOnClose(boolean discardOnClose) {
        this._hash.putBoolean(DISCARD_ON_CLOSE, discardOnClose);
    }

    public boolean getDiscardOnExit() {
        return this._hash.getBoolean(DISCARD_ON_EXIT, false);
    }

    public void setDiscardOnExit(boolean discardOnExit) {
        this._hash.putBoolean(DISCARD_ON_EXIT, discardOnExit);
    }

    public int getTraverseBehavior() {
        return BookmarkOptions.sanitizeTraverseBehavior(this._hash.getInt(TRAVERSE_BEHAVIOR, 3));
    }

    public void setTraverseBehavior(int traverseBehavior) {
        this._hash.putInt(TRAVERSE_BEHAVIOR, BookmarkOptions.sanitizeTraverseBehavior(traverseBehavior));
    }

    private static int sanitizeTraverseBehavior(int traverseBehavior) {
        if (traverseBehavior != 1 && traverseBehavior != 2 && traverseBehavior != 3) {
            return 1;
        }
        return traverseBehavior;
    }

    public int getMissingLineBehavior() {
        return BookmarkOptions.sanitizeMissingLineBehavior(this._hash.getInt(MISSING_LINE_BEHAVIOR, 2));
    }

    public void setMissingLineBehavior(int missingLineBehavior) {
        this._hash.putInt(MISSING_LINE_BEHAVIOR, BookmarkOptions.sanitizeMissingLineBehavior(missingLineBehavior));
    }

    private static int sanitizeMissingLineBehavior(int missingLineBehavior) {
        if (missingLineBehavior != 1 && missingLineBehavior != 2) {
            return 1;
        }
        return missingLineBehavior;
    }
}

