/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.panels.TraversableContext;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCategory;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.RichHintLabel;

public final class SummaryPage
extends UpdateWizardPage {
    private static final Icon CATEGORY_ICON = OracleIcons.getIcon((String)"folder.png");
    private static final Icon NEWINSTALLBUNDLE_ICON = OracleIcons.getIcon((String)"newinstallbundle.png");
    private static final Icon UPDATEINSTALLBUNDLE_ICON = OracleIcons.getIcon((String)"updateinstallbundle.png");
    private GridBagLayout _gridBagLayout;
    private JScrollPane _summaryScroller;
    private JTree _summaryTree;
    private final RichHintLabel _hint = new RichHintLabel();

    public SummaryPage() {
        this._gridBagLayout = new GridBagLayout();
        this._summaryScroller = new JScrollPane();
        this._summaryTree = new CustomJTree();
        this.jbInit();
    }

    private void jbInit() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultTreeModel model = new DefaultTreeModel(root);
        this._summaryTree.setModel(model);
        this._summaryTree.setRootVisible(false);
        this._summaryTree.setShowsRootHandles(true);
        this._summaryTree.setName("SummaryPage.SummaryCustomJTree");
        this.setLayout(this._gridBagLayout);
        this._summaryScroller.setPreferredSize(new Dimension(0, 0));
        this._hint.setText(UpdateArb.getString(217));
        this._summaryScroller.getViewport().add((Component)this._summaryTree, null);
        this.add((Component)this._hint, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, INSETS_HINT, 0, 0));
        this.add(this._summaryScroller, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected boolean canGoBack() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    @Override
    public boolean canFinish() {
        return true;
    }

    @Override
    public Component getInitialFocus() {
        return this._summaryTree;
    }

    private void addNode(DefaultMutableTreeNode parent, UpdateInfo info) {
        SortedUpdateNode child = new SortedUpdateNode(info);
        UpdateCategory category = info.getCategory();
        Object categoryNode = this.searchNode(parent, category);
        if (categoryNode == null) {
            categoryNode = this.createCategoryNode(category);
            parent.add((MutableTreeNode)categoryNode);
        }
        categoryNode.add((MutableTreeNode)((Object)child));
    }

    private SortedUpdateNode createCategoryNode(UpdateCategory category) {
        return new SortedUpdateNode(category);
    }

    private DefaultMutableTreeNode searchNode(DefaultMutableTreeNode n, UpdateCategory category) {
        Enumeration<TreeNode> e = n.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!category.equals(node.getUserObject())) continue;
            return node;
        }
        return null;
    }

    @Override
    protected void pageSelected(TraversableContext context) {
        this.completeValueChanged();
        if (context.getDirection() == 1) {
            Map downloadedUpdates;
            boolean haveUpdates = false;
            JMutableTreeNode root = new JMutableTreeNode("root");
            DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
            Set<UpdateBundle> bundles = null;
            bundles = this.getModel(context).getLocalBundle() != null ? Collections.singleton(this.getModel(context).getLocalBundle().getBundle()) : ((downloadedUpdates = this.getModel(context).getDownloadedUpdates()) == null ? null : downloadedUpdates.keySet());
            SortedUpdateNode newExtensions = SummaryPage.createNewNode();
            root.add((MutableTreeNode)((Object)newExtensions));
            SortedUpdateNode upgExtensions = SummaryPage.createUpgradeNode();
            root.add((MutableTreeNode)((Object)upgExtensions));
            if (bundles != null) {
                for (UpdateBundle bundle : bundles) {
                    for (UpdateInfo update : bundle.getUpdates()) {
                        if (update.isNew()) {
                            this.addNode((DefaultMutableTreeNode)((Object)newExtensions), update);
                        } else {
                            this.addNode((DefaultMutableTreeNode)((Object)upgExtensions), update);
                        }
                        haveUpdates = true;
                    }
                }
                newExtensions.sortChildren();
                newExtensions.updateNodes();
                upgExtensions.sortChildren();
                upgExtensions.updateNodes();
                model.reload((TreeNode)root);
            }
            if (newExtensions.isLeaf()) {
                newExtensions.add((MutableTreeNode)((Object)SummaryPage.createNoneNode()));
            }
            if (upgExtensions.isLeaf()) {
                upgExtensions.add((MutableTreeNode)((Object)SummaryPage.createNoneNode()));
            }
            this._summaryTree.setModel(model);
            for (int row = 0; row < this._summaryTree.getRowCount(); ++row) {
                this._summaryTree.expandRow(row);
            }
        }
    }

    public static SortedUpdateNode createNoneNode() {
        return new SortedUpdateNode(new JTreeCellData(UpdateArb.getString(101)), false);
    }

    public static SortedUpdateNode createNewNode() {
        return new SortedUpdateNode(new JTreeCellData(NEWINSTALLBUNDLE_ICON, UpdateArb.getString(98), false), true);
    }

    public static SortedUpdateNode createUpgradeNode() {
        return new SortedUpdateNode(new JTreeCellData(UPDATEINSTALLBUNDLE_ICON, UpdateArb.getString(100), false), true);
    }

    private static class SortedUpdateNode
    extends JMutableTreeNode {
        public SortedUpdateNode(UpdateInfo update) {
            this(new JTreeCellData(update.isNew() ? NEWINSTALLBUNDLE_ICON : UPDATEINSTALLBUNDLE_ICON, update.getName(), false), false);
            this.setUserObject(update);
        }

        public SortedUpdateNode(UpdateCategory category) {
            this(new JTreeCellData(CATEGORY_ICON, category.getCategoryName(), false), true);
            this.setUserObject(category);
        }

        SortedUpdateNode(JTreeCellData treeCellData, boolean allowsChildren) {
            super(treeCellData, allowsChildren);
        }

        public int compareTo(JMutableTreeNode otherNode) {
            if (otherNode != null) {
                if (this.getChildCount() > 0) {
                    if (otherNode.getChildCount() == 0) {
                        return -1;
                    }
                } else if (otherNode.getChildCount() > 0) {
                    return 1;
                }
            }
            return super.compareTo(otherNode);
        }
    }
}

