/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenterMessage;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.parser.BundleHandler;
import oracle.ideimpl.webupdate.parser.InputStreamLocator;
import oracle.ideimpl.webupdate.parser.RequirementsHandler;
import oracle.ideimpl.webupdate.parser.UpdateHandler;
import oracle.javatools.xml.esax.ElementContext;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.Key;
import oracle.javatools.xml.esax.spi.ExtensibleSAXParser;
import org.xml.sax.SAXException;

public class UpdateCenterParser
extends ExtensibleSAXParser {
    static final String NS = "http://xmlns.oracle.com/jdeveloper/updatecenter";
    static final Key KEY_BUNDLES_COLL = new Key("bundles-coll");
    private static final Key KEY_MESSAGES_COLL = new Key("messages-coll");
    private static final Key KEY_CURRENT_MESSAGE = new Key("current-message");
    private ElementHandler _updatesHandler = new UpdatesHandler();
    private final ElementHandler _requirementsHandler = new RequirementsHandler();
    private UpdateHandler _updateHandler = new UpdateHandler(){

        @Override
        protected void handleUpdate(ElementContext context, UpdateInfo update) {
            UpdateBundle bundle = BundleHandler.getBundle(context);
            if (bundle != null) {
                bundle.add(update);
                update.setBundle(bundle);
            } else {
                UpdateBundle anon = new UpdateBundle();
                anon.setDownloadUrl(update.getURL());
                anon.add(update);
                anon.setName(update.getName());
                anon.setInstallLocation(update.getPreferredInstallLocation());
                update.setBundle(anon);
                Collection bundles = (Collection)context.getValue(KEY_BUNDLES_COLL);
                bundles.add(anon);
            }
        }
    };
    private ElementHandler _bundleHandler = new BundleHandler(){

        @Override
        protected ElementHandler createUpdateHandler() {
            return UpdateCenterParser.this._updateHandler;
        }

        @Override
        protected void handleBundle(ElementContext context, UpdateBundle bundle) {
            Collection bundles = (Collection)context.getValue(KEY_BUNDLES_COLL);
            bundles.add(bundle);
        }
    };
    private ElementHandler _messageHandler = new ElementHandler(){

        public void handleStart(ElementStartContext context) {
            String id = context.getAttributeValue("id");
            String title = context.getAttributeValue("title");
            String link = context.getAttributeValue("link");
            String linkText = context.getAttributeValue("linkText");
            final UpdateCenterMessage message = new UpdateCenterMessage(id, title, link, linkText);
            context.putValue(KEY_CURRENT_MESSAGE, (Object)message);
            Collection messages = (Collection)UpdateCenterParser.this.getContext().getValue(KEY_MESSAGES_COLL);
            messages.add(message);
            UpdateHandler.setUpdate((ElementContext)context, message);
            context.registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "requirements", UpdateCenterParser.this._requirementsHandler);
            context.registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "description", new ElementHandler(){

                public void handleEnd(ElementEndContext context) {
                    if (context.getText() != null) {
                        message.setDescription(context.getText().trim());
                    }
                }
            });
        }

        public void handleEnd(ElementEndContext context) {
            UpdateCenterMessage message = (UpdateCenterMessage)context.getValue(KEY_CURRENT_MESSAGE);
            UpdateCenterParser.this._updateHandler.handleUpdate((ElementContext)context, message);
        }
    };

    public Collection<UpdateBundle> parse(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        InputStreamLocator locator = new InputStreamLocator(inputStream);
        this.getContext().putValue(KEY_BUNDLES_COLL, new ArrayList());
        this.getContext().putValue(KEY_MESSAGES_COLL, new ArrayList());
        this.getContext().registerChildHandler(NS, "updates", this._updatesHandler);
        this.parse(locator);
        Collection bundles = (Collection)this.getContext().getValue(KEY_BUNDLES_COLL);
        return Collections.unmodifiableCollection(bundles);
    }

    private class UpdatesHandler
    extends ElementHandler {
        private UpdatesHandler() {
        }

        public void handleStart(ElementStartContext context) {
            context.registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "update", (ElementHandler)UpdateCenterParser.this._updateHandler);
            context.registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "bundle", UpdateCenterParser.this._bundleHandler);
            context.registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "message", UpdateCenterParser.this._messageHandler);
        }
    }
}

