/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.parser;

import java.text.MessageFormat;
import javax.ide.util.Version;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateLrb;
import oracle.ideimpl.webupdate.parser.UpdateHandler;
import oracle.javatools.xml.esax.ElementContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;

final class RequirementsHandler
extends ElementHandler {
    private ElementHandler _requiresAgreementHandler = new RequiresAgreementHandler();
    private ElementHandler _requiresExtensionHandler = new RequiresExtensionHandler();

    RequirementsHandler() {
    }

    public void handleStart(ElementStartContext context) {
        context.registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "requires-extension", this._requiresExtensionHandler);
        context.registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "requires-agreement", this._requiresAgreementHandler);
    }

    private static Version versionFromAttribute(ElementStartContext context, String extensionId, String attrName) {
        String versionString = context.getAttributeValue(attrName);
        if (versionString == null) {
            return null;
        }
        String messageIfBad = MessageFormat.format(UpdateLrb.get("BAD_REQUIRES_VERSION"), attrName, extensionId, versionString);
        return UpdateHandler.parseVersion((ElementContext)context, versionString, messageIfBad);
    }

    private static class RequiresAgreementHandler
    extends ElementHandler {
        private RequiresAgreementHandler() {
        }

        public void handleStart(ElementStartContext context) {
            String url = context.getAttributeValue("url");
            if (url == null) {
                context.getMessageReporter().error(context.getLocator(), "_attribute url required for element requires-agreement", null);
                return;
            }
            UpdateInfo update = UpdateHandler.getUpdate((ElementContext)context);
            if (update.getClickThroughURL() != null) {
                context.getMessageReporter().error(context.getLocator(), "_can only have one requires-agreement element for an extension.", null);
                return;
            }
            update.setClickThroughURL(url);
        }
    }

    private static class RequiresExtensionHandler
    extends ElementHandler {
        private RequiresExtensionHandler() {
        }

        public void handleStart(ElementStartContext context) {
            String id = context.getAttributeValue("id");
            if (id == null) {
                context.getMessageReporter().error(context.getLocator(), "_attribute id required for element requires-extension.", null);
                return;
            }
            Version minVersion = RequirementsHandler.versionFromAttribute(context, id, "minVersion");
            Version maxVersion = RequirementsHandler.versionFromAttribute(context, id, "maxVersion");
            UpdateInfo update = UpdateHandler.getUpdate((ElementContext)context);
            update.addRequiredUpdate(id, minVersion, maxVersion);
        }
    }
}

