/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClass;
import oracle.ide.Addin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.Preferences;
import oracle.ide.webupdate.PostStartupHook;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.Directories;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.javatools.data.PropertyStorage;

public final class WebUpdateAddin
implements Addin,
IdeListener {
    public static final int CFU_ACTION_ID = Ide.findOrCreateCmdID((String)"CheckForUpdates");

    public void initialize() {
        UpdateManager.getInstance().setDirectories(new IdeDirectories());
        Ide.addIdeListener((IdeListener)this);
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        this.runInitHooks();
        this.checkForNewUpdates();
    }

    public void mainWindowClosing(IdeEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runInitHooks() {
        File propsFile = new File(Ide.getOracleHomeDirectory(), "installhooks.properties");
        if (propsFile.exists()) {
            InputStream is = null;
            Properties p = null;
            try {
                p = new Properties();
                is = new FileInputStream(propsFile);
                p.load(is);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            try {
                if (p != null) {
                    this.runInitHooks(p);
                }
            }
            finally {
                if (!propsFile.delete()) {
                    propsFile.deleteOnExit();
                }
            }
        }
    }

    private final void runInitHooks(Properties properties) {
        for (String string : properties.keySet()) {
            try {
                PostStartupHook hook;
                Object extensionId = properties.get(string);
                if (extensionId == null || (hook = WebUpdateAddin.loadHookClass(string, extensionId.toString())) == null) continue;
                hook.install();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static PostStartupHook loadHookClass(String hookClassName, String extensionId) {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        Extension extension = registry.findExtension(extensionId);
        if (extension != null) {
            registry.fullyLoadExtension(extension, "Needed to execute bundle.xml post-startup-hook");
            ClassLoader classLoader = registry.getClassLoader(extensionId);
            if (classLoader != null) {
                try {
                    MetaClass hookMetaClass = new MetaClass(classLoader, hookClassName);
                    return (PostStartupHook)hookMetaClass.newInstance();
                }
                catch (Exception ex) {
                    ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Cannot load " + hookClassName + " for post-startup-hook");
                }
            } else {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Cannot find class loader for extension " + extensionId);
            }
        } else {
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Cannot load extension " + extensionId);
        }
        return null;
    }

    private void checkForNewUpdates() {
        UpdateManager.getInstance().getAutomaticCheckForUpdates().check();
    }

    public static CheckForUpdatesPreferences getPreferences() {
        return CheckForUpdatesPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private static class IdeDirectories
    implements Directories {
        private String m_temp = null;

        private IdeDirectories() {
        }

        @Override
        public void save(List<String> list) {
            list.add("temp=" + this.getTemp());
            list.add("globalExtensionsHome=" + this.getGlobalExtensionsHome());
            list.add("patchesHome=" + this.getPatchesHome());
            list.add("userExtensionsHome=" + this.getUserExtensionsHome());
            list.add("globalSettingsHome=" + this.getGlobalSettingsHome());
            list.add("userSettingsHome=" + this.getUserSettingsHome());
            list.add("oracleHome=" + this.getOracleHome());
            list.add("bundlesInfoHome=" + this.getBundlesInfoHome());
        }

        @Override
        public String getTemp() {
            if (this.m_temp == null) {
                File f = new File(Ide.getUserSettingsDirectory() + File.separator + "tmp", "update");
                this.m_temp = f.getPath();
            }
            return this.m_temp;
        }

        @Override
        public String getGlobalExtensionsHome() {
            File libDir = new File(Ide.getLibDirectory());
            return new File(libDir.getParentFile(), "extensions").getAbsolutePath();
        }

        @Override
        public String getPatchesHome() {
            return Ide.getLibDirectory() + File.separator + "patches";
        }

        @Override
        public String getUserExtensionsHome() {
            return Ide.getUserSettingsDirectory() + "extensions";
        }

        @Override
        public String getGlobalSettingsHome() {
            return Ide.getLibDirectory();
        }

        @Override
        public String getUserSettingsHome() {
            return Ide.getUserSettingsDirectory() + File.separator + "lib";
        }

        @Override
        public String getOracleHome() {
            return Ide.getOracleHomeDirectory();
        }

        @Override
        public String getBundlesInfoHome() {
            return Ide.getOracleHomeDirectory() + "configuration";
        }
    }
}

