/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.feedback.FeedbackManager;
import oracle.ideimpl.webupdate.UpdateInstaller;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class UpdateTool
extends HashStructureAdapter {
    private String path;
    private List<String> args;
    private MetaClass<UpdateInstaller> updateInstallerMetaClass;
    private UpdateInstaller updateInstaller;

    private UpdateTool(HashStructure hash) {
        super(hash);
    }

    static UpdateTool getInstance(HashStructure hash) {
        return new UpdateTool(hash);
    }

    public boolean isExtensionManaged() {
        return this._hash.getBoolean("extension-managed", false);
    }

    public boolean isUninstallSupported() {
        return this._hash.getBoolean("uninstall-supported", true);
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this._hash.getString("path/#text");
        }
        return this.path;
    }

    public List<String> getInstallArgs() {
        if (this.args == null) {
            HashStructure argsData = this._hash.getHashStructure("install/args");
            if (argsData == null) {
                this.args = Collections.EMPTY_LIST;
            } else {
                List data = argsData.getAsList("arg");
                this.args = new ArrayList<String>(data.size());
                for (HashStructure h : data) {
                    this.args.add(h.getString("#text"));
                }
            }
        }
        return this.args;
    }

    public List<String> getUninstallArgs() {
        if (this.args == null) {
            HashStructure argsData = this._hash.getHashStructure("uninstall/args");
            if (argsData == null) {
                this.args = Collections.EMPTY_LIST;
            } else {
                List data = argsData.getAsList("arg");
                this.args = new ArrayList<String>(data.size());
                for (HashStructure h : data) {
                    this.args.add(h.getString("#text"));
                }
            }
        }
        return this.args;
    }

    public MetaClass<UpdateInstaller> getUpdateInstallerMetaClass() {
        if (this.updateInstallerMetaClass == null) {
            this.updateInstallerMetaClass = LazyClassAdapter.getInstance((HashStructure)this._hash.getHashStructure("installer")).getMetaClass("class");
        }
        return this.updateInstallerMetaClass;
    }

    public UpdateInstaller getUpdateInstaller() {
        MetaClass installerClass;
        if (this.updateInstaller == null && (installerClass = LazyClassAdapter.getInstance((HashStructure)this._hash.getHashStructure("installer")).getMetaClass("class")) != null) {
            try {
                this.updateInstaller = (UpdateInstaller)installerClass.newInstance();
            }
            catch (InstantiationException e) {
                Logger.getLogger("global").log(Level.SEVERE, "Cannot instantiate class for class: " + installerClass.getClassName());
            }
            catch (IllegalAccessException e) {
                Logger.getLogger("global").log(Level.SEVERE, "Cannot access class for class: " + installerClass.getClassName());
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger("global").log(Level.SEVERE, "Cannot find class for class: " + installerClass.getClassName());
            }
            catch (ClassCastException e) {
                Logger.getLogger("global").log(Level.SEVERE, "ClassCastException. updateInstaller for class: " + installerClass.getClassName() + ", is not of type updateInstaller");
            }
            catch (Throwable t) {
                FeedbackManager.reportException((Throwable)t);
            }
        }
        return this.updateInstaller;
    }
}

