/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import oracle.ideimpl.webupdate.UpdateCenter;

public final class UpdateHook
extends ExtensionHook {
    private static final String xmlns = "http://xmlns.oracle.com/ide/update-hook";
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/ide/update-hook", "update-hook");
    private static final ElementName UPDATE_CENTER = new ElementName("http://xmlns.oracle.com/ide/update-hook", "update-center");
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/update-hook", "name");
    private static final ElementName URL = new ElementName("http://xmlns.oracle.com/ide/update-hook", "url");
    private final ElementVisitor _updateCenterVisitor = new UpdateCenterVisitor();
    private final ElementVisitor _nameVisitor = new NameVisitor();
    private final ElementVisitor _urlVisitor = new UrlVisitor();
    private static final Object KEY_CENTER = "updateCenter";
    private List _updateCenters = new ArrayList();

    public Collection<UpdateCenter> getUpdateCenters() {
        return Collections.unmodifiableCollection(this._updateCenters);
    }

    void dispose() {
        this._updateCenters = null;
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(UPDATE_CENTER, this._updateCenterVisitor);
    }

    private static final class UrlVisitor
    extends ElementVisitor {
        private UrlVisitor() {
        }

        public void end(ElementEndContext context) {
            String text = context.getText();
            if (text != null && text.trim().length() > 0) {
                ((UpdateCenter)context.getScopeData().get(KEY_CENTER)).setURL(text);
            }
        }
    }

    private static final class NameVisitor
    extends I18NStringVisitor {
        private NameVisitor() {
        }

        protected void string(ElementContext context, String string) {
            ((UpdateCenter)context.getScopeData().get(KEY_CENTER)).setName(string);
        }
    }

    private final class UpdateCenterVisitor
    extends ElementVisitor {
        private UpdateCenterVisitor() {
        }

        public void start(ElementStartContext context) {
            String id = context.getAttributeValue("id");
            if (id == null || id.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'id'.");
                return;
            }
            UpdateCenter updateCenter = new UpdateCenter();
            updateCenter.setMasterId(id);
            context.getScopeData().put(KEY_CENTER, updateCenter);
            context.registerChildVisitor(NAME, UpdateHook.this._nameVisitor);
            context.registerChildVisitor(URL, UpdateHook.this._urlVisitor);
        }

        public void end(ElementEndContext context) {
            UpdateCenter center = (UpdateCenter)context.getScopeData().get(KEY_CENTER);
            if (center.getName() == null) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required element name");
                return;
            }
            if (center.getURL() == null) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required element url");
                return;
            }
            UpdateHook.this._updateCenters.add(center);
        }
    }
}

