/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.feature.FeatureCategory;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateInfo;

public class UpdateCategory {
    public static final String DEFAULT_CATEGORY = UpdateArb.getString(208);
    private String _category;
    private String _categoryId;
    private boolean _isSet;
    private boolean _idLookUpComplete;
    private UpdateInfo.Type _type;
    private String _description;
    private static Boolean _extensionRegistryExists = null;

    public UpdateCategory() {
        this._type = UpdateInfo.Type.EXTENSION;
    }

    public UpdateCategory(String category_id) {
        this();
        this._categoryId = category_id;
        this._isSet = true;
    }

    public UpdateCategory(UpdateInfo.Type type) {
        this._type = type;
        switch (type) {
            case PATCH: {
                this._category = UpdateArb.getString(209);
                this._isSet = true;
                break;
            }
            case MESSAGE: {
                this._category = UpdateArb.getString(210);
                this._isSet = true;
            }
        }
    }

    public boolean isCategorySet() {
        return this._isSet;
    }

    public boolean isPatch() {
        return this._type == UpdateInfo.Type.PATCH;
    }

    public boolean isMessage() {
        return this._type == UpdateInfo.Type.MESSAGE;
    }

    public UpdateInfo.Type getType() {
        return this._type;
    }

    public void setType(UpdateInfo.Type type) {
        this._type = type;
    }

    public String getCategoryName() {
        if (this._categoryId != null && !this._idLookUpComplete && UpdateCategory.doesExtensionRegistryExist()) {
            FeatureCategory featureCategory;
            this._idLookUpComplete = true;
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
            if (extensionRegistry != null && (featureCategory = extensionRegistry.getFeatureRegistry().getCategory(this._categoryId)) != null) {
                this._category = featureCategory.getDisplayName();
                this._description = featureCategory.getDescription();
            }
        }
        if (this._category == null || this._category.isEmpty()) {
            this._category = DEFAULT_CATEGORY;
        }
        return this._category;
    }

    public void setCategory(String category) {
        this._category = category;
        this._isSet = true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UpdateCategory)) {
            return false;
        }
        UpdateCategory other = (UpdateCategory)object;
        return this.getCategoryName().equals(other.getCategoryName());
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this._category == null ? 0 : this._category.hashCode());
        return result;
    }

    public String getDescription() {
        if (this._description != null) {
            return this._description;
        }
        if (DEFAULT_CATEGORY.equals(this._category)) {
            return UpdateArb.getString(150);
        }
        return this.getCategoryName();
    }

    public String getDisplayName() {
        return this.getCategoryName();
    }

    public String toString() {
        return this.getCategoryName();
    }

    public void setCategoryId(String _category_id) {
        this._categoryId = _category_id;
        this._isSet = true;
    }

    public String getCategoryId() {
        return this._categoryId;
    }

    private static boolean doesExtensionRegistryExist() {
        if (_extensionRegistryExists == null) {
            try {
                ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
                _extensionRegistryExists = extensionRegistry == null ? Boolean.FALSE : Boolean.TRUE;
            }
            catch (NoClassDefFoundError e) {
                _extensionRegistryExists = Boolean.FALSE;
            }
        }
        return _extensionRegistryExists;
    }
}

