/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.copy;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.RaptorDnD;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.models.ExtractConnectionAccess;
import oracle.dbtools.raptor.extract.models.ExtractConnectionAccessCatalog;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.thirdparty.copy.ConnectionNames;
import oracle.dbtools.thirdparty.copy.Copy2OracleCopyApi;
import oracle.dbtools.thirdparty.copy.CopyToOracle;
import oracle.dbtools.thirdparty.copy.CopyToOracleAccessTable;
import oracle.dbtools.thirdparty.copy.CopyToOracleDB2;
import oracle.dbtools.thirdparty.copy.CopyToOracleLog;
import oracle.dbtools.thirdparty.copy.CopyToOracleMongoDB;
import oracle.dbtools.thirdparty.copy.CopyToOracleMySQL;
import oracle.dbtools.thirdparty.copy.CopyToOraclePostgreSQL;
import oracle.dbtools.thirdparty.copy.CopyToOracleResources;
import oracle.dbtools.thirdparty.copy.CopyToOracleSPostgreSQL;
import oracle.dbtools.thirdparty.copy.CopyToOracleSQLServer;
import oracle.dbtools.thirdparty.copy.CopyToOracleSybase;
import oracle.dbtools.thirdparty.copy.CopyToOracleTeradata;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Element;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ideimpl.explorer.dnd.MultiTransferable;

public class CopyToOracleDropHelper
implements DropHelper {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private CopyToOracleLog _log;
    private String _destConnUser;

    public boolean canTransferData(Object object, DataFlavor[] dataFlavorArray, int n) {
        return true;
    }

    private String getConnectionQualName(Element element) {
        String string = null;
        try {
            if (!(element instanceof DatabaseConnection)) {
                DBObject dBObject = new DBObject(element);
                return dBObject == null ? null : dBObject.getConnectionName();
            }
            DatabaseConnection databaseConnection = (DatabaseConnection)element;
            string = databaseConnection.getQualifiedConnectionName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public boolean transferData(Object object, Transferable[] transferableArray, int n) {
        boolean bl;
        Element element;
        Element[] elementArray;
        String string;
        String string2;
        Element element2 = DBObjectNodeUtil.getTreeNodeElement((Object)object);
        String string3 = this.getConnectionQualName(element2);
        this._log = new CopyToOracleLog();
        this._log.openLog();
        DatabaseConnection databaseConnection = null;
        if (string3 != null) {
            databaseConnection = DatabaseConnection.findConnectionNode((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string3));
        }
        try {
            if (databaseConnection == null || !Connections.getInstance().isOracle((Connection)databaseConnection.getConnection())) {
                return false;
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
            return false;
        }
        String string4 = databaseConnection.getConnectionName();
        CopyToOracle copyToOracle = null;
        try {
            string2 = this.getConnectionQualName(DBObjectNodeUtil.getTreeNodeElement(RaptorDnD.getTransferableNodes((Transferable[])transferableArray).get(0)));
            string = Connections.getInstance().getDatabase(string2).getDatabaseType();
            copyToOracle = this.getCopyToOracle(string2, string);
            if (copyToOracle == null) {
                this._log.showLogFile(CopyToOracleResources.format("NO_BRIDGE", Connections.getDisplayName((String)string2), string));
                return false;
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
            return false;
        }
        try {
            this._destConnUser = Connections.getInstance().getConnection(string3).getMetaData().getUserName().replace("\"", "");
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        if (element2 instanceof SchemaFolder) {
            return false;
        }
        string2 = new DBObject(element2);
        if (!string2.getSchemaName().equals(this._destConnUser)) {
            return false;
        }
        string2 = new ObjectAction();
        string2.setReloadParent(false);
        string2.setReload(false);
        copyToOracle.setTargetConnection(new ConnectionNames(string4, databaseConnection.getQualifiedConnectionName()));
        copyToOracle.setObjectAction((ObjectAction)string2);
        string = Context.newIdeContext();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NavigatorTreeNode navigatorTreeNode = null;
        try {
            elementArray = RaptorDnD.getTransferableNodes((Transferable[])transferableArray);
            for (Object e : elementArray) {
                if (e instanceof MultiTransferable) {
                    navigatorTreeNode = (NavigatorTreeNode)((MultiTransferable)e).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
                } else if (e instanceof DefaultMutableTreeNode) {
                    navigatorTreeNode = (NavigatorTreeNode)e;
                }
                if ((element = navigatorTreeNode.getElement()) == null) continue;
                arrayList.add(element);
            }
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), (Throwable)exception);
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        elementArray = new Element[arrayList.size()];
        int n2 = 0;
        boolean bl2 = false;
        for (Object e : arrayList) {
            elementArray[n2++] = (Element)e;
            DBObject dBObject = new DBObject((Element)e);
            if (!this.validateType(dBObject, copyToOracle)) {
                return false;
            }
            if (bl) continue;
            bl = "TABLE".equals(dBObject.getObjectType()) || dBObject.getObjectFolderType().equals("TABLE");
        }
        element = copyToOracle.getListModel(elementArray);
        ExtractConnectionAccessCatalog extractConnectionAccessCatalog = new ExtractConnectionAccessCatalog(element.getList(0));
        for (ExtractConnectionAccess extractConnectionAccess : extractConnectionAccessCatalog.getExtractConnectionAccessCatalog()) {
            if (!Connections.getInstance().isOracle(extractConnectionAccess.getConnection()) && extractConnectionAccessCatalog.size() != 1) {
                this._log.showLogFile(CopyToOracleResources.getString("SINGLE_ACCESS"));
                return false;
            }
            if (this.validateDbConnections(extractConnectionAccess, element2, databaseConnection, copyToOracle)) continue;
            return false;
        }
        string.setSelection(elementArray);
        string.setBoolean("CONTAINS_DATA_OBJECT", bl);
        string.setProperty("CONNECTION_SCHEMA_CAT", (Object)extractConnectionAccessCatalog);
        string.setProperty("IS_DNS", (Object)true);
        copyToOracle.setContext((Context)string);
        copyToOracle.launch();
        this._log.closeLog();
        return true;
    }

    private CopyToOracle getCopyToOracle(String string, String string2) {
        try {
            if (string2 == null) {
                return new CopyToOracleSQLServer();
            }
            if (string2.toLowerCase().startsWith("oracle")) {
                return new Copy2OracleCopyApi();
            }
            if (string2.toLowerCase().startsWith("mysql")) {
                return new CopyToOracleMySQL();
            }
            if (string2.toLowerCase().startsWith("sybase")) {
                return new CopyToOracleSybase();
            }
            if (string2.toLowerCase().startsWith("sqlserver")) {
                return new CopyToOracleSQLServer();
            }
            if (string2.toLowerCase().startsWith("postgresql")) {
                return new CopyToOraclePostgreSQL();
            }
            if (string2.toLowerCase().startsWith("sdpostgres")) {
                return new CopyToOracleSPostgreSQL();
            }
            if (string2.toLowerCase().startsWith("access")) {
                return new CopyToOracleAccessTable();
            }
            if (string2.toLowerCase().startsWith("db2")) {
                return new CopyToOracleDB2();
            }
            if (string2.toLowerCase().startsWith("mongo")) {
                return new CopyToOracleMongoDB();
            }
            if (string2.toLowerCase().startsWith("teradata")) {
                return new CopyToOracleTeradata();
            }
            return null;
        }
        catch (Exception exception) {
            return new CopyToOracleSQLServer();
        }
    }

    public float getWeight() {
        return 10.0f;
    }

    private boolean validateDbConnections(ExtractConnectionAccess extractConnectionAccess, Element element, DatabaseConnection databaseConnection, CopyToOracle copyToOracle) {
        try {
            String string;
            String string2;
            String string3 = extractConnectionAccess.getConnection().getMetaData().getURL();
            String string4 = ((Connection)databaseConnection.getConnection()).getMetaData().getURL();
            String string5 = extractConnectionAccess.getConnectionName();
            String string6 = this.getConnectionQualName(element);
            String string7 = extractConnectionAccess.getSchemaName().replace("\"", "");
            String string8 = "select SYS_CONTEXT ('USERENV', 'SERVER_HOST')||'.'||SYS_CONTEXT ('USERENV', 'DB_DOMAIN')||':'||SYS_CONTEXT ('USERENV', 'DB_UNIQUE_NAME') from dual";
            if (string3.indexOf("@") != -1) {
                string3 = string3.substring(string3.indexOf("@") + 1, string3.length());
            }
            if (string4.indexOf("@") != -1) {
                string4 = string4.substring(string4.indexOf("@") + 1, string4.length());
            }
            if (copyToOracle.getSchemaName() != null) {
                this._destConnUser = copyToOracle.getSchemaName();
            }
            String string9 = "Source Connection :" + string3 + " : " + string7;
            String string10 = "Target Connection :" + string4 + " : " + this._destConnUser;
            String string11 = string9 + LINE_SEPARATOR + string10 + LINE_SEPARATOR;
            if (string6.equals(string5) && this._destConnUser.equals(string7)) {
                if (copyToOracle.getSchemaName() == null) {
                    this._log.showLogFile(string11 + CopyToOracleResources.getString("SAME_CONNECTION"));
                    return false;
                }
                if (copyToOracle.getSchemaName().equals(string7)) {
                    this._log.showLogFile(string11 + CopyToOracleResources.getString("SAME_CONNECTION"));
                    return false;
                }
            }
            if (string3.equals(string4)) {
                if (string7.equals(this._destConnUser)) {
                    this._log.showLogFile(string11 + CopyToOracleResources.getString("SAME_CONNECTION"));
                    return false;
                }
                if (copyToOracle.getSchemaName() != null && copyToOracle.getSchemaName().equals(string7)) {
                    this._log.showLogFile(string11 + CopyToOracleResources.getString("SAME_CONNECTION"));
                    return false;
                }
            }
            if (string7.equals(this._destConnUser) && (string2 = DBUtil.getInstance((Connection)extractConnectionAccess.getConnection()).executeReturnOneCol(string8)).equals(string = DBUtil.getInstance((Connection)((Connection)databaseConnection.getConnection())).executeReturnOneCol(string8))) {
                this._log.showLogFile(string11 + CopyToOracleResources.getString("SAME_CONNECTION"));
                return false;
            }
            if (!Connections.getInstance().isOracle(extractConnectionAccess.getConnection())) {
                return true;
            }
            string2 = DBUtil.getDbVersion((Connection)extractConnectionAccess.getConnection());
            if (string2.compareTo((Version)(string = DBUtil.getDbVersion((Connection)((Connection)databaseConnection.getConnection())))) > 0) {
                Object[] objectArray = new Object[]{Connections.getDisplayName((String)string5), string2.toCanonicalString(), Connections.getDisplayName((String)string6), string.toCanonicalString()};
                String string12 = CopyToOracleResources.format("DATABASE_COMPATIBILITY", objectArray);
                this._log.showLogFile(string11 + string12);
                return false;
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        return true;
    }

    private boolean validateType(DBObject dBObject, CopyToOracle copyToOracle) {
        if (!copyToOracle.isSupportedType(dBObject.getObjectType())) {
            this._log.showLogFile(CopyToOracleResources.format("OBJTYPE_NOT_SUPPORTED", dBObject.getElement() instanceof ObjectFolder ? DDLTypes.getFolderLabel((String)dBObject.getObjectType()) : dBObject.getObjectType()));
            return false;
        }
        return true;
    }
}

