/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.access;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.thirdparty.access.AccessConnectionPanel;
import oracle.dbtools.thirdparty.access.AccessExplorerResource;
import oracle.ide.Ide;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.javatools.dialogs.MessageDialog;

public class BasicPanel
extends JPanel
implements CDComponentView {
    private JLabel m_fileNameLabel;
    private JTextField m_fileNameTfd;
    private JButton m_browseButton;
    private String accessURL = "";
    private String alternativeAccessURL = "";
    public static final String MDB_FILENAME = "MDBFILENAME";
    public static final String MDB_SECURITY = "MDBSECURITY";
    private String m_accessFileName = "";
    private boolean security = false;

    public BasicPanel(AccessConnectionPanel accessConnectionPanel) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.m_fileNameLabel = new JLabel();
        this.m_fileNameTfd = new ValidatedFileField();
        ResourceUtils.resLabel((JLabel)this.m_fileNameLabel, (Component)this.m_fileNameTfd, (String)AccessExplorerResource.getString("ACCESS_SELECT_FILE_LABEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.m_fileNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.fill = 2;
        this.add((Component)this.m_fileNameTfd, gridBagConstraints);
        this.m_browseButton = new JButton();
        this.m_browseButton.setText(AccessExplorerResource.getString("ACCESS_BROWSE_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.m_browseButton, (String)AccessExplorerResource.getString("ACCESS_BROWSE_LABEL"));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 0;
        this.add((Component)this.m_browseButton, gridBagConstraints);
        ResourceUtils.resButton((AbstractButton)this.m_browseButton, (String)AccessExplorerResource.getString("ACCESS_BROWSE_LABEL"));
        this.m_browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BasicPanel.this.chooseMdb();
                    BasicPanel.this.createURL();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
                }
            }
        });
    }

    private void createURL() {
        this.accessURL = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb, *.accdb)};DBQ=" + this.m_fileNameTfd.getText() + ";DriverID=22;READONLY=false}";
        this.alternativeAccessURL = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + this.m_fileNameTfd.getText() + ";DriverID=22;READONLY=false}";
    }

    public void generateProperties(Properties properties) {
        if (this.m_fileNameTfd != null && this.checkMdb(this.m_fileNameTfd.getText())) {
            this.m_accessFileName = this.m_fileNameTfd.getText();
        }
        this.createURL();
        properties.setProperty("customUrl", this.accessURL);
        properties.setProperty("access.alternate.url", this.alternativeAccessURL);
        properties.setProperty(MDB_FILENAME, this.m_accessFileName);
        properties.put("password", " ");
        properties.put("DeployPassword", "true");
    }

    public void clear() {
        this.m_fileNameTfd.setText("");
    }

    private void chooseMdb() throws FileNotFoundException {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter("Microsoft Access Database", new String[]{"mdb", "accdb"}));
        uRLFileChooser.setSelectionScope(0);
        uRLFileChooser.setSelectionMode(0);
        int n = uRLFileChooser.showOpenDialog((Component)this);
        if (n == 0) {
            URL uRL = uRLFileChooser.getSelectedURL();
            File file = new File(uRL.getPath());
            String string = file.getAbsolutePath();
            if (string != null && (string.toLowerCase().endsWith("mdb") || string.toLowerCase().endsWith("accdb"))) {
                this.m_fileNameTfd.setText(string);
                this.m_accessFileName = string;
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)AccessExplorerResource.getString("ACCESS_EXTENSION_ERROR"), (String)AccessExplorerResource.getString("ACCESS_EXTENSION_TITLE"), null);
            }
        }
    }

    public void setFileName(String string) {
        this.m_fileNameTfd.setText(string);
        this.m_accessFileName = string;
    }

    public String getFileName() {
        return this.m_accessFileName;
    }

    protected boolean isSecurity() {
        return this.security;
    }

    public void setDefaultPrompts() {
        this.clear();
    }

    public boolean checkMdb(String string) {
        return new File(string.trim()).exists() && (string.toLowerCase().endsWith("mdb") || string.toLowerCase().endsWith("accdb"));
    }

    public void updatePrompts(Properties properties) {
        this.setFileName(properties.getProperty(MDB_FILENAME));
    }

    public class ValidatedFileField
    extends FileField {
        private static final long serialVersionUID = 1359L;

        public ValidatedFileField() {
            this.setValidateExistingFile(true);
        }

        protected boolean isTextValid() {
            if (!this.isValidateExistingFile()) {
                return true;
            }
            return BasicPanel.this.checkMdb(this.getText());
        }
    }
}

