/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import oracle.ide.config.Preferences;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.algorithm.BaseCompareModel;
import oracle.javatools.compare.algorithm.ExpirableContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compare.CompareManager;
import oracle.jdeveloper.compare.CompareMethod;
import oracle.jdeveloper.compare.FileNotComparableException;
import oracle.jdeveloper.compare.FileTooLargeException;
import oracle.jdeveloper.compare.IdeCompareContributor;
import oracle.jdeveloper.compare.IdeTextCompareContributor;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareOptions;
import oracle.jdevimpl.compare.StreamTextProcessor;

public final class CompareUtil2 {
    private CompareUtil2() {
    }

    public static final CompareMethod getCompareMethodForType(CompareType type) {
        for (CompareMethod compareMethod : CompareManager.getCompareManager().getCompareMethods()) {
            if (!compareMethod.getCompareType().equals((Object)type)) continue;
            return compareMethod;
        }
        return null;
    }

    public static final CompareModel createCompareModel(CompareContributor left, CompareContributor right, CompareInvocation invocationContext) throws CompareFailedException {
        URL referenceUrl = null;
        if (referenceUrl == null && invocationContext.getContextNode() != null && invocationContext.getContextNode() instanceof Locatable) {
            referenceUrl = ((Locatable)invocationContext.getContextNode()).getURL();
        }
        if (referenceUrl == null && right instanceof URLContributor) {
            referenceUrl = ((URLContributor)right).getURL();
        }
        if (referenceUrl == null && left instanceof URLContributor) {
            referenceUrl = ((URLContributor)left).getURL();
        }
        StreamTextProcessor.process(left, referenceUrl);
        StreamTextProcessor.process(right, referenceUrl);
        if (CompareUtil2.isContributorTextProcessed(left) || CompareUtil2.isContributorTextProcessed(right)) {
            while (invocationContext.hasMoreMethods()) {
                invocationContext.nextMethod();
            }
        }
        return CompareUtil2._createCompareModel(left, right, invocationContext);
    }

    private static final boolean isContributorTextProcessed(CompareContributor contributor) {
        return contributor instanceof IdeTextCompareContributor && ((IdeTextCompareContributor)contributor).isTextProcessed();
    }

    private static final CompareModel _createCompareModel(CompareContributor left, CompareContributor right, CompareInvocation invocationContext) throws CompareFailedException {
        CompareMethod compareMethod = invocationContext.getCurrentMethod();
        if (compareMethod == null) {
            invocationContext.setFailure(new FileNotComparableException());
            return null;
        }
        if (compareMethod.getCompareType().equals((Object)CompareType.TEXT) && (CompareUtil2.exceedsMaxTextFileSize(left) || CompareUtil2.exceedsMaxTextFileSize(right))) {
            invocationContext.setFailure(new FileTooLargeException());
            return null;
        }
        CompareOptions compareOptions = CompareUtil2.getCompareOptions();
        if (left instanceof TextCompareContributor) {
            ((TextCompareContributor)left).setIgnoreWhitespace(compareOptions.getIgnoreWhitespace());
        }
        if (right instanceof TextCompareContributor) {
            ((TextCompareContributor)right).setIgnoreWhitespace(compareOptions.getIgnoreWhitespace());
        }
        compareMethod.processOptions();
        try {
            Element contextNode = invocationContext.getContextNode();
            if (contextNode instanceof Node) {
                Node contextNodeAsNode = (Node)contextNode;
                if (left instanceof IdeCompareContributor) {
                    ((IdeCompareContributor)left).setContextNode(contextNodeAsNode);
                }
                if (right instanceof IdeCompareContributor) {
                    ((IdeCompareContributor)right).setContextNode(contextNodeAsNode);
                }
            }
            if (invocationContext.isCanceled()) {
                return null;
            }
            CompareAlgorithm compareAlgorithm = invocationContext.getCurrentAlgorithm();
            if (compareAlgorithm != null) {
                CompareModel compareModel;
                if (left instanceof ExpirableContributor) {
                    ((ExpirableContributor)left).reset();
                }
                if (right instanceof ExpirableContributor) {
                    ((ExpirableContributor)right).reset();
                }
                if ((compareModel = compareAlgorithm.compare(left, right)) != null) {
                    compareModel.setType(compareMethod.getCompareType());
                }
                if (compareModel instanceof BaseCompareModel) {
                    ((BaseCompareModel)compareModel).extend();
                }
                return compareModel;
            }
            if (invocationContext.isCanceled()) {
                return null;
            }
            throw new IllegalArgumentException("cannot create compare model with " + left + " and " + right);
        }
        catch (CompareFailedException cfe) {
            if (invocationContext.hasMoreMethods()) {
                invocationContext.nextMethod();
                return CompareUtil2._createCompareModel(left, right, invocationContext);
            }
            throw cfe;
        }
    }

    private static final boolean exceedsMaxTextFileSize(CompareContributor contributor) {
        return contributor instanceof TextCompareContributor && (double)((TextCompareContributor)contributor).getTextBuffer().getLength() > (double)CompareUtil2.getCompareOptions().getMaximumTextFileSize() * Math.pow(2.0, 10.0);
    }

    public static final StreamType getStreamType(CompareContributor contributor) {
        if (contributor instanceof InputStreamTextContributor) {
            return ((InputStreamTextContributor)contributor).getStreamType();
        }
        if (contributor instanceof URLContributor) {
            return ((URLContributor)contributor).getStreamType();
        }
        if (contributor instanceof TextNodeContributor) {
            TextNodeContributor textNodeContributor = (TextNodeContributor)contributor;
            TextBuffer textBuffer = textNodeContributor.getTextBuffer();
            int n = Math.min(textBuffer.getLength(), 512);
            if (textBuffer.getLength() <= 0) {
                return StreamType.OTHER;
            }
            try {
                return StreamDecoder.getStream(contributor.getType(), new ByteArrayInputStream(textBuffer.getString(0, n).getBytes(textNodeContributor.getTextNode().getSaveEncoding())), "UTF-8").getType();
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
                return null;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static final CompareOptions getCompareOptions() {
        return CompareOptions.getInstance((PropertyStorage)Preferences.getPreferences());
    }
}

