/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compare;

import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.Context;
import oracle.ide.compareapi.res.Bundle;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.algorithm.EditableContributor;
import oracle.jdeveloper.compare.IdeTextCompareContributor;
import oracle.jdeveloper.compare.PatchCompareContributor;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.compare.ResourceCompareContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdevimpl.compare.XmlContextFactory;

public class TextNodeContributor
extends IdeTextCompareContributor
implements EditableContributor,
PatchCompareContributor,
ResourceCompareContributor {
    private final TextNode _node;
    private final String _type;
    private TextBuffer _textBuffer;
    private PatchCompareDescriptor _patchDescriptor;

    public TextNodeContributor(TextNode node) {
        this._node = node;
        this._type = URLContributor.getPlatformPathSuffix(this._node.getURL());
        this.addTextBufferListeners();
        this.setDocumentModel(XmlContextFactory.getXmlContextFactory().findOrCreateContext(new Context((Node)node)));
    }

    @Override
    public TextBuffer getTextBuffer() {
        if (this._textBuffer == null) {
            this._textBuffer = this._node.acquireTextBuffer();
        }
        return this._textBuffer;
    }

    public String getType() {
        return this._type;
    }

    public String getShortLabel() {
        if (this._node.isDirty()) {
            return MessageFormat.format(Bundle.get("UNSAVED_FILE"), URLFileSystem.getFileName((URL)this._node.getURL()));
        }
        return MessageFormat.format(Bundle.get("FILE_ON_DISK"), URLFileSystem.getFileName((URL)this._node.getURL()));
    }

    public String getLongLabel() {
        return URLFileSystem.getPlatformPathName((URL)this._node.getURL());
    }

    public boolean isEditable() {
        try {
            return !this.getTextBuffer().isReadOnly();
        }
        catch (ExpiredTextBufferException etbe) {
            return false;
        }
    }

    public boolean isModified() {
        return this.getTextBuffer().isModified();
    }

    @Override
    public PatchCompareDescriptor getPatchDescriptor() {
        if (this._patchDescriptor == null) {
            this._patchDescriptor = new PatchCompareDescriptor(URLFileSystem.getFileName((URL)this._node.getURL()));
            this._patchDescriptor.setPatchParentURL(URLFileSystem.getParent((URL)this._node.getURL()));
        }
        this._patchDescriptor.setLastModified(this._node.isDirty() ? System.currentTimeMillis() : URLFileSystem.lastModified((URL)this._node.getURL()));
        return this._patchDescriptor;
    }

    public TextNode getTextNode() {
        return this._node;
    }

    @Override
    public Node getNode() {
        return this._node;
    }

    @Override
    public final URL getURL() {
        return this._node.getURL();
    }
}

