/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.version;

public class Version {
    private static Version s_clientVersion = null;
    private int[] m_versionArray = null;
    public static final int[] VERSION_10_0 = new int[]{10, 0};
    public static final int[] VERSION_10_1_0_3 = new int[]{10, 1, 0, 3};
    public static final int[] VERSION_10_1_0_4 = new int[]{10, 1, 0, 4};
    public static final int[] VERSION_10_1_0_5 = new int[]{10, 1, 0, 5};
    public static final int[] VERSION_10_2 = new int[]{10, 2};
    public static final int[] VERSION_11 = new int[]{11};
    public static final int[] VERSION_11_1_0_7 = new int[]{11, 1, 0, 7};
    public static final int[] VERSION_11_2 = new int[]{11, 2};
    public static final int[] VERSION_11_2_0_2 = new int[]{11, 2, 0, 2};
    public static final int[] VERSION_12_1_0_0 = new int[]{12, 1, 0, 0};
    public static final int[] VERSION_LATEST = VERSION_12_1_0_0;

    public Version(int[] nArray) {
        this.m_versionArray = nArray;
    }

    public Version(String string) {
        this.m_versionArray = Version.parseVersionString(string);
    }

    public final int[] getVersionArray() {
        return (int[])this.m_versionArray.clone();
    }

    public String getVersionString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (int i = 0; i < this.m_versionArray.length; ++i) {
            stringBuffer.append(string);
            stringBuffer.append(this.m_versionArray[i]);
            string = ".";
        }
        return stringBuffer.toString();
    }

    public boolean isSameOrLaterThan(Version version) {
        return Version.isLhsSameOrLaterThanRhs(this.m_versionArray, version.m_versionArray);
    }

    public boolean isSameOrLaterThan(int[] nArray) {
        return Version.isLhsSameOrLaterThanRhs(this.m_versionArray, nArray);
    }

    public Version getClientCompatibleVersion() {
        Version version = Version.getClientVersion();
        if (this.isSameOrLaterThan(version)) {
            return version;
        }
        return this;
    }

    public static Version getClientVersion() {
        if (null == s_clientVersion) {
            s_clientVersion = new Version("12.1.0.0.0");
        }
        return s_clientVersion;
    }

    public static void setClientVersion(int[] nArray) {
        s_clientVersion = new Version(nArray);
    }

    public static void setClientVersion(String string) {
        s_clientVersion = new Version(string);
    }

    protected static boolean isLhsSameOrLaterThanRhs(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int n;
        int n2 = Math.min(nArray.length, nArray2.length);
        for (n = 0; n < n2; ++n) {
            if (nArray[n] > nArray2[n]) {
                return true;
            }
            if (nArray[n] >= nArray2[n]) continue;
            return false;
        }
        if (nArray.length == nArray2.length) {
            return true;
        }
        int[] nArray4 = nArray3 = nArray.length > nArray2.length ? nArray : nArray2;
        while (n < nArray3.length) {
            if (0 != nArray3[n]) {
                return nArray3 == nArray;
            }
            ++n;
        }
        return true;
    }

    protected static int[] parseVersionString(String string) {
        int n = -1;
        int n2 = 0;
        while (0 <= (n = string.indexOf(46, n + 1))) {
            ++n2;
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        n = 0;
        int n4 = 0;
        while (n < string.length()) {
            n4 = string.indexOf(46, n);
            if (n4 < 0) {
                n4 = string.length();
            }
            String string2 = string.substring(n, n4);
            nArray[n3++] = Integer.parseInt(string2);
            n = n4 + 1;
        }
        return nArray;
    }

    public String getMetadataXMLVersion() {
        if (this.isSameOrLaterThan(VERSION_12_1_0_0)) {
            return "2.0";
        }
        if (this.isSameOrLaterThan(VERSION_11_2_0_2)) {
            return "1.3";
        }
        if (this.isSameOrLaterThan(VERSION_11_2)) {
            return "1.2";
        }
        if (this.isSameOrLaterThan(VERSION_11_1_0_7)) {
            return "1.1";
        }
        if (this.isSameOrLaterThan(VERSION_11)) {
            return "1.0";
        }
        return "0.1";
    }

    public boolean supportsZeroBasedPositions() {
        return this.isSameOrLaterThan(VERSION_10_0);
    }

    public boolean supportsXMLProlog() {
        return this.isSameOrLaterThan(VERSION_10_1_0_3);
    }

    public boolean supportsDefinitionManagerTag() {
        return this.isSameOrLaterThan(VERSION_10_2);
    }

    public boolean supportsRecommendedMaterializations() {
        return this.isSameOrLaterThan(VERSION_10_2);
    }

    public boolean supportsNativeDate() {
        return this.isSameOrLaterThan(VERSION_10_1_0_5);
    }

    public boolean supportsDataProviderSharing() {
        return this.isSameOrLaterThan(VERSION_10_2);
    }

    public boolean supportsGeneric() {
        return this.isSameOrLaterThan(VERSION_11);
    }

    public boolean supportsNamespaces() {
        return this.isSameOrLaterThan(VERSION_11_1_0_7);
    }

    public boolean supportsRenaming() {
        return this.isSameOrLaterThan(VERSION_11_1_0_7);
    }

    public boolean flushesSourceDefinitionsOnRootCommit() {
        return this.isSameOrLaterThan(VERSION_11_1_0_7);
    }
}

