/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.transaction.metadataStateManager;

import java.util.ArrayList;
import oracle.olapi.transaction.IncrementalChangeException;
import oracle.olapi.transaction.MetadataContext;
import oracle.olapi.transaction.metadataStateManager.BaseMetadataStateHolder;
import oracle.olapi.transaction.metadataStateManager.IncrementalMetadataState;
import oracle.olapi.transaction.metadataStateManager.MetadataStateManager;

public final class IncrementalMetadataStateHolder
extends BaseMetadataStateHolder {
    private boolean m_NeedsUpdate = false;
    private long m_GenerationNumber = 0L;
    private IncrementalMetadataState m_State = null;
    private boolean m_Valid = true;
    private boolean m_IsolationHolder = false;

    IncrementalMetadataStateHolder(IncrementalMetadataState incrementalMetadataState, MetadataStateManager metadataStateManager, MetadataContext metadataContext, long l, BaseMetadataStateHolder baseMetadataStateHolder) {
        super(metadataStateManager, metadataContext, baseMetadataStateHolder);
        this.m_State = incrementalMetadataState;
        this.m_GenerationNumber = l;
    }

    public final boolean isIsolationHolder() {
        return this.m_IsolationHolder;
    }

    public final void setIsIsolationHolder(boolean bl) {
        this.m_IsolationHolder = bl;
    }

    long getGenerationNumber() {
        return this.m_GenerationNumber;
    }

    public IncrementalMetadataState getIncrementalMetadataState(IncrementalMetadataStateHolder incrementalMetadataStateHolder, boolean bl) {
        IncrementalMetadataState incrementalMetadataState = this.getState();
        if (null == incrementalMetadataState || this.needsUpdate()) {
            incrementalMetadataState = this.updateFromParent(bl, false);
        }
        if (null != incrementalMetadataStateHolder) {
            incrementalMetadataStateHolder.setGenerationNumber(this.getGenerationNumber());
        }
        this.setNeedsUpdate(false);
        return incrementalMetadataState;
    }

    IncrementalMetadataState getIncrementalMetadataStateSince(MetadataContext metadataContext) {
        IncrementalMetadataStateHolder incrementalMetadataStateHolder;
        IncrementalMetadataState incrementalMetadataState = this.getIncrementalMetadataState(null, false);
        if (null == incrementalMetadataState) {
            return null;
        }
        ArrayList<IncrementalMetadataState> arrayList = new ArrayList<IncrementalMetadataState>();
        for (incrementalMetadataStateHolder = this; null != incrementalMetadataStateHolder && incrementalMetadataStateHolder.getMetadataContext() != metadataContext; incrementalMetadataStateHolder = (IncrementalMetadataStateHolder)incrementalMetadataStateHolder.getParent()) {
            if (null == incrementalMetadataStateHolder.getState()) continue;
            arrayList.add(incrementalMetadataStateHolder.getState());
        }
        if (null == incrementalMetadataStateHolder && null != metadataContext || arrayList.size() < 1) {
            return incrementalMetadataState.createState();
        }
        IncrementalMetadataState incrementalMetadataState2 = ((IncrementalMetadataState)arrayList.get(arrayList.size() - 1)).copyState();
        for (int i = arrayList.size() - 2; i >= 0; --i) {
            incrementalMetadataState2.updateFromChild((IncrementalMetadataState)arrayList.get(i));
        }
        return incrementalMetadataState2;
    }

    private IncrementalMetadataState getState() {
        return this.m_State;
    }

    @Override
    public boolean hasState() {
        return null != this.getState();
    }

    private void invalidate() {
        if (null != this.getState() && !this.isIsolationHolder()) {
            this.setNeedsUpdate(true);
        }
    }

    private boolean isValid() {
        return this.m_Valid;
    }

    private boolean needsUpdate() {
        return this.m_NeedsUpdate;
    }

    private void notifyChildrenOfChange() {
        for (BaseMetadataStateHolder baseMetadataStateHolder = this.getManager().getFirstHolder(); baseMetadataStateHolder != this; baseMetadataStateHolder = baseMetadataStateHolder.getNext()) {
            ((IncrementalMetadataStateHolder)baseMetadataStateHolder).invalidate();
        }
    }

    @Override
    public void revert() {
        this.setState(null);
        this.setIsIsolationHolder(false);
        this.setGenerationNumber(this.getManager().getNextGenerationNumber());
        this.notifyChildrenOfChange();
    }

    void setGenerationNumber(long l) {
        if (l > this.m_GenerationNumber) {
            this.m_GenerationNumber = l;
        }
    }

    private void setNeedsUpdate(boolean bl) {
        this.m_NeedsUpdate = bl;
    }

    void setState(IncrementalMetadataState incrementalMetadataState) {
        this.m_State = incrementalMetadataState;
    }

    private void setValid(boolean bl) {
        this.m_Valid = bl;
    }

    @Override
    void updateFromChild(BaseMetadataStateHolder baseMetadataStateHolder) {
        IncrementalMetadataState incrementalMetadataState = ((IncrementalMetadataStateHolder)baseMetadataStateHolder).getIncrementalMetadataState(null, false);
        if (null == incrementalMetadataState) {
            return;
        }
        if (this.getMetadataContext().isIsolationContext() && !this.isIsolationHolder()) {
            throw new IncrementalChangeException(null);
        }
        if (null == this.getState()) {
            this.setState(incrementalMetadataState);
        } else {
            this.getState().updateFromChild(incrementalMetadataState);
        }
        this.setGenerationNumber(this.getManager().getNextGenerationNumber());
        if (this.getChildCount() > 0) {
            this.notifyChildrenOfChange();
        }
    }

    @Override
    public void refresh() {
        this.updateFromParent(true, true);
        if (this.getChildCount() > 0) {
            this.notifyChildrenOfChange();
        }
    }

    private IncrementalMetadataState updateFromParent(boolean bl, boolean bl2) {
        IncrementalMetadataState incrementalMetadataState = this.getState();
        if (this.isIsolationHolder()) {
            if (null == incrementalMetadataState) {
                incrementalMetadataState = this.getManager().getIncrementalStateProvider().getInitialState(this.getMetadataContext());
                this.setState(incrementalMetadataState);
            } else {
                return incrementalMetadataState;
            }
        }
        if (null == this.getParent()) {
            return this.getState();
        }
        long l = this.getGenerationNumber();
        IncrementalMetadataStateHolder incrementalMetadataStateHolder = (IncrementalMetadataStateHolder)this.getParent();
        IncrementalMetadataState incrementalMetadataState2 = incrementalMetadataStateHolder.getIncrementalMetadataState(this, false);
        if (null == incrementalMetadataState2) {
            return this.getState();
        }
        if (null == incrementalMetadataState) {
            if (bl) {
                incrementalMetadataState = incrementalMetadataState2.createState();
                this.setState(incrementalMetadataState);
            } else {
                incrementalMetadataState = incrementalMetadataState2;
            }
        } else if (bl2 || this.getGenerationNumber() > l) {
            boolean bl3 = incrementalMetadataState.updateFromParent(incrementalMetadataState2);
            this.setGenerationNumber(this.getManager().getNextGenerationNumber());
            this.setValid(bl3);
        }
        return incrementalMetadataState;
    }
}

