/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.transaction;

import java.util.ArrayList;
import java.util.List;
import oracle.express.idl.util.WstringHolder;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.deployment.AWCubeOrganization;
import oracle.olapi.metadata.deployment.AWPrimaryDimensionOrganization;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.session.UserSession;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.BranchAWAttachedException;
import oracle.olapi.transaction.MetadataContext;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.Participant;
import oracle.olapi.transaction.ParticipantOwner;
import oracle.olapi.transaction.PersistentMetadataContext;
import oracle.olapi.transaction.TransactionInactiveException;

public class Branch
implements MetadataContext,
ParticipantOwner {
    private List m_aws = new ArrayList();
    private List m_attachTypes = new ArrayList();
    private UserSession m_Session = null;
    private long m_ContextNumber;
    private List m_Participants = null;
    private static final int STATUS_ACTIVE = 0;
    private static final int STATUS_CLOSING = 1;
    private static final int STATUS_CLOSED = 2;
    private int m_Status = 0;
    public static final String AW_ATTACH_TYPE_READ_ONLY = "READ_ONLY";
    public static final String AW_ATTACH_TYPE_WRITABLE = "WRITABLE";

    public Branch(UserSession userSession, List list, List list2) {
        this.m_Session = userSession;
        this.m_ContextNumber = PersistentMetadataContext.getNextContextNumber();
        try {
            this.addAWs(list, list2, true);
        }
        catch (BranchAWAttachedException branchAWAttachedException) {
            // empty catch block
        }
    }

    public boolean isActive() {
        return 0 == this.m_Status;
    }

    public boolean isClosing() {
        return 1 == this.m_Status;
    }

    public boolean isClosed() {
        return 2 == this.m_Status;
    }

    @Override
    public long getContextNumber() {
        return this.m_ContextNumber;
    }

    @Override
    public MetadataContext getOuterContext() {
        return PersistentMetadataContext.INSTANCE;
    }

    @Override
    public boolean isIsolationContext() {
        return true;
    }

    public UserSession getSession() {
        return this.m_Session;
    }

    public List getAWs() {
        return this.m_aws;
    }

    public List getAttachTypes() {
        return this.m_attachTypes;
    }

    private List getParticipants(boolean bl) {
        if (null == this.m_Participants && bl) {
            this.m_Participants = new ArrayList();
        }
        return this.m_Participants;
    }

    private void setParticipants(List list) {
        this.m_Participants = list;
    }

    @Override
    public synchronized void registerParticipant(Participant participant) throws TransactionInactiveException {
        this.getParticipants(true).add(participant);
    }

    @Override
    public synchronized void unregisterParticipant(Participant participant) {
        List list = this.getParticipants(false);
        if (null != list) {
            list.remove(participant);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsObject(BaseMetadataObject baseMetadataObject) {
        if (this.getAWs().isEmpty()) {
            return false;
        }
        BaseMetadataObject baseMetadataObject2 = baseMetadataObject.getTopLevelObject();
        AW aW = null;
        if (baseMetadataObject2 instanceof MdmCube) {
            MdmCube mdmCube = (MdmCube)baseMetadataObject2;
            if (mdmCube.getOrganization() == null || !(mdmCube.getOrganization() instanceof AWCubeOrganization)) return false;
            aW = ((AWCubeOrganization)mdmCube.getOrganization()).getAW();
        } else {
            if (!(baseMetadataObject2 instanceof MdmPrimaryDimension)) return false;
            MdmPrimaryDimension mdmPrimaryDimension = (MdmPrimaryDimension)baseMetadataObject2;
            if (mdmPrimaryDimension.getOrganization() == null || !(mdmPrimaryDimension.getOrganization() instanceof AWPrimaryDimensionOrganization)) return false;
            aW = ((AWPrimaryDimensionOrganization)mdmPrimaryDimension.getOrganization()).getAW();
        }
        if (null != aW) return this.getAWs().contains(aW);
        return false;
    }

    private void addAWs(List list, List arrayList, boolean bl) throws BranchAWAttachedException {
        if (!(bl || list != null && arrayList != null)) {
            return;
        }
        if (list != null && arrayList != null && list.size() != arrayList.size()) {
            throw new IllegalArgumentException();
        }
        if (!bl && list.isEmpty()) {
            return;
        }
        ArrayList<AW> arrayList2 = null;
        ArrayList arrayList3 = null;
        int n = list == null ? 0 : list.size();
        for (int i = 0; i < n; ++i) {
            AW aW = (AW)list.get(i);
            String object = (String)arrayList.get(i);
            int n2 = this.getAWs().indexOf(aW);
            if (n2 == -1) {
                if (arrayList2 == null) continue;
                arrayList2.add(aW);
                arrayList3.add(arrayList);
                continue;
            }
            String string = (String)this.getAttachTypes().get(n2);
            if (string.equals(object)) {
                if (arrayList2 != null) continue;
                arrayList2 = new ArrayList<AW>();
                arrayList3 = new ArrayList();
                for (int e = 0; e < i; ++e) {
                    arrayList2.add((AW)list.get(e));
                    arrayList3.add(arrayList.get(e));
                }
                continue;
            }
            throw new BranchAWAttachedException(aW.getName(), object, string);
        }
        if (arrayList2 != null && arrayList2.isEmpty()) {
            return;
        }
        if (arrayList2 == null) {
            arrayList2 = list;
            arrayList3 = arrayList;
        }
        WstringHolder wstringHolder = this.getSession().getDataProvider().addAWsToBranch(this.getSession(), arrayList2, arrayList3);
        if (arrayList2 == null || arrayList2.isEmpty()) {
            return;
        }
        this.m_aws.addAll(arrayList2);
        this.m_attachTypes.addAll(arrayList3);
        for (AW aW : arrayList2) {
            ArrayList<AW> arrayList4 = new ArrayList<AW>();
            arrayList4.add(aW);
            arrayList4.addAll(aW.getCubes());
            arrayList4.addAll(aW.getDimensions());
            for (int i = 0; i < arrayList4.size(); ++i) {
                Object e = arrayList4.get(i);
                BaseMetadataObject baseMetadataObject = e instanceof BaseMetadataObject ? (BaseMetadataObject)arrayList4.get(i) : (BaseMetadataObject)((MetadataObjectHolder)e).getMetadataObject();
                baseMetadataObject.createIsolationState(this);
                baseMetadataObject.getNestedSubObjects(arrayList4, false);
            }
        }
    }

    public void addAWs(List list, List list2) throws BranchAWAttachedException {
        this.addAWs(list, list2, false);
    }

    public void addAWs(List list) throws BranchAWAttachedException {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(AW_ATTACH_TYPE_READ_ONLY);
        }
        this.addAWs(list, arrayList);
    }

    public void addAW(AW aW, String string) throws BranchAWAttachedException {
        ArrayList<AW> arrayList = new ArrayList<AW>(1);
        arrayList.add(aW);
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.add(string);
        this.addAWs(arrayList, arrayList2);
    }

    public void addAW(AW aW) throws BranchAWAttachedException {
        ArrayList<AW> arrayList = new ArrayList<AW>(1);
        arrayList.add(aW);
        this.addAWs(arrayList);
    }

    public void removeAW(AW aW) {
        ArrayList<AW> arrayList = new ArrayList<AW>(1);
        arrayList.add(aW);
        this.removeAWs(arrayList);
    }

    public void removeAWs(List list) {
        Object object;
        int n;
        ArrayList<Object> arrayList = null;
        for (n = 0; n < list.size(); ++n) {
            object = (AW)list.get(n);
            int n2 = this.getAWs().indexOf(object);
            if (n2 == -1) {
                if (arrayList != null) continue;
                arrayList = new ArrayList<Object>();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(list.get(i));
                }
                continue;
            }
            this.m_aws.remove(n2);
            this.m_attachTypes.remove(n2);
            if (arrayList == null) continue;
            arrayList.add(object);
        }
        if (arrayList != null && arrayList.isEmpty()) {
            return;
        }
        if (null == arrayList) {
            arrayList = list;
        }
        object = this.getSession().getDataProvider().removeAWsFromBranch(this.getSession(), arrayList);
        for (AW aW : arrayList) {
            ArrayList arrayList2 = new ArrayList();
            aW.revertIsolationState(this);
            aW.getNestedSubObjects(arrayList2, false);
            arrayList2.addAll(aW.getCubes());
            arrayList2.addAll(aW.getDimensions());
            for (n = 0; n < arrayList2.size(); ++n) {
                BaseMetadataObject baseMetadataObject = (BaseMetadataObject)arrayList2.get(n);
                baseMetadataObject.revertIsolationState(this);
                baseMetadataObject.getNestedSubObjects(arrayList2, false);
            }
        }
    }

    private void rollbackTransaction(BaseTransaction baseTransaction) throws TransactionInactiveException {
        for (BaseTransaction baseTransaction2 = baseTransaction.getFirstSubtransaction(); null != baseTransaction2; baseTransaction2 = baseTransaction2.getNextSibling()) {
            this.rollbackTransaction(baseTransaction2);
        }
        baseTransaction.rollback();
    }

    public void close() throws TransactionInactiveException {
        Object object;
        Object object2;
        Object object3;
        this.m_Status = 1;
        try {
            object3 = this.getSession().getDataProvider().getTransactionProvider();
            object2 = object3.getCurrentTransaction();
            while (object2 != null) {
                object = object2.getParent();
                this.rollbackTransaction((BaseTransaction)object2);
                object2 = object;
            }
        }
        catch (TransactionInactiveException transactionInactiveException) {
            this.m_Status = 0;
            throw transactionInactiveException;
        }
        object3 = this.getParticipants(false);
        if (object3 != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Participant)object2.next();
                object.rollback();
            }
        }
        this.getSession().branchClosed();
        try {
            this.getSession().getRootBaseTransaction().getBaseTransactionProvider().rollbackRootTransaction(this.getSession().getRootBaseTransaction());
        }
        catch (NotCommittableException notCommittableException) {
            // empty catch block
        }
        object2 = this.getSession().getDataProvider().closeBranch(this.getSession());
        this.m_Status = 2;
    }
}

