/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax.parser;

import java.util.List;
import oracle.olapi.metadata.MetadataXMLParserCallback;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmQuery;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.metadata.mdm.MdmRootSchema;
import oracle.olapi.metadata.mdm.MdmTable;
import oracle.olapi.syntax.BaseQuery;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.DimensionArgument;
import oracle.olapi.syntax.FunctionDescriptorDimensionArgument;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.UnresolvedMetadataObjectReference;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.Identifier;

public class IdentifierResolver {
    private String m_Owner = null;
    private List<Query> m_Queries = null;
    private MdmMetadataProvider m_MetadataProvider = null;
    private MdmRootSchema m_RootSchema = null;
    private MetadataXMLParserCallback m_XMLCallback = null;

    private String getOwner() {
        return this.m_Owner;
    }

    private List<Query> getQueries() {
        return this.m_Queries;
    }

    private MdmMetadataProvider getMetadataProvider() {
        return this.m_MetadataProvider;
    }

    private MdmRootSchema getRootSchema() {
        return this.m_RootSchema;
    }

    private MetadataXMLParserCallback getXMLCallback() {
        return this.m_XMLCallback;
    }

    private boolean fullyQualifyObjectID(Identifier identifier, int n, boolean bl, Class clazz) {
        return this.fullyQualifyObjectID(identifier, n, n, bl, clazz);
    }

    public boolean fullyQualifyObjectID(Identifier identifier, int n, int n2, boolean bl, Class clazz) {
        Identifier identifier2;
        boolean bl2 = false;
        int n3 = identifier.getNumComponents();
        if (identifier.hasNamespace()) {
            ++n;
            ++n2;
        }
        if (n3 == n - 1) {
            bl2 = true;
        } else if (n3 == n2) {
            bl2 = false;
        } else if (n != n2 && n3 == n) {
            if (null != this.getXMLCallback() && this.getXMLCallback().getXMLReader().isForRenameOnImport()) {
                if (n == 2 && n2 == 3) {
                    bl2 = true;
                } else if (n == 3 && n2 == 4) {
                    bl2 = false;
                }
            } else {
                MdmObject mdmObject;
                identifier2 = new Identifier(identifier);
                if (null != this.getOwner()) {
                    identifier2.addOwner(this.getOwner());
                }
                bl2 = null != (mdmObject = this.getMdmObject(identifier2));
            }
        } else {
            if (bl) {
                this.error(identifier);
            }
            return false;
        }
        if (bl2 && null != this.getOwner()) {
            identifier.addOwner(this.getOwner());
        }
        if (null != this.getXMLCallback()) {
            identifier2 = this.getXMLCallback().applyRenameForSyntaxID(identifier, null, clazz);
            identifier.setValue(identifier2);
        }
        return true;
    }

    private MdmObject getMdmObject(Identifier identifier) {
        if (null == this.getMetadataProvider()) {
            return null;
        }
        return this.getMetadataProvider().getMdmObject(identifier);
    }

    public void error(Identifier identifier) {
        throw new SyntaxException("InvalidIdentifier", identifier.toString());
    }

    public Query getQuery(Identifier identifier) {
        return this.getQuery(identifier, true);
    }

    Query getQuery(Identifier identifier, boolean bl) {
        boolean bl2;
        if (1 == identifier.getNumComponents() && null != this.getQueries()) {
            for (Query object2 : this.getQueries()) {
                if (!object2.getName().equals(identifier)) continue;
                return object2;
            }
        }
        if (!(bl2 = this.fullyQualifyObjectID(identifier, 2, bl, MdmQuery.class))) {
            return null;
        }
        MdmObject mdmObject = this.getMdmObject(identifier);
        Query query = null;
        if (mdmObject instanceof MdmCube) {
            query = ((MdmCube)mdmObject).getQuery();
        } else if (mdmObject instanceof MdmPrimaryDimension) {
            query = ((MdmPrimaryDimension)mdmObject).getQuery();
        } else if (mdmObject instanceof MdmTable) {
            query = ((MdmTable)mdmObject).getQuery();
        } else if (mdmObject instanceof MdmHierarchy) {
            query = ((MdmHierarchy)mdmObject).getQuery();
        }
        if (null == query) {
            query = new BaseQuery(null, new UnresolvedMetadataObjectReference(identifier, this, 2, MdmQuery.class));
        }
        return query;
    }

    private MdmObject getMdmObjectAndID(Identifier identifier, int n, Class clazz) {
        boolean bl = this.fullyQualifyObjectID(identifier, n, n, true, clazz);
        if (null != this.getMetadataProvider()) {
            return this.getMetadataProvider().getMdmObject(identifier);
        }
        return null;
    }

    public MdmObject getMdmObjectAndID(Identifier identifier, int n, int n2, Class clazz) {
        boolean bl = this.fullyQualifyObjectID(identifier, n, n2, true, clazz);
        MdmObject mdmObject = null;
        if (null == this.getMetadataProvider()) {
            return null;
        }
        mdmObject = this.getMetadataProvider().getMdmObject(identifier);
        if (null == mdmObject) {
            return null;
        }
        if (clazz.isAssignableFrom(mdmObject.getClass())) {
            return mdmObject;
        }
        return null;
    }

    public UnresolvedMetadataObjectReference getUnresolvedMetadataObjectReference(Identifier identifier, Class clazz, int n) {
        return new UnresolvedMetadataObjectReference(identifier, this, n, clazz);
    }

    DataType getDataType(Identifier identifier) {
        if (identifier.getNumComponents() > 1) {
            this.error(identifier);
        }
        String string = this.getString(identifier);
        DataType[] dataTypeArray = DataType.LITERAL_DATA_TYPES;
        for (int i = 0; i < dataTypeArray.length; ++i) {
            if (!dataTypeArray[i].getName().equals(string)) continue;
            return dataTypeArray[i];
        }
        return null;
    }

    void resolveHierarchyList(List list, UnresolvedMetadataObjectReference unresolvedMetadataObjectReference) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Identifier identifier = (Identifier)list.get(i);
            Identifier identifier2 = new Identifier(unresolvedMetadataObjectReference.getIdentifier());
            identifier2.addComponent(identifier.toString());
            UnresolvedMetadataObjectReference unresolvedMetadataObjectReference2 = this.getUnresolvedMetadataObjectReference(identifier2, MdmHierarchy.class, 3);
            list.set(i, unresolvedMetadataObjectReference2);
        }
    }

    public TypedExpression getColumnExpression(Identifier identifier, boolean bl) {
        Object object;
        String string = identifier.getName();
        identifier.removeLastComponent();
        Query query = this.getQuery(identifier, false);
        identifier.addComponent(string);
        if (null != this.getXMLCallback()) {
            object = this.getXMLCallback().applyRenameForSyntaxID(identifier, identifier.getParentID(), MdmQueryColumn.class);
            identifier.setValue((Identifier)object);
        }
        object = null;
        if (null != query) {
            object = query.getColumnExpression(identifier.getName());
        }
        if (null == object && bl) {
            this.error(identifier);
        }
        return object;
    }

    public DimensionArgument getDimensionArgument(Identifier identifier, ValidationContext validationContext, int n, boolean bl) {
        int n2;
        int n3 = FunctionDescriptorDimensionArgument.getMinExpectedNumComponents(n);
        boolean bl2 = this.fullyQualifyObjectID(identifier, n3, n2 = FunctionDescriptorDimensionArgument.getMaxExpectedNumComponents(n), bl, MdmDimension.class);
        if (!bl2) {
            return null;
        }
        MdmObject mdmObject = this.getMdmObject(identifier);
        if (mdmObject instanceof MdmDimension) {
            MdmDimension mdmDimension = (MdmDimension)mdmObject;
            return new DimensionArgument(mdmDimension);
        }
        if (bl) {
            this.error(identifier);
        }
        return null;
    }

    public String getString(Identifier identifier) {
        int n = identifier.getNumComponents();
        if (1 == n) {
            return identifier.getComponent(0);
        }
        return identifier.toString();
    }

    public String getComponent(Identifier identifier, int n) {
        return identifier.getComponent(n);
    }

    public String getOracleID(String string) {
        if (null == string) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        if ('\"' == string.charAt(0)) {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }

    public IdentifierResolver(String string, List list, MdmMetadataProvider mdmMetadataProvider, MetadataXMLParserCallback metadataXMLParserCallback) {
        this.m_Owner = this.getOracleID(string);
        this.m_Queries = list;
        this.m_MetadataProvider = mdmMetadataProvider;
        this.m_XMLCallback = metadataXMLParserCallback;
        if (null != mdmMetadataProvider && mdmMetadataProvider.getRootSchema() instanceof MdmRootSchema) {
            this.m_RootSchema = (MdmRootSchema)mdmMetadataProvider.getRootSchema();
        }
    }
}

