/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.FunctionDescriptor;
import oracle.olapi.syntax.FunctionDescriptorCatalog;
import oracle.olapi.syntax.SimpleCommand;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

public abstract class SolveStepCommand
extends SimpleCommand {
    private String m_FunctionName;
    private FunctionDescriptor m_FunctionDescriptor;
    private FunctionArgument[] m_Arguments;

    private FunctionArgument[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    SolveStepCommand(String string, FunctionArgument[] functionArgumentArray, boolean bl) {
        SolveStepCommand.validateValue(string);
        this.m_FunctionName = string;
        this.m_Arguments = bl ? SolveStepCommand.getFunctionArgumentArrayClone(functionArgumentArray) : functionArgumentArray;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append(this.getFunctionName());
        if (null != this.getArgumentsInternal() && this.getArgumentsInternal().length > 0) {
            Expression.printExpressions(this.getArgumentsInternal(), syntaxPrintingContext);
        }
    }

    SyntaxObject validate(int n, ValidationContext validationContext) {
        validationContext.push(this);
        FunctionArgument[] functionArgumentArray = null;
        if (null != this.getArgumentsInternal()) {
            functionArgumentArray = new FunctionArgument[this.getArgumentsInternal().length];
        }
        this.m_FunctionDescriptor = FunctionDescriptorCatalog.getValidFunctionDescriptor(this.getFunctionName(), this.getArgumentsInternal(), functionArgumentArray, null, null, n, "UnknownSolveFunction", validationContext);
        this.m_Arguments = functionArgumentArray;
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (null != this.getArgumentsInternal()) {
            return this.areComponentsComplete(this.getArgumentsInternal());
        }
        return true;
    }

    public FunctionArgument[] getArguments() {
        return (FunctionArgument[])this.getArgumentsInternal().clone();
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.m_FunctionDescriptor;
    }

    public String getFunctionName() {
        return this.m_FunctionName;
    }
}

