/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.syntax.CaseExpression;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.SimpleCase;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class SimpleCaseExpression
extends CaseExpression {
    private SimpleCase[] m_Cases = null;
    private TypedExpression m_SwitchExpression = null;

    private SimpleCase[] getCasesInternal() {
        return this.m_Cases;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("CASE ");
        syntaxPrintingContext.print(this.getSwitchExpression());
        for (int i = 0; i < this.getCasesInternal().length; ++i) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.print(this.getCasesInternal()[i]);
        }
        syntaxPrintingContext.newLineAndIndent();
        if (null != this.getElseExpression()) {
            syntaxPrintingContext.append("ELSE ");
            syntaxPrintingContext.print(this.getElseExpression());
            syntaxPrintingContext.newLineAndIndent();
        }
        syntaxPrintingContext.append("END ");
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        this.m_SwitchExpression = (TypedExpression)validationContext.validate(this.m_SwitchExpression);
        validationContext.pop();
        validationContext.validateComponents(this, this.getCasesInternal());
        this.setDataType(DataType.NULL_TYPE);
        int n = -1;
        for (int i = 0; i < this.getCasesInternal().length; ++i) {
            n = this.validateExpression(this.getCasesInternal()[i].getThenExpression(), n);
        }
        this.validateExpression(this.getElseExpression(), n);
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return super.checkIfDefinitionIsComplete() && this.getSwitchExpression().isDefinitionComplete() && this.areComponentsComplete(this.getCasesInternal());
    }

    public SimpleCaseExpression(TypedExpression typedExpression, SimpleCase[] simpleCaseArray, TypedExpression typedExpression2) {
        super(typedExpression2);
        SimpleCaseExpression.validateValue(typedExpression);
        SimpleCaseExpression.validateValues(simpleCaseArray);
        this.m_SwitchExpression = typedExpression;
        this.m_Cases = (SimpleCase[])simpleCaseArray.clone();
        this.initialize();
    }

    public SimpleCaseExpression(TypedExpression typedExpression, List<SimpleCase> list, TypedExpression typedExpression2) {
        super(typedExpression2);
        SimpleCaseExpression.validateValue(typedExpression);
        SimpleCaseExpression.validateValues(list);
        this.m_SwitchExpression = typedExpression;
        this.m_Cases = new SimpleCase[list.size()];
        list.toArray(this.m_Cases);
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitSimpleCaseExpression(this, object);
    }

    public SimpleCase[] getCases() {
        return (SimpleCase[])this.getCasesInternal().clone();
    }

    public TypedExpression getSwitchExpression() {
        return this.m_SwitchExpression;
    }
}

