/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmDimensionLevel;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SimpleCommand;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public abstract class MaintainDimensionCommand
extends SimpleCommand {
    public static final String ALL_HIERARCHIES = "ALL HIERARCHIES";
    public static final String HIERARCHIES = "HIERARCHIES";
    public static final String DIMENSION = "DIMENSION";
    static final String[] MAINTAIN_TYPES = new String[]{"ALL HIERARCHIES", "HIERARCHIES", "DIMENSION"};
    private BaseMetadataObjectReference[] m_Hierarchies;
    private TypedExpression m_MemberExpression;
    private TypedExpression m_ParentExpression;
    private BaseMetadataObjectReference m_Level;
    private String m_MaintainType;

    protected static MdmHierarchy[] createMdmHierarchyArray(List<MdmHierarchy> list) {
        if (null == list) {
            return null;
        }
        MdmHierarchy[] mdmHierarchyArray = new MdmHierarchy[list.size()];
        list.toArray(mdmHierarchyArray);
        return mdmHierarchyArray;
    }

    protected static BaseMetadataObjectReference[] createMdmHierarchyArray(ExpParser expParser, List<BaseMetadataObjectReference> list) {
        if (null == list) {
            return null;
        }
        BaseMetadataObjectReference[] baseMetadataObjectReferenceArray = new BaseMetadataObjectReference[list.size()];
        list.toArray(baseMetadataObjectReferenceArray);
        return baseMetadataObjectReferenceArray;
    }

    private BaseMetadataObjectReference[] getHierarchiesInternal() {
        return this.m_Hierarchies;
    }

    protected MaintainDimensionCommand(String string, MdmHierarchy[] mdmHierarchyArray, TypedExpression typedExpression, TypedExpression typedExpression2, MdmDimensionLevel mdmDimensionLevel, boolean bl) {
        this.m_MaintainType = MaintainDimensionCommand.validateEnum(string, MAINTAIN_TYPES);
        if (HIERARCHIES != this.m_MaintainType) {
            this.m_Hierarchies = new BaseMetadataObjectReference[0];
        } else {
            MaintainDimensionCommand.validateValues(mdmHierarchyArray);
            this.m_Hierarchies = new BaseMetadataObjectReference[mdmHierarchyArray.length];
            for (int i = 0; i < mdmHierarchyArray.length; ++i) {
                this.m_Hierarchies[i] = new MetadataObjectReference(mdmHierarchyArray[i], MdmHierarchy.class);
            }
        }
        MaintainDimensionCommand.validateValue(typedExpression);
        this.m_MemberExpression = typedExpression;
        if (this.isParentRequired()) {
            MaintainDimensionCommand.validateValue(typedExpression2);
        } else if (this.isForDimension()) {
            typedExpression2 = null;
        }
        this.m_ParentExpression = typedExpression2;
        this.m_Level = null != mdmDimensionLevel ? new MetadataObjectReference(mdmDimensionLevel, MdmDimensionLevel.class) : null;
        this.initialize();
    }

    protected MaintainDimensionCommand(ExpParser expParser, String string, BaseMetadataObjectReference[] baseMetadataObjectReferenceArray, TypedExpression typedExpression, TypedExpression typedExpression2, BaseMetadataObjectReference baseMetadataObjectReference, boolean bl) {
        this.m_MaintainType = MaintainDimensionCommand.validateEnum(string, MAINTAIN_TYPES);
        if (HIERARCHIES != this.m_MaintainType) {
            this.m_Hierarchies = new BaseMetadataObjectReference[0];
        } else {
            MaintainDimensionCommand.validateValues(baseMetadataObjectReferenceArray);
            this.m_Hierarchies = bl ? (BaseMetadataObjectReference[])baseMetadataObjectReferenceArray.clone() : baseMetadataObjectReferenceArray;
        }
        MaintainDimensionCommand.validateValue(typedExpression);
        this.m_MemberExpression = typedExpression;
        if (this.isParentRequired()) {
            MaintainDimensionCommand.validateValue(typedExpression2);
        } else if (this.isForDimension()) {
            typedExpression2 = null;
        }
        this.m_ParentExpression = typedExpression2;
        this.m_Level = baseMetadataObjectReference;
        this.initialize();
    }

    protected MaintainDimensionCommand(String string, MdmHierarchy[] mdmHierarchyArray, TypedExpression typedExpression, TypedExpression typedExpression2, MdmDimensionLevel mdmDimensionLevel) {
        this(string, mdmHierarchyArray, typedExpression, typedExpression2, mdmDimensionLevel, true);
    }

    protected MaintainDimensionCommand(String string, List<MdmHierarchy> list, TypedExpression typedExpression, TypedExpression typedExpression2, MdmDimensionLevel mdmDimensionLevel) {
        this(string, MaintainDimensionCommand.createMdmHierarchyArray(list), typedExpression, typedExpression2, mdmDimensionLevel, false);
    }

    protected MaintainDimensionCommand(ExpParser expParser, String string, List<BaseMetadataObjectReference> list, TypedExpression typedExpression, TypedExpression typedExpression2, BaseMetadataObjectReference baseMetadataObjectReference) {
        this(expParser, string, MaintainDimensionCommand.createMdmHierarchyArray(expParser, list), typedExpression, typedExpression2, baseMetadataObjectReference, false);
    }

    protected final void appendHierarchyClause(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append(this.getType());
        if (HIERARCHIES == this.getType()) {
            syntaxPrintingContext.append(" (");
            for (int i = 0; i < this.getHierarchiesInternal().length; ++i) {
                if (0 != i) {
                    syntaxPrintingContext.append(", ");
                }
                this.getHierarchiesInternal()[i].toSyntax(syntaxPrintingContext);
            }
            syntaxPrintingContext.append(")");
        }
    }

    protected final void appendLevelExpression(SyntaxPrintingContext syntaxPrintingContext) {
        if (null != this.m_Level) {
            this.m_Level.toSyntax(syntaxPrintingContext);
        } else {
            syntaxPrintingContext.append("NULL");
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        this.m_MemberExpression = validationContext.validateExp(this.m_MemberExpression);
        if (null != this.m_ParentExpression) {
            this.m_ParentExpression = validationContext.validateExp(this.m_ParentExpression);
        }
        validationContext.pop();
        if (null != this.m_Level) {
            this.m_Level = (BaseMetadataObjectReference)validationContext.validate(this.m_Level);
        }
        if (null != this.getHierarchiesInternal()) {
            for (int i = 0; i < this.getHierarchiesInternal().length; ++i) {
                this.getHierarchiesInternal()[i] = (BaseMetadataObjectReference)validationContext.validate(this.getHierarchiesInternal()[i]);
            }
        }
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!super.checkIfDefinitionIsComplete() || !this.getMemberExpression().isDefinitionComplete()) {
            return false;
        }
        if (null != this.getParentExpression() && !this.getParentExpression().isDefinitionComplete()) {
            return false;
        }
        if (null != this.m_Level && !this.m_Level.isDefinitionComplete()) {
            return false;
        }
        if (null != this.getHierarchiesInternal()) {
            for (int i = 0; i < this.getHierarchiesInternal().length; ++i) {
                if (this.getHierarchiesInternal()[i].isDefinitionComplete()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isParentRequired() {
        return !this.isForDimension();
    }

    protected final boolean isForDimension() {
        return DIMENSION == this.getType();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitMaintainDimensionCommand(this, object);
    }

    public final MdmHierarchy[] getHierarchies() {
        if (null != this.getHierarchiesInternal()) {
            MdmHierarchy[] mdmHierarchyArray = new MdmHierarchy[this.getHierarchiesInternal().length];
            for (int i = 0; i < this.getHierarchiesInternal().length; ++i) {
                mdmHierarchyArray[i] = (MdmHierarchy)this.getHierarchiesInternal()[i].getBaseMetadataObject();
            }
            return mdmHierarchyArray;
        }
        return null;
    }

    public final String[] getHierarchyIDs() {
        if (null != this.getHierarchiesInternal()) {
            String[] stringArray = new String[this.getHierarchiesInternal().length];
            for (int i = 0; i < this.getHierarchiesInternal().length; ++i) {
                stringArray[i] = this.getHierarchiesInternal()[i].getIdentifier().toString();
            }
            return stringArray;
        }
        return null;
    }

    public final TypedExpression getMemberExpression() {
        return this.m_MemberExpression;
    }

    public final TypedExpression getParentExpression() {
        return this.m_ParentExpression;
    }

    public final MdmDimensionLevel getLevel() {
        if (null != this.m_Level) {
            return (MdmDimensionLevel)this.m_Level.getBaseMetadataObject();
        }
        return null;
    }

    public final String getLevelID() {
        if (null != this.m_Level) {
            return this.m_Level.getIdentifier().toString();
        }
        return null;
    }

    public final String getType() {
        return this.m_MaintainType;
    }
}

