/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.List;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.DuplicateMetadataIDException;
import oracle.olapi.metadata.MetadataFactoryException;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.PersistentLanguageFetcher;
import oracle.olapi.metadata.XMLReaderPropertyAction;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.deployment.AWPrimaryDimensionOrganization;
import oracle.olapi.metadata.deployment.DeploymentException;
import oracle.olapi.metadata.deployment.PrimaryDimensionOrganization;
import oracle.olapi.metadata.deployment.RolapPrimaryDimensionOrganization;
import oracle.olapi.metadata.mapping.MemberListMap;
import oracle.olapi.metadata.mdm.Mdm10_1_0_3_NamingConvention;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmBaseAttribute;
import oracle.olapi.metadata.mdm.MdmCustomMember;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmDerivedAttribute;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionCalculationModel;
import oracle.olapi.metadata.mdm.MdmDimensionLevel;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMemberListMapOwner;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmMultiValuedDerivedAttribute;
import oracle.olapi.metadata.mdm.MdmNamingConvention;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmQuery;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.metadata.mdm.MdmValueConverter;
import oracle.olapi.metadata.mdm.MdmValueHierarchy;
import oracle.olapi.metadata.mdm.MdmViewColumn;
import oracle.olapi.metadata.mdm.MdmViewColumnOwner;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.metadata.mtm.MtmBaseCube;
import oracle.olapi.metadata.mtm.MtmCube;
import oracle.olapi.metadata.mtm.MtmObject;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;
import oracle.olapi.metadata.mtm.MtmSourceMap;
import oracle.olapi.metadata.mtm.MtmTabularSource;
import oracle.olapi.metadata.mtm.MtmValueExpression;
import oracle.olapi.syntax.BaseQuery;
import oracle.olapi.syntax.Buildable;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SQLDataType;
import oracle.olapi.transaction.Branch;

public abstract class MdmPrimaryDimension
extends MdmDimension
implements MdmMemberListMapOwner,
MdmViewColumnOwner,
MdmQuery,
Buildable {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.ANCESTORS_ATTRIBUTE, MdmXMLTags.ATTRIBUTES, MdmXMLTags.BOOLEAN_CALC_MODEL, MdmXMLTags.DATE_CALC_MODEL, MdmXMLTags.DEFAULT_CALC_MODEL, MdmXMLTags.DEFAULT_COMPONENT, MdmXMLTags.DIMENSION_CALC_MODELS, MdmXMLTags.DIMENSION_LEVELS, MdmXMLTags.DIMENSION_ORGANIZATION, MdmXMLTags.HIERARCHY_ATTRIBUTE, MdmXMLTags.IS_92_LIST_DIMENSION, MdmXMLTags.IS_CUSTOM_MEMBER_ATTRIBUTE, MdmXMLTags.LEVEL_ATTRIBUTE, MdmXMLTags.LEVEL_DEPTH_ATTRIBUTE, MdmXMLTags.LOCAL_VALUE, MdmXMLTags.MEMBER_LIST_MAP, MdmXMLTags.NAMESPACE, MdmXMLTags.NUMBER_CALC_MODEL, MdmXMLTags.OWNER, MdmXMLTags.PARENT_ATTRIBUTE, MdmXMLTags.SHORT_VALUE_DESC, MdmXMLTags.DIMENSION_SQL_DATA_TYPE, MdmXMLTags.STRING_CALC_MODEL, MdmXMLTags.SUB_DIM_REF, MdmXMLTags.VALUE_DESC, MdmXMLTags.VALUE_LINEAGE_ATTRIBUTE, MdmXMLTags.VALUE_SEPARATION_STRING, MdmXMLTags.ET_VIEW_NAME, MdmXMLTags.ET_KEY_COLUMN_NAME, MdmXMLTags.ET_LEVEL_COLUMN_NAME, MdmXMLTags.ET_LOCAL_VALUE_COLUMN_NAME, MdmXMLTags.ET_DIM_ORDER_COLUMN_NAME, MdmXMLTags.ET_HIER_ORDER_COLUMN_NAME, MdmXMLTags.ET_MEMBER_TYPE_COLUMN_NAME, MdmXMLTags.CUSTOM_MEMBER};
    private static final String ET_KEY_COLUMN_NAME = "DIM_KEY";
    private static final String ET_LEVEL_COLUMN_NAME = "LEVEL_NAME";
    private static final String ET_LOCAL_VALUE_COLUMN_NAME = "LOCAL_VALUE";
    private static final String ET_DIM_ORDER_COLUMN_NAME = "DIM_ORDER";
    private static final String ET_HIER_ORDER_COLUMN_NAME = "HIER_ORDER";
    private static final String ET_MEMBER_TYPE_COLUMN_NAME = "MEMBER_TYPE";
    private BaseQuery m_Query = null;
    private MdmViewColumn m_KeyColumn = null;
    private MdmViewColumn m_LevelNameColumn = null;
    private MdmViewColumn m_LocalValueColumn = null;
    private MdmViewColumn m_DimOrderColumn = null;
    private MdmViewColumn m_HierOrderColumn = null;
    private MdmViewColumn m_MemberTypeColumn = null;

    private synchronized void createViewColumns() {
        if (null != this.m_LevelNameColumn) {
            return;
        }
        this.m_LevelNameColumn = new MdmViewColumn(this, ET_LEVEL_COLUMN_NAME, MdmXMLTags.ET_LEVEL_COLUMN_NAME, new SQLDataType("VARCHAR2(30)"));
        this.m_MemberTypeColumn = new MdmViewColumn(this, ET_MEMBER_TYPE_COLUMN_NAME, MdmXMLTags.ET_MEMBER_TYPE_COLUMN_NAME, new SQLDataType("VARCHAR2(1)"));
        this.m_DimOrderColumn = new MdmViewColumn(this, ET_DIM_ORDER_COLUMN_NAME, MdmXMLTags.ET_DIM_ORDER_COLUMN_NAME, DataType.NUMBER.toSQLDataType());
        this.m_HierOrderColumn = new MdmViewColumn(this, ET_HIER_ORDER_COLUMN_NAME, MdmXMLTags.ET_HIER_ORDER_COLUMN_NAME, DataType.NUMBER.toSQLDataType());
        this.m_KeyColumn = new MdmViewColumn(this, ET_KEY_COLUMN_NAME, MdmXMLTags.ET_KEY_COLUMN_NAME);
        this.m_LocalValueColumn = new MdmViewColumn(this, ET_LOCAL_VALUE_COLUMN_NAME, MdmXMLTags.ET_LOCAL_VALUE_COLUMN_NAME);
    }

    private synchronized void createQuery() {
        if (null != this.m_Query) {
            return;
        }
        this.m_Query = new BaseQuery(this);
    }

    MdmPrimaryDimension(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public MdmPrimaryDimension(String string, String string2, short s, BaseMetadataProvider baseMetadataProvider) {
        super(string, string2, s, baseMetadataProvider, null);
    }

    @Override
    public SQLDataType getSQLDataType() {
        SQLDataType sQLDataType = (SQLDataType)this.getPropertyObjectValue(MdmXMLTags.DIMENSION_SQL_DATA_TYPE);
        if (null != sQLDataType) {
            return sQLDataType;
        }
        return new SQLDataType("VARCHAR2(60)");
    }

    final void populateBaseETViewColumns(List list) {
        list.add(this.getETKeyColumn());
        list.add(this.getETLevelNameColumn());
        list.add(this.getETLocalValueColumn());
        list.add(this.getETMemberTypeColumn());
        if (this.getETDimensionOrderColumn() != null) {
            list.add(this.getETDimensionOrderColumn());
        }
        if (this.getETHierarchyOrderColumn() != null) {
            list.add(this.getETHierarchyOrderColumn());
        }
    }

    final MdmQueryColumn getBaseETViewColumn(String string) {
        if (ET_KEY_COLUMN_NAME.equals(string)) {
            return this.getETKeyColumn();
        }
        if (ET_LOCAL_VALUE_COLUMN_NAME.equals(string)) {
            return this.getETLocalValueColumn();
        }
        if (ET_LEVEL_COLUMN_NAME.equals(string)) {
            return this.getETLevelNameColumn();
        }
        if (ET_MEMBER_TYPE_COLUMN_NAME.equals(string)) {
            return this.getETMemberTypeColumn();
        }
        if (ET_DIM_ORDER_COLUMN_NAME.equals(string)) {
            return this.getETDimensionOrderColumn();
        }
        if (ET_HIER_ORDER_COLUMN_NAME.equals(string)) {
            return this.getETHierarchyOrderColumn();
        }
        return null;
    }

    public static final XMLTag classGetContainedByPropertyTag() {
        return null;
    }

    public MdmAttribute getAncestorsAttribute() throws MetadataNotFoundException {
        return (MdmAttribute)this.getPropertyObjectValue(MdmXMLTags.ANCESTORS_ATTRIBUTE);
    }

    public final List getHierarchies() {
        return this.getPropertyListValues(MdmXMLTags.SUB_DIM_REF);
    }

    public final MdmHierarchy getHierarchy(String string) {
        if (null == string) {
            return null;
        }
        List list = this.getHierarchies();
        for (MdmHierarchy mdmHierarchy : list) {
            if (!string.equals(mdmHierarchy.getName())) continue;
            return mdmHierarchy;
        }
        return null;
    }

    public MdmHierarchy getDefaultHierarchy() {
        return (MdmHierarchy)this.getPropertyObjectValue(MdmXMLTags.DEFAULT_COMPONENT);
    }

    @Override
    public final MdmPrimaryDimension getPrimaryDimension(short s) {
        return this;
    }

    public MdmAttribute getParentAttribute() throws MetadataNotFoundException {
        return (MdmAttribute)this.getPropertyObjectValue(MdmXMLTags.PARENT_ATTRIBUTE);
    }

    public final MdmAttribute getShortValueDescriptionAttribute() throws MetadataNotFoundException {
        return (MdmAttribute)this.getPropertyObjectValue(MdmXMLTags.SHORT_VALUE_DESC);
    }

    public final MdmAttribute getValueDescriptionAttribute() throws MetadataNotFoundException {
        return (MdmAttribute)this.getPropertyObjectValue(MdmXMLTags.VALUE_DESC);
    }

    public final MdmAttribute getLevelAttribute() {
        return (MdmAttribute)this.getPropertyObjectValue(MdmXMLTags.LEVEL_ATTRIBUTE);
    }

    public final MdmAttribute getLevelDepthAttribute() {
        return (MdmAttribute)this.getPropertyObjectValue(MdmXMLTags.LEVEL_DEPTH_ATTRIBUTE);
    }

    public final MdmAttribute getLocalValueAttribute() throws MetadataNotFoundException {
        return (MdmAttribute)this.getPropertyObjectValue(MdmXMLTags.LOCAL_VALUE);
    }

    public final MdmAttribute getHierarchyAttribute() throws MetadataNotFoundException {
        return (MdmAttribute)this.getPropertyObjectValue(MdmXMLTags.HIERARCHY_ATTRIBUTE);
    }

    public final MdmAttribute getIsCustomMemberAttribute() throws MetadataNotFoundException {
        return (MdmAttribute)this.getPropertyObjectValue(MdmXMLTags.IS_CUSTOM_MEMBER_ATTRIBUTE);
    }

    public final MdmAttribute getValueLineageAttribute() throws MetadataNotFoundException {
        return (MdmAttribute)this.getPropertyObjectValue(MdmXMLTags.VALUE_LINEAGE_ATTRIBUTE);
    }

    public final String getValueSeparationString() {
        String string = this.getPropertyStringValue(MdmXMLTags.VALUE_SEPARATION_STRING);
        if ("".equals(string)) {
            string = "::";
        }
        return string;
    }

    MdmValueConverter getValueConverter() {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getValueConverter();
    }

    public final String getNamespace() {
        return this.getPropertyStringValue(MdmXMLTags.NAMESPACE);
    }

    protected final void setNamespace(String string) {
        this.setPropertyStringValue(MdmXMLTags.NAMESPACE, string);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public final void set92ListDimension(boolean bl) {
        this.setPropertyBooleanValue(MdmXMLTags.IS_92_LIST_DIMENSION, bl);
    }

    public final boolean is92ListDimension() {
        return this.getPropertyBooleanValue(MdmXMLTags.IS_92_LIST_DIMENSION);
    }

    @Override
    protected void finishObjectCreation() {
        super.finishObjectCreation();
        if (!this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            return;
        }
        this.populateDimCalcModels();
        this.populateDerivedAttributes();
    }

    private void populateDerivedAttributes() {
        try {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            FundamentalMetadataProvider fundamentalMetadataProvider = mdmMetadataProvider.getDataProvider().getFundamentalMetadataProvider();
            this.ensureDerivedAttribute(MdmXMLTags.DIM_KEY, ET_KEY_COLUMN_NAME, fundamentalMetadataProvider.getStringDataType());
            this.ensureDerivedAttribute(MdmXMLTags.LEVEL_NAME, ET_LEVEL_COLUMN_NAME, fundamentalMetadataProvider.getStringDataType());
            this.ensureDerivedAttribute(MdmXMLTags.DIM_ORDER, ET_DIM_ORDER_COLUMN_NAME, fundamentalMetadataProvider.getStringDataType());
            this.ensureDerivedAttribute(MdmXMLTags.LOCAL_VALUE, "LOCAL_VALUE_ATTRIBUTE", fundamentalMetadataProvider.getStringDataType());
            this.ensureDerivedAttribute(MdmXMLTags.PARENT_ATTRIBUTE, "PARENT_ATTRIBUTE", fundamentalMetadataProvider.getStringDataType());
            this.ensureDerivedAttribute(MdmXMLTags.ANCESTORS_ATTRIBUTE, "ANCESTORS_ATTRIBUTE", fundamentalMetadataProvider.getStringDataType());
            this.ensureDerivedAttribute(MdmXMLTags.LEVEL_ATTRIBUTE, "LEVEL_ATTRIBUTE", fundamentalMetadataProvider.getStringDataType());
            this.ensureDerivedAttribute(MdmXMLTags.LEVEL_DEPTH_ATTRIBUTE, "LEVELDEPTH_ATTRIBUTE", fundamentalMetadataProvider.getNumberDataType());
            this.ensureDerivedAttribute(MdmXMLTags.HIERARCHY_ATTRIBUTE, "HIERARCHY_ATTRIBUTE", fundamentalMetadataProvider.getStringDataType());
            this.ensureDerivedAttribute(MdmXMLTags.IS_CUSTOM_MEMBER_ATTRIBUTE, "ISCUSTOMMEMBER_ATTRIBUTE", fundamentalMetadataProvider.getBooleanDataType());
            this.ensureDerivedAttribute(MdmXMLTags.VALUE_LINEAGE_ATTRIBUTE, "VALUE_LINEAGE_ATTRIBUTE", fundamentalMetadataProvider.getStringDataType());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void ensureDerivedAttribute(XMLTag xMLTag, String string, FundamentalMetadataObject fundamentalMetadataObject) {
        if (!this.getMetadataProvider().getDataProvider().read11gMetadata() && this.hasProperty(xMLTag)) {
            return;
        }
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        boolean bl = true;
        MdmAttribute mdmAttribute = null;
        mdmAttribute = string == "ANCESTORS_ATTRIBUTE" ? this.findOrCreateMultiValuedDerivedAttribute(xMLTag, string, string2, this.getPersistenceType(), bl) : this.findOrCreateDerivedAttribute(xMLTag, string, string2, this.getPersistenceType(), bl);
        MdmXMLTags.DATA_TYPE.initializeProperty((BaseMetadataObject)mdmAttribute, (Object)fundamentalMetadataObject.getID(), this.getPersistenceType());
        if (fundamentalMetadataObject == this.getMetadataProvider().getDataProvider().getFundamentalMetadataProvider().getBooleanDataType()) {
            MdmXMLTags.IS_BOOLEAN_VALUED.initializeProperty((BaseMetadataObject)mdmAttribute, (Object)"True", this.getPersistenceType());
        }
    }

    private void populateDimCalcModels() {
        try {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            FundamentalMetadataProvider fundamentalMetadataProvider = mdmMetadataProvider.getDataProvider().getFundamentalMetadataProvider();
            this.ensureCalcModel(MdmXMLTags.BOOLEAN_CALC_MODEL, "Boolean", fundamentalMetadataProvider.getBooleanDataType());
            this.ensureCalcModel(MdmXMLTags.STRING_CALC_MODEL, "String", fundamentalMetadataProvider.getStringDataType());
            this.ensureCalcModel(MdmXMLTags.DATE_CALC_MODEL, "Date", fundamentalMetadataProvider.getDateDataType());
            this.ensureCalcModel(MdmXMLTags.NUMBER_CALC_MODEL, "Number", fundamentalMetadataProvider.getNumberDataType());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void ensureCalcModel(XMLTag xMLTag, String string, FundamentalMetadataObject fundamentalMetadataObject) {
        if (!this.getMetadataProvider().getDataProvider().read11gMetadata() && this.hasProperty(xMLTag)) {
            return;
        }
        MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
        MdmNamingConvention mdmNamingConvention = mdmMetadataProvider.getMdmNamingConvention();
        if (null == mdmNamingConvention || !(mdmNamingConvention instanceof Mdm10_1_0_3_NamingConvention)) {
            return;
        }
        Mdm10_1_0_3_NamingConvention mdm10_1_0_3_NamingConvention = (Mdm10_1_0_3_NamingConvention)mdmNamingConvention;
        String string2 = mdm10_1_0_3_NamingConvention.generateDimensionCalculationModelID(this, string);
        boolean bl = true;
        MdmDimensionCalculationModel mdmDimensionCalculationModel = this.findOrCreateDimCalcModel(xMLTag, "", string2, this.getPersistenceType(), bl);
        MdmXMLTags.DATA_TYPE.initializeProperty((BaseMetadataObject)mdmDimensionCalculationModel, (Object)fundamentalMetadataObject.getID(), this.getPersistenceType());
    }

    public MdmAttribute createNumericAttribute(String string, MtmValueExpression mtmValueExpression) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createNumericAttribute(string, this, mtmValueExpression);
    }

    public MdmAttribute createNumericAttribute(String string, String string2) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createNumericAttribute(string, this, string2);
    }

    public MdmAttribute createDateAttribute(String string, MtmValueExpression mtmValueExpression) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createDateAttribute(string, this, mtmValueExpression);
    }

    public MdmAttribute createDateAttribute(String string, String string2) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createDateAttribute(string, this, string2);
    }

    public MdmAttribute createStringAttribute(String string, MtmValueExpression mtmValueExpression) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createStringAttribute(string, this, mtmValueExpression);
    }

    public MdmAttribute createStringAttribute(String string, String string2) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createStringAttribute(string, this, string2);
    }

    public MdmAttribute createBooleanAttribute(String string, MtmValueExpression mtmValueExpression) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createBooleanAttribute(string, this, mtmValueExpression);
    }

    public MdmAttribute createBooleanAttribute(String string, String string2) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createBooleanAttribute(string, this, string2);
    }

    public void setDefaultHierarchy(MdmHierarchy mdmHierarchy) {
        if (null != mdmHierarchy && !this.getHierarchies().contains(mdmHierarchy)) {
            throw new MetadataFactoryException("HierarchyNotFound_2", mdmHierarchy.getName(), this.getName());
        }
        this.setPropertyObjectValue(MdmXMLTags.DEFAULT_COMPONENT, mdmHierarchy);
    }

    public void addHierarchy(MdmHierarchy mdmHierarchy) {
        if (this.getDefaultHierarchy() == null) {
            this.setPropertyObjectValue(MdmXMLTags.DEFAULT_COMPONENT, mdmHierarchy);
        }
        this.addToListProperty(MdmXMLTags.SUB_DIM_REF, mdmHierarchy);
        if (null == mdmHierarchy.getPrimaryDimension()) {
            mdmHierarchy.setPrimaryDimension(this);
        }
        if (null != this.getSourceMap()) {
            this.getSourceMap().setMdmSource(this);
        }
    }

    public void removeHierarchy(MdmHierarchy mdmHierarchy) {
        MtmObject mtmObject2;
        this.removeFromListProperty(MdmXMLTags.SUB_DIM_REF, mdmHierarchy);
        if (mdmHierarchy == this.getDefaultHierarchy()) {
            if (this.getHierarchies().isEmpty()) {
                this.setPropertyObjectValue(MdmXMLTags.DEFAULT_COMPONENT, null);
            } else {
                this.setPropertyObjectValue(MdmXMLTags.DEFAULT_COMPONENT, (MdmObject)this.getHierarchies().get(0));
            }
        }
        for (MtmObject mtmObject2 : this.getMetadataProvider().getPartitionedCubes()) {
            if (!((MtmCube)mtmObject2).getDimensionMaps().contains(this.getSourceMap())) continue;
            for (MtmBaseCube mtmBaseCube : ((MtmPartitionedCube)mtmObject2).getBaseCubes()) {
                if (!mtmBaseCube.getDimensionMaps().contains(mdmHierarchy.getSourceMap())) continue;
                ((MtmPartitionedCube)mtmObject2).removeBaseCube(mtmBaseCube);
            }
        }
        mtmObject2 = this.getSourceMap();
        if (null != mtmObject2) {
            ((MtmSourceMap)mtmObject2).setMdmSource(this);
        }
    }

    public MdmLevelHierarchy createLevelHierarchy(String string, MdmLevelHierarchy mdmLevelHierarchy) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createLevelHierarchy(string, this, mdmLevelHierarchy);
    }

    public MdmLevelHierarchy createUnsolvedLevelHierarchy(String string, MtmTabularSource mtmTabularSource) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createUnsolvedLevelHierarchy(string, this, mtmTabularSource);
    }

    public MdmLevelHierarchy createSolvedLevelHierarchy(String string, MtmTabularSource mtmTabularSource, MtmValueExpression mtmValueExpression, MtmValueExpression mtmValueExpression2, MtmValueExpression mtmValueExpression3, MtmValueExpression mtmValueExpression4) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createSolvedLevelHierarchy(string, this, mtmTabularSource, mtmValueExpression, mtmValueExpression2, mtmValueExpression3, mtmValueExpression4);
    }

    public MdmValueHierarchy createValueHierarchy(String string, MdmLevelHierarchy mdmLevelHierarchy) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createValueHierarchy(string, this, mdmLevelHierarchy);
    }

    @Override
    public MdmDimension getEnclosingDimension() {
        return null;
    }

    void setDerivedAttribute(XMLTag xMLTag, MdmAttribute mdmAttribute) {
        if (xMLTag == MdmXMLTags.LOCAL_VALUE || xMLTag == MdmXMLTags.PARENT_ATTRIBUTE || xMLTag == MdmXMLTags.ANCESTORS_ATTRIBUTE || xMLTag == MdmXMLTags.LEVEL_ATTRIBUTE || xMLTag == MdmXMLTags.LEVEL_DEPTH_ATTRIBUTE || xMLTag == MdmXMLTags.HIERARCHY_ATTRIBUTE || xMLTag == MdmXMLTags.IS_CUSTOM_MEMBER_ATTRIBUTE || xMLTag == MdmXMLTags.VALUE_LINEAGE_ATTRIBUTE) {
            this.setPropertyObjectValue(xMLTag, mdmAttribute);
        }
    }

    public final void setShortValueDescriptionAttribute(MdmAttribute mdmAttribute) {
        this.setPropertyObjectValue(MdmXMLTags.SHORT_VALUE_DESC, mdmAttribute);
    }

    public final void setValueDescriptionAttribute(MdmAttribute mdmAttribute) {
        this.setPropertyObjectValue(MdmXMLTags.VALUE_DESC, mdmAttribute);
    }

    public final void setValueSeparationString(String string) {
        this.setPropertyStringValue(MdmXMLTags.VALUE_SEPARATION_STRING, string);
    }

    public final MdmDimensionCalculationModel getBooleanCalcModel() {
        return (MdmDimensionCalculationModel)this.getPropertyObjectValue(MdmXMLTags.BOOLEAN_CALC_MODEL);
    }

    public final MdmDimensionCalculationModel getStringCalcModel() {
        return (MdmDimensionCalculationModel)this.getPropertyObjectValue(MdmXMLTags.STRING_CALC_MODEL);
    }

    public final MdmDimensionCalculationModel getDateCalcModel() {
        return (MdmDimensionCalculationModel)this.getPropertyObjectValue(MdmXMLTags.DATE_CALC_MODEL);
    }

    public final MdmDimensionCalculationModel getNumberCalcModel() {
        return (MdmDimensionCalculationModel)this.getPropertyObjectValue(MdmXMLTags.NUMBER_CALC_MODEL);
    }

    public final void setBooleanCalcModel(MdmDimensionCalculationModel mdmDimensionCalculationModel) {
        this.setPropertyObjectValue(MdmXMLTags.BOOLEAN_CALC_MODEL, mdmDimensionCalculationModel);
    }

    public final void setStringCalcModel(MdmDimensionCalculationModel mdmDimensionCalculationModel) {
        this.setPropertyObjectValue(MdmXMLTags.STRING_CALC_MODEL, mdmDimensionCalculationModel);
    }

    public final void setDateCalcModel(MdmDimensionCalculationModel mdmDimensionCalculationModel) {
        this.setPropertyObjectValue(MdmXMLTags.DATE_CALC_MODEL, mdmDimensionCalculationModel);
    }

    public final void setNumberCalcModel(MdmDimensionCalculationModel mdmDimensionCalculationModel) {
        this.setPropertyObjectValue(MdmXMLTags.NUMBER_CALC_MODEL, mdmDimensionCalculationModel);
    }

    abstract List getMembers();

    MdmDimensionCalculationModel getExtractModel() {
        return this.getStringCalcModel();
    }

    public final void addDimensionLevel(MdmDimensionLevel mdmDimensionLevel) {
        this.addToListProperty(MdmXMLTags.DIMENSION_LEVELS, mdmDimensionLevel);
    }

    public final void removeDimensionLevel(MdmDimensionLevel mdmDimensionLevel) {
        this.removeFromListProperty(MdmXMLTags.DIMENSION_LEVELS, mdmDimensionLevel);
    }

    public final List getDimensionLevels() {
        return this.getPropertyListValues(MdmXMLTags.DIMENSION_LEVELS);
    }

    public final void addModel(MdmDimensionCalculationModel mdmDimensionCalculationModel) {
        this.addToListProperty(MdmXMLTags.DIMENSION_CALC_MODELS, mdmDimensionCalculationModel);
    }

    public final void removeModel(MdmDimensionCalculationModel mdmDimensionCalculationModel) {
        this.removeFromListProperty(MdmXMLTags.DIMENSION_CALC_MODELS, mdmDimensionCalculationModel);
    }

    public final List getModels() {
        return this.getPropertyListValues(MdmXMLTags.DIMENSION_CALC_MODELS);
    }

    public final MdmDimensionCalculationModel getDefaultCalcModel() {
        return (MdmDimensionCalculationModel)this.getPropertyObjectValue(MdmXMLTags.DEFAULT_CALC_MODEL);
    }

    public final void setDefaultCalcModel(MdmDimensionCalculationModel mdmDimensionCalculationModel) {
        this.setPropertyObjectValue(MdmXMLTags.DEFAULT_CALC_MODEL, mdmDimensionCalculationModel);
    }

    @Override
    public final MdmSchema getOwner() {
        MdmSchema mdmSchema = (MdmSchema)this.getPropertyObjectValue(MdmXMLTags.OWNER);
        if (mdmSchema == null) {
            return this.getMetadataProvider().getRootSchema();
        }
        return mdmSchema;
    }

    public final void setOwner(MdmDatabaseSchema mdmDatabaseSchema) {
        this.setPropertyObjectValue(MdmXMLTags.OWNER, mdmDatabaseSchema);
    }

    @Override
    public final MemberListMap getMemberListMap() {
        return (MemberListMap)this.getPropertyObjectValue(MdmXMLTags.MEMBER_LIST_MAP);
    }

    @Override
    public final void setMemberListMap(MemberListMap memberListMap) {
        this.setPropertyObjectValue(MdmXMLTags.MEMBER_LIST_MAP, memberListMap);
    }

    @Override
    public List getAttributes() {
        return this.getPropertyListValues(MdmXMLTags.ATTRIBUTES);
    }

    @Override
    public void addAttribute(MdmAttribute mdmAttribute) {
        this.addToListProperty(MdmXMLTags.ATTRIBUTES, mdmAttribute);
    }

    @Override
    public void removeAttribute(MdmAttribute mdmAttribute) {
        this.removeFromListProperty(MdmXMLTags.ATTRIBUTES, mdmAttribute);
    }

    @Override
    protected final SourceDefinition getTypeDefinition() {
        return this.getBaseMetadataProvider().getDataProvider().getFundamentalMetadataProvider().getStringDataType().getSource().getDefinition();
    }

    public final PrimaryDimensionOrganization getOrganization() {
        return (PrimaryDimensionOrganization)this.getPropertyObjectValue(MdmXMLTags.DIMENSION_ORGANIZATION);
    }

    private final void setOrganization(PrimaryDimensionOrganization primaryDimensionOrganization) {
        this.setPropertyObjectValue(MdmXMLTags.DIMENSION_ORGANIZATION, primaryDimensionOrganization);
    }

    public final AWPrimaryDimensionOrganization createAWOrganization(AW aW, boolean bl) {
        Branch branch = this.getBaseMetadataProvider().getDataProvider().getCurrentSession().getBranch();
        PrimaryDimensionOrganization primaryDimensionOrganization = this.getOrganization();
        if (!(null == primaryDimensionOrganization || bl && null == branch)) {
            boolean bl2;
            boolean bl3 = bl2 = !bl;
            if (!bl2) {
                if (branch.getAWs().contains(aW)) {
                    bl2 = true;
                } else if (primaryDimensionOrganization instanceof AWPrimaryDimensionOrganization && branch.getAWs().contains(((AWPrimaryDimensionOrganization)primaryDimensionOrganization).getAW())) {
                    bl2 = true;
                }
            }
            if (bl2) {
                throw new DeploymentException("DimensionAlreadyDeployed", this.getID());
            }
        }
        String string = "$AW_ORGANIZATION";
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        AWPrimaryDimensionOrganization aWPrimaryDimensionOrganization = new AWPrimaryDimensionOrganization(string2, string, 0, (BaseMetadataObject)this);
        aWPrimaryDimensionOrganization.setAW(aW);
        this.setOrganization(aWPrimaryDimensionOrganization);
        if (null != branch && branch.getAWs().contains(aW)) {
            this.createIsolationState(branch);
        }
        return aWPrimaryDimensionOrganization;
    }

    public final AWPrimaryDimensionOrganization findOrCreateAWPrimaryDimensionOrganization(AW aW) {
        String string = "$AW_ORGANIZATION";
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        AWPrimaryDimensionOrganization aWPrimaryDimensionOrganization = (AWPrimaryDimensionOrganization)this.findOrCreateContainedObject(string2, string, (short)0, MdmXMLTags.DIMENSION_ORGANIZATION, AWPrimaryDimensionOrganization.class);
        aWPrimaryDimensionOrganization.setAW(aW);
        Branch branch = this.getBaseMetadataProvider().getDataProvider().getCurrentSession().getBranch();
        if (null != branch && branch.getAWs().contains(aW)) {
            this.createIsolationState(branch);
        }
        return aWPrimaryDimensionOrganization;
    }

    public final RolapPrimaryDimensionOrganization createRolapOrganization(boolean bl) {
        PrimaryDimensionOrganization primaryDimensionOrganization = this.getOrganization();
        if (null != primaryDimensionOrganization && !bl) {
            throw new DeploymentException("DimensionAlreadyDeployed", this.getID());
        }
        String string = "$ROLAP_ORGANIZATION";
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        RolapPrimaryDimensionOrganization rolapPrimaryDimensionOrganization = new RolapPrimaryDimensionOrganization(string2, string, 0, (BaseMetadataObject)this);
        this.setOrganization(rolapPrimaryDimensionOrganization);
        return rolapPrimaryDimensionOrganization;
    }

    public final RolapPrimaryDimensionOrganization findOrCreateRolapPrimaryDimensionOrganization() {
        String string = "$ROLAP_ORGANIZATION";
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        RolapPrimaryDimensionOrganization rolapPrimaryDimensionOrganization = (RolapPrimaryDimensionOrganization)this.findOrCreateContainedObject(string2, string, (short)0, MdmXMLTags.DIMENSION_ORGANIZATION, RolapPrimaryDimensionOrganization.class);
        return rolapPrimaryDimensionOrganization;
    }

    public final String getETViewName() {
        return this.getPropertyStringValue(MdmXMLTags.ET_VIEW_NAME);
    }

    public final void setETViewName(String string) {
        this.setPropertyStringValue(MdmXMLTags.ET_VIEW_NAME, string);
    }

    public final MdmViewColumn getETKeyColumn() {
        if (null == this.m_KeyColumn) {
            this.createViewColumns();
        }
        return this.m_KeyColumn;
    }

    public final MdmViewColumn getETLocalValueColumn() {
        if (null == this.m_LocalValueColumn) {
            this.createViewColumns();
        }
        return this.m_LocalValueColumn;
    }

    public final MdmViewColumn getETLevelNameColumn() {
        if (null == this.m_LevelNameColumn) {
            this.createViewColumns();
        }
        return this.m_LevelNameColumn;
    }

    public final MdmViewColumn getETMemberTypeColumn() {
        if (null == this.m_MemberTypeColumn) {
            this.createViewColumns();
        }
        return this.m_MemberTypeColumn;
    }

    public final MdmViewColumn getETDimensionOrderColumn() {
        if (null == this.m_DimOrderColumn) {
            this.createViewColumns();
        }
        return this.m_DimOrderColumn;
    }

    public final MdmViewColumn getETHierarchyOrderColumn() {
        if (null == this.m_HierOrderColumn) {
            this.createViewColumns();
        }
        return this.m_HierOrderColumn;
    }

    @Override
    public final Query getQuery() {
        if (null == this.m_Query) {
            this.createQuery();
        }
        return this.m_Query;
    }

    @Override
    public final List<MdmQueryColumn> getQueryColumns() {
        ArrayList<MdmQueryColumn> arrayList = new ArrayList<MdmQueryColumn>();
        this.populateBaseETViewColumns(arrayList);
        this.populateAttributeColumnList(arrayList);
        return arrayList;
    }

    @Override
    public final String getQueryName() {
        return this.getID();
    }

    @Override
    public MdmQueryColumn getQueryColumn(String string) {
        if (null == string) {
            return null;
        }
        MdmQueryColumn mdmQueryColumn = this.getBaseETViewColumn(string);
        if (null != mdmQueryColumn) {
            return mdmQueryColumn;
        }
        mdmQueryColumn = this.getAttributeColumn(string);
        return mdmQueryColumn;
    }

    @Override
    public MetadataObject getType() {
        return this.getMetadataProvider().getDataProvider().getFundamentalMetadataProvider().getStringDataType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdmLevelHierarchy findOrCreateLevelHierarchy(String string) {
        MdmLevelHierarchy mdmLevelHierarchy = null;
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        MetadataObject metadataObject = this.getMetadataProvider().fetchMetadataObject(string2);
        if (null == metadataObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                metadataObject = this.getMetadataProvider().fetchMetadataObject(string2);
                if (null == metadataObject) {
                    mdmLevelHierarchy = new MdmLevelHierarchy(string, 0, this);
                    this.addHierarchy(mdmLevelHierarchy);
                    return mdmLevelHierarchy;
                }
            }
        }
        if (metadataObject instanceof MdmLevelHierarchy) {
            mdmLevelHierarchy = (MdmLevelHierarchy)metadataObject;
            this.addHierarchy(mdmLevelHierarchy);
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return mdmLevelHierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdmValueHierarchy findOrCreateValueHierarchy(String string) {
        MdmValueHierarchy mdmValueHierarchy = null;
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        MetadataObject metadataObject = this.getMetadataProvider().fetchMetadataObject(string2);
        if (null == metadataObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                metadataObject = this.getMetadataProvider().fetchMetadataObject(string2);
                if (null == metadataObject) {
                    mdmValueHierarchy = new MdmValueHierarchy(string, 0, this);
                    this.addHierarchy(mdmValueHierarchy);
                    return mdmValueHierarchy;
                }
            }
        }
        if (metadataObject instanceof MdmValueHierarchy) {
            mdmValueHierarchy = (MdmValueHierarchy)metadataObject;
            this.addHierarchy(mdmValueHierarchy);
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return mdmValueHierarchy;
    }

    public MdmDimensionLevel findOrCreateDimensionLevel(String string) {
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        return (MdmDimensionLevel)this.findOrCreateContainedObject(string2, string, (short)0, MdmXMLTags.DIMENSION_LEVELS, MdmDimensionLevel.class);
    }

    public MdmMultiValuedDerivedAttribute findOrCreateMultiValuedDerivedAttribute(String string) {
        boolean bl = false;
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        return this.findOrCreateMultiValuedDerivedAttribute(MdmXMLTags.ATTRIBUTES, string, string2, (short)0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MdmMultiValuedDerivedAttribute findOrCreateMultiValuedDerivedAttribute(XMLTag xMLTag, String string, String string2, short s, boolean bl) {
        Object object;
        MdmMultiValuedDerivedAttribute mdmMultiValuedDerivedAttribute = null;
        MetadataObject metadataObject = null;
        metadataObject = bl ? this.getMetadataProvider().fetchClientMetadataObject(string2, s, this) : this.getMetadataProvider().fetchMetadataObject(string2);
        if (null == metadataObject) {
            object = this.getMetadataProvider();
            synchronized (object) {
                metadataObject = bl ? this.getMetadataProvider().fetchClientMetadataObject(string2, s, this) : this.getMetadataProvider().fetchMetadataObject(string2);
                if (null == metadataObject) {
                    mdmMultiValuedDerivedAttribute = new MdmMultiValuedDerivedAttribute(string, string2, s, this);
                    xMLTag.initializeProperty((BaseMetadataObject)this, (Object)mdmMultiValuedDerivedAttribute.getInternalID(), s);
                    return mdmMultiValuedDerivedAttribute;
                }
            }
        }
        if (metadataObject instanceof MdmMultiValuedDerivedAttribute) {
            mdmMultiValuedDerivedAttribute = (MdmMultiValuedDerivedAttribute)metadataObject;
            xMLTag.initializeProperty((BaseMetadataObject)this, (Object)mdmMultiValuedDerivedAttribute.getInternalID(), s);
            if (bl) {
                object = new XMLReaderPropertyAction(s, true);
                mdmMultiValuedDerivedAttribute.getContainedByPropertyTag().initializeProperty((BaseMetadataObject)mdmMultiValuedDerivedAttribute, (Object)this.getInternalID(), (XMLReaderPropertyAction)object);
                MdmXMLTags.NAME.initializeProperty((BaseMetadataObject)mdmMultiValuedDerivedAttribute, (Object)string, (XMLReaderPropertyAction)object);
                mdmMultiValuedDerivedAttribute.finishObjectCreation();
            }
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return mdmMultiValuedDerivedAttribute;
    }

    public MdmDerivedAttribute findOrCreateDerivedAttribute(String string) {
        boolean bl = false;
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        return this.findOrCreateDerivedAttribute(MdmXMLTags.ATTRIBUTES, string, string2, (short)0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MdmDerivedAttribute findOrCreateDerivedAttribute(XMLTag xMLTag, String string, String string2, short s, boolean bl) {
        Object object;
        MdmDerivedAttribute mdmDerivedAttribute = null;
        MetadataObject metadataObject = null;
        metadataObject = bl ? this.getMetadataProvider().fetchClientMetadataObject(string2, s, this) : this.getMetadataProvider().fetchMetadataObject(string2);
        if (null == metadataObject) {
            object = this.getMetadataProvider();
            synchronized (object) {
                metadataObject = bl ? this.getMetadataProvider().fetchClientMetadataObject(string2, s, this) : this.getMetadataProvider().fetchMetadataObject(string2);
                if (null == metadataObject) {
                    mdmDerivedAttribute = new MdmDerivedAttribute(string, string2, s, this);
                    xMLTag.initializeProperty((BaseMetadataObject)this, (Object)mdmDerivedAttribute.getInternalID(), s);
                    return mdmDerivedAttribute;
                }
            }
        }
        if (metadataObject instanceof MdmDerivedAttribute) {
            mdmDerivedAttribute = (MdmDerivedAttribute)metadataObject;
            xMLTag.initializeProperty((BaseMetadataObject)this, (Object)mdmDerivedAttribute.getInternalID(), s);
            if (bl) {
                object = new XMLReaderPropertyAction(s, true);
                mdmDerivedAttribute.getContainedByPropertyTag().initializeProperty((BaseMetadataObject)mdmDerivedAttribute, (Object)this.getInternalID(), (XMLReaderPropertyAction)object);
                MdmXMLTags.NAME.initializeProperty((BaseMetadataObject)mdmDerivedAttribute, (Object)string, (XMLReaderPropertyAction)object);
                mdmDerivedAttribute.finishObjectCreation();
            }
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return mdmDerivedAttribute;
    }

    public MdmDimensionCalculationModel findOrCreateDimCalcModel(String string) {
        boolean bl = false;
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        return this.findOrCreateDimCalcModel(MdmXMLTags.DIMENSION_CALC_MODELS, string, string2, (short)0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MdmDimensionCalculationModel findOrCreateDimCalcModel(XMLTag xMLTag, String string, String string2, short s, boolean bl) {
        MdmDimensionCalculationModel mdmDimensionCalculationModel = null;
        MetadataObject metadataObject = null;
        metadataObject = bl ? this.getMetadataProvider().fetchClientMetadataObject(string2, s, this) : this.getMetadataProvider().fetchMetadataObject(string2);
        if (null == metadataObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                metadataObject = bl ? this.getMetadataProvider().fetchClientMetadataObject(string2, s, this) : this.getMetadataProvider().fetchMetadataObject(string2);
                if (null == metadataObject) {
                    mdmDimensionCalculationModel = new MdmDimensionCalculationModel(string, string2, s, this);
                    xMLTag.initializeProperty((BaseMetadataObject)this, (Object)mdmDimensionCalculationModel.getInternalID(), s);
                    return mdmDimensionCalculationModel;
                }
            }
        }
        if (metadataObject instanceof MdmDimensionCalculationModel) {
            mdmDimensionCalculationModel = (MdmDimensionCalculationModel)metadataObject;
            xMLTag.initializeProperty((BaseMetadataObject)this, (Object)mdmDimensionCalculationModel.getInternalID(), s);
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return mdmDimensionCalculationModel;
    }

    public MdmBaseAttribute findOrCreateBaseAttribute(String string) {
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        return (MdmBaseAttribute)this.findOrCreateContainedObject(string2, string, (short)0, MdmXMLTags.ATTRIBUTES, MdmBaseAttribute.class);
    }

    @Override
    public MemberListMap findOrCreateMemberListMap() {
        String string = MdmPrimaryDimension.generateID((BaseMetadataObject)this, "MAP");
        return this.findOrCreateMemberListMap(string);
    }

    public List getPersistentLanguages() {
        return PersistentLanguageFetcher.fetchPersistentLanguages(new String[]{this.getID()}, this.getMetadataProvider().getDataProvider());
    }

    public final List getMdmCustomMembers() {
        return this.getPropertyListValues(MdmXMLTags.CUSTOM_MEMBER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdmCustomMember findOrCreateMdmCustomMember(String string) {
        MdmCustomMember mdmCustomMember = null;
        String string2 = MdmPrimaryDimension.generateID((BaseMetadataObject)this, string);
        MetadataObject metadataObject = this.getMetadataProvider().fetchMetadataObject(string2);
        if (null == metadataObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                metadataObject = this.getMetadataProvider().fetchMetadataObject(string2);
                if (null == metadataObject) {
                    mdmCustomMember = new MdmCustomMember(string, 0, this);
                    this.addToListProperty(MdmXMLTags.CUSTOM_MEMBER, mdmCustomMember);
                    return mdmCustomMember;
                }
            }
        }
        if (metadataObject instanceof MdmCustomMember) {
            mdmCustomMember = (MdmCustomMember)metadataObject;
            this.addToListProperty(MdmXMLTags.CUSTOM_MEMBER, mdmCustomMember);
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return mdmCustomMember;
    }

    public final void removeMdmCustomMember(MdmCustomMember mdmCustomMember) {
        this.removeFromListProperty(MdmXMLTags.CUSTOM_MEMBER, mdmCustomMember);
    }

    @Override
    protected String generateInternalID() {
        String string;
        StringBuffer stringBuffer = new StringBuffer(this.getInternalID().length());
        String string2 = this.getNamespace();
        if (null != string2 && string2.length() > 0) {
            stringBuffer.append(string2);
            stringBuffer.append("..");
        }
        if (null != (string = this.getOwnerName()) && string.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append(".");
        }
        stringBuffer.append(this.getName());
        String string3 = stringBuffer.toString();
        if (string3.equals(this.getInternalID())) {
            return null;
        }
        return string3;
    }
}

