/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAWObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLDimensionKeySourceExpression;
import oracle.olapi.metadata.conversion.LegacyXMLDimensionMapGroup;
import oracle.olapi.metadata.conversion.LegacyXMLExternalSourceExpression;
import oracle.olapi.metadata.conversion.LegacyXMLHierarchy;
import oracle.olapi.metadata.conversion.LegacyXMLHierarchyLevelAssociation;
import oracle.olapi.metadata.conversion.LegacyXMLLevel;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.mapping.DimensionMap;
import oracle.olapi.metadata.mapping.HierarchyLevelMap;
import oracle.olapi.metadata.mapping.SolvedHierarchyMap;
import oracle.olapi.syntax.Condition;

final class LegacyXMLHierarchicalParentSourceExpression
extends LegacyXMLExternalSourceExpression {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.PARENT_LEVEL_COL, LegacyXMLTags.LEVEL_REF, LegacyXMLTags.HIERARCHY_REF};

    protected LegacyXMLHierarchicalParentSourceExpression(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    String getParentLevelCol() {
        return this.getPropertyStringValue(LegacyXMLTags.PARENT_LEVEL_COL);
    }

    LegacyXMLLevel getLevel() {
        return (LegacyXMLLevel)this.getPropertyObjectValue(LegacyXMLTags.LEVEL_REF);
    }

    LegacyXMLHierarchy getHierarchy() {
        return (LegacyXMLHierarchy)this.getPropertyObjectValue(LegacyXMLTags.HIERARCHY_REF);
    }

    LegacyXMLDimensionMapGroup getDimensionMapGroup() {
        return (LegacyXMLDimensionMapGroup)this.getContainedByObject();
    }

    LegacyXMLDimensionMapGroup getParentHierLevelMapGroup() {
        LegacyXMLAWObject legacyXMLAWObject = this.getDimensionMapGroup().getAWObject();
        if (!(legacyXMLAWObject instanceof LegacyXMLHierarchyLevelAssociation)) {
            return null;
        }
        LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation = (LegacyXMLHierarchyLevelAssociation)legacyXMLAWObject;
        LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation2 = legacyXMLHierarchyLevelAssociation.getParentLevel();
        if (null == legacyXMLHierarchyLevelAssociation2) {
            return null;
        }
        return legacyXMLHierarchyLevelAssociation2.getDimensionMapGroup();
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.HIER_PARENT_SOURCE_EXPRESSION_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        LegacyXMLAWObject legacyXMLAWObject = this.getDimensionMapGroup().getAWObject();
        if (!(legacyXMLAWObject instanceof LegacyXMLHierarchyLevelAssociation || legacyXMLAWObject instanceof LegacyXMLHierarchy && ((LegacyXMLHierarchy)legacyXMLAWObject).isValueHierarchy())) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.HIER_PARENT_SOURCE_EXPRESSION, this.getID(), this.getDimensionMapGroup(), false);
        }
        legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.PARENT_LEVEL_COL, this.getParentLevelCol(), this);
        this.getDimensionMapGroup().getAWObject().validateSubDimRefs(legacyXMLConverter, this.getHierarchy(), this.getLevel(), this);
        if (null != this.getTargetObject()) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.TARGET_OBJECT_REF, this.getTargetObject(), this);
        }
        return true;
    }

    @Override
    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        DimensionMap dimensionMap = this.getDimensionMapGroup().getMdmDimensionMap();
        if (dimensionMap instanceof HierarchyLevelMap) {
            LegacyXMLDimensionMapGroup legacyXMLDimensionMapGroup = this.getParentHierLevelMapGroup();
            if (null == legacyXMLDimensionMapGroup) {
                return;
            }
            LegacyXMLDimensionKeySourceExpression legacyXMLDimensionKeySourceExpression = this.getDimensionMapGroup().getDimensionKeySourceExpression();
            LegacyXMLDimensionKeySourceExpression legacyXMLDimensionKeySourceExpression2 = legacyXMLDimensionMapGroup.getDimensionKeySourceExpression();
            if (!legacyXMLDimensionKeySourceExpression.getSourceColumnsQuery().toSyntax().equals(legacyXMLDimensionKeySourceExpression2.getSourceColumnsQuery().toSyntax())) {
                HierarchyLevelMap hierarchyLevelMap = (HierarchyLevelMap)legacyXMLDimensionMapGroup.getMdmDimensionMap();
                Condition condition = this.getSourceColumnsJoinCondition(legacyXMLDimensionKeySourceExpression2.getSourceColumnsKeyExpression());
                hierarchyLevelMap.setJoinCondition(condition);
            }
        } else if (dimensionMap instanceof SolvedHierarchyMap) {
            SolvedHierarchyMap solvedHierarchyMap = (SolvedHierarchyMap)dimensionMap;
            solvedHierarchyMap.setParentKeyExpression(this.getSourceColumnsKeyExpression());
        }
        super.convertToMdm(legacyXMLConverter);
    }

    @Override
    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        LegacyXMLDimensionMapGroup legacyXMLDimensionMapGroup = this.getParentHierLevelMapGroup();
        if (null == legacyXMLDimensionMapGroup) {
            return super.getBaseConvertOrderNumber(legacyXMLConverter);
        }
        LegacyXMLDimensionKeySourceExpression legacyXMLDimensionKeySourceExpression = legacyXMLDimensionMapGroup.getDimensionKeySourceExpression();
        if (null == legacyXMLDimensionKeySourceExpression) {
            return super.getBaseConvertOrderNumber(legacyXMLConverter);
        }
        return legacyXMLDimensionKeySourceExpression.getConvertOrderNumber(legacyXMLConverter);
    }
}

