/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLCube;
import oracle.olapi.metadata.conversion.LegacyXMLCubeDimensionSourceExpression;
import oracle.olapi.metadata.conversion.LegacyXMLExternalSourceExpression;
import oracle.olapi.metadata.conversion.LegacyXMLMappingGroup;
import oracle.olapi.metadata.conversion.LegacyXMLMeasureSourceExpression;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.mapping.CubeMap;
import oracle.olapi.metadata.mdm.MdmCube;

final class LegacyXMLCubeMapGroup
extends LegacyXMLMappingGroup {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.CUBE_DIM_SOURCE_EXPRESSIONS, LegacyXMLTags.MEASURE_SOURCE_EXPRESSIONS};

    protected LegacyXMLCubeMapGroup(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    List<LegacyXMLCubeDimensionSourceExpression> getCubeDimensionSourceExpressions() {
        return this.getPropertyListValues(LegacyXMLTags.CUBE_DIM_SOURCE_EXPRESSIONS);
    }

    List<LegacyXMLMeasureSourceExpression> getMeasureSourceExpressions() {
        return this.getPropertyListValues(LegacyXMLTags.MEASURE_SOURCE_EXPRESSIONS);
    }

    LegacyXMLCube getCube() {
        return (LegacyXMLCube)this.getAWObject();
    }

    CubeMap getMdmCubeMap() {
        return (CubeMap)this.getConvertToObject();
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.CUBE_MAP_GROUP_TAG;
    }

    @Override
    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        MdmCube mdmCube = this.getCube().getMdmCube();
        CubeMap cubeMap = mdmCube.createCubeMap();
        cubeMap.setIsSolved(false);
        cubeMap.setQuery(this.getQuery());
        this.setMdmCubeMap(cubeMap);
        super.convertToMdm(legacyXMLConverter);
    }

    @Override
    protected List<LegacyXMLExternalSourceExpression> getSourceExpressions() {
        List<LegacyXMLExternalSourceExpression> list = this.getCubeDimensionSourceExpressions();
        list.addAll(this.getMeasureSourceExpressions());
        return list;
    }

    private void setMdmCubeMap(CubeMap cubeMap) {
        this.setConvertToObject(cubeMap);
    }
}

