/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataXMLReader;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.InvalidValueException;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataObjectClass;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.MetadataXMLReaderFactory;
import oracle.olapi.metadata.XMLParserCallback;
import oracle.olapi.metadata.XMLReaderPropertyAction;
import oracle.olapi.metadata.XMLTagVersionInfo;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.syntax.SQLDataType;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.version.Version;

public final class XMLTag {
    public static final int TYPE_NONE = -1;
    public static final int TYPE_PAIR = 0;
    public static final int TYPE_LIST_ITEM = 1;
    public static final int TYPE_ATTRIBUTE = 2;
    public static final int TYPE_ID_ATTRIBUTE = 3;
    public static final int TYPE_OBJECT_REFERENCE = 4;
    public static final int TYPE_EXTERNAL_OBJECT_REFERENCE = 5;
    public static final int TYPE_CONTAINED_OBJECT = 6;
    public static final int TYPE_CONTAINED_CHOICE_OBJECT = 7;
    public static final int TYPE_HIDDEN = 8;
    public static final int TYPE_OBJECT_TAG = 9;
    public static final int TYPE_ELEMENT_TAG = 10;
    public static final int DATA_STRUCT_NONE = -1;
    public static final int DATA_STRUCT_ASSOCIATION = 0;
    public static final int DATA_STRUCT_LIST = 1;
    public static final int DATA_STRUCT_MAP = 2;
    public static final int DATA_STRUCT_LITERAL = 3;
    public static final int DATA_TYPE_NONE = -1;
    public static final int DATA_TYPE_METADATA = 0;
    public static final int DATA_TYPE_SOURCE = 1;
    public static final int DATA_TYPE_SYNTAX = 2;
    public static final int DATA_TYPE_SYNTAX_QUERY = 3;
    public static final int DATA_TYPE_STRING = 4;
    public static final int DATA_TYPE_INTEGER = 5;
    public static final int DATA_TYPE_BOOLEAN = 6;
    public static final int DATA_TYPE_SQL_TYPE = 7;
    public static final int DATA_TYPE_OBJECT = 8;
    public static final int REL_TYPE_DEFAULT = -2;
    public static final int REL_TYPE_NONE = -1;
    public static final int REL_TYPE_CONTAINED_VALUE = 0;
    public static final int REL_TYPE_CONTAINED_OBJECT = 1;
    public static final int REL_TYPE_OBJECT_REFERENCE = 2;
    public static final int REL_TYPE_CONTAINER_OBJECT = 3;
    public static final int REL_TYPE_ID_COMPONENT = 4;
    public static final String BOOLEAN_TRUE = "True";
    public static final String BOOLEAN_FALSE = "False";
    private static final String[] BOOLEAN_VALUES = new String[]{"True", "False"};
    private static final String m_DefaultVersion = "1.0";
    private static final ArrayList<XMLTag> ALL_OBJECT_TAGS = new ArrayList();
    private static final ArrayList<XMLTag> ALL_CHOICE_TAGS = new ArrayList();
    private String m_NameV0_1 = null;
    private String m_NameV1_0 = null;
    private int m_PropertyXMLType = -1;
    private int m_PropertyDataStructureType = -1;
    private int m_PropertyDataType = -1;
    private int m_PropertyRelType = -1;
    private Class m_PropertyObjectClass = null;
    private Class m_PropertyKeyObjectClass = null;
    private String[] m_AcceptableValues = null;
    private String m_DefaultStringValue = null;
    private boolean m_IgnoreCase = false;
    private MetadataXMLReaderFactory m_Factory = null;
    private boolean m_AllowSuppression = false;
    private ArrayList<XMLTag> m_ObjectTags = null;
    private XMLTagVersionInfo m_VersionInfo = null;

    public XMLTag(String string, String string2, int n) {
        this(string, string2, n, -1, -1, -2, null, null, null, false, null, null);
    }

    public XMLTag(String string, String string2, int n, Class clazz, MetadataXMLReaderFactory metadataXMLReaderFactory) {
        this(string, string2, n, -1, -1, -2, clazz, metadataXMLReaderFactory, null, false, null, null);
    }

    public XMLTag(String string, String string2, int n, Class clazz, MetadataXMLReaderFactory metadataXMLReaderFactory, XMLTag xMLTag) {
        this(string, string2, n, -1, -1, -2, clazz, metadataXMLReaderFactory, null, false, xMLTag, null);
    }

    public XMLTag(String string, String string2, int n, int n2, int n3) {
        this(string, string2, n, n2, n3, -2, null, null, null, false, null, null);
    }

    public XMLTag(String string, String string2, int n, int n2, int n3, XMLTagVersionInfo xMLTagVersionInfo) {
        this(string, string2, n, n2, n3, -2, null, null, xMLTagVersionInfo, false, null, null);
    }

    public XMLTag(String string, String string2, int n, int n2, int n3, XMLTagVersionInfo xMLTagVersionInfo, boolean bl) {
        this(string, string2, n, n2, n3, -2, null, null, xMLTagVersionInfo, bl, null, null);
    }

    public XMLTag(String string, String string2, int n, int n2, int n3, boolean bl) {
        this(string, string2, n, n2, n3, -2, null, null, null, bl, null, null);
    }

    public XMLTag(String string, String string2, int n, int n2, int n3, int n4) {
        this(string, string2, n, n2, n3, n4, null, null, null, false, null, null);
    }

    public XMLTag(String string, String string2, int n, int n2, int n3, Class clazz, MetadataXMLReaderFactory metadataXMLReaderFactory) {
        this(string, string2, n, n2, n3, -2, clazz, metadataXMLReaderFactory, null, false, null, null);
    }

    public XMLTag(String string, String string2, int n, int n2, int n3, Class clazz, MetadataXMLReaderFactory metadataXMLReaderFactory, XMLTagVersionInfo xMLTagVersionInfo) {
        this(string, string2, n, n2, n3, -2, clazz, metadataXMLReaderFactory, xMLTagVersionInfo, false, null, null);
    }

    public XMLTag(String string, String string2, int n, int n2, int n3, Class clazz, Class clazz2, MetadataXMLReaderFactory metadataXMLReaderFactory) {
        this(string, string2, n, n2, n3, -2, clazz2, metadataXMLReaderFactory, null, false, null, clazz);
    }

    public XMLTag(String string, String string2, int n, int n2, int n3, int n4, Class clazz, MetadataXMLReaderFactory metadataXMLReaderFactory) {
        this(string, string2, n, n2, n3, n4, clazz, metadataXMLReaderFactory, null, false, null, null);
    }

    private XMLTag(String string, String string2, int n, int n2, int n3, int n4, Class clazz, MetadataXMLReaderFactory metadataXMLReaderFactory, XMLTagVersionInfo xMLTagVersionInfo, boolean bl, XMLTag xMLTag, Class clazz2) {
        this.m_NameV0_1 = string;
        this.m_NameV1_0 = string2;
        if (null == xMLTagVersionInfo) {
            String string3 = "0.1";
            if (null == string) {
                string3 = m_DefaultVersion;
            }
            xMLTagVersionInfo = new XMLTagVersionInfo(string3);
        }
        this.setVersionInfo(xMLTagVersionInfo);
        this.setXMLType(n);
        this.setDataStructureType(n2);
        this.setDataType(n3);
        this.setAllowSuppression(bl);
        if (-2 == n4) {
            n4 = this.getDefaultRelationshipType(n);
        }
        this.setRelationshipType(n4);
        this.setObjectClass(clazz);
        this.setKeyObjectClass(clazz2);
        this.m_Factory = metadataXMLReaderFactory;
        if (n3 == 6) {
            this.m_AcceptableValues = BOOLEAN_VALUES;
            this.m_IgnoreCase = true;
        }
        if (n == 9) {
            this.addToAllObjectTags(xMLTag);
        }
        if (this.isChoiceTag()) {
            this.addToAllChoiceTags();
        }
        if (0 == this.getDataType()) {
            if (null == this.getObjectClass()) {
                throw new RuntimeException("Missing class in " + this.toString());
            }
            if (0 == this.getXMLType() && null == this.getKeyObjectClass()) {
                throw new RuntimeException("Missing key class in " + this.toString());
            }
        }
    }

    public XMLTag(String string, String string2, String[] stringArray, String string3, boolean bl) {
        this(string, string2, 2, 3, 4);
        this.m_AcceptableValues = stringArray;
        this.m_DefaultStringValue = string3;
        this.m_IgnoreCase = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("XMLTag[");
        stringBuffer.append(this.m_NameV0_1);
        stringBuffer.append(", ");
        stringBuffer.append(this.m_NameV1_0);
        stringBuffer.append(", ");
        switch (this.getXMLType()) {
            case -1: {
                stringBuffer.append("TYPE_NONE");
                break;
            }
            case 0: {
                stringBuffer.append("TYPE_PAIR");
                break;
            }
            case 1: {
                stringBuffer.append("TYPE_LIST_ITEM");
                break;
            }
            case 2: {
                stringBuffer.append("TYPE_ATTRIBUTE");
                break;
            }
            case 3: {
                stringBuffer.append("TYPE_ID_ATTRIBUTE");
                break;
            }
            case 4: {
                stringBuffer.append("TYPE_OBJECT_REFERENCE");
                break;
            }
            case 5: {
                stringBuffer.append("TYPE_EXTERNAL_OBJECT_REFERENCE");
                break;
            }
            case 6: {
                stringBuffer.append("TYPE_CONTAINED_OBJECT");
                break;
            }
            case 7: {
                stringBuffer.append("TYPE_CONTAINED_CHOICE_OBJECT");
                break;
            }
            case 8: {
                stringBuffer.append("TYPE_HIDDEN");
                break;
            }
            case 9: {
                stringBuffer.append("TYPE_OBJECT_TAG");
                break;
            }
            case 10: {
                stringBuffer.append("TYPE_ELEMENT_TAG");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean matches(String string, String string2) {
        Version version = new Version(this.getOldestVersion());
        return new Version(string2).isSameOrLaterThan(version) && string.equalsIgnoreCase(this.getVersionedValue(string2));
    }

    public String getVersionedValue(String string) {
        if (string.equals("0.1")) {
            return this.m_NameV0_1;
        }
        return this.m_NameV1_0;
    }

    public int getXMLType() {
        return this.m_PropertyXMLType;
    }

    public boolean isXMLContainedObject() {
        return 6 == this.getXMLType() || 7 == this.getXMLType();
    }

    public boolean isXMLObjectReference() {
        return 4 == this.getXMLType() || 5 == this.getXMLType();
    }

    boolean isXMLExternalObjectReference() {
        return 5 == this.getXMLType();
    }

    boolean isXMLHiddenObject() {
        return 8 == this.getXMLType();
    }

    boolean isRelationshipContainedObject() {
        return 1 == this.getRelationshipType();
    }

    public boolean isChoiceTag() {
        return 7 == this.getXMLType() || null != this.getObjectTags();
    }

    boolean isNestedSubObject() {
        return this.getDataType() == 0 && (this.isXMLContainedObject() || this.isXMLHiddenObject() && this.isRelationshipContainedObject());
    }

    private void setXMLType(int n) {
        this.m_PropertyXMLType = n;
    }

    int getDataStructureType() {
        return this.m_PropertyDataStructureType;
    }

    boolean isSyntaxDataType() {
        return 2 == this.getDataType() || 3 == this.getDataType();
    }

    boolean isAttributeXMLType() {
        return 3 == this.getXMLType() || 2 == this.getXMLType();
    }

    boolean isObjectIDAttributeType() {
        return 0 == this.getDataType() && 4 == this.getRelationshipType();
    }

    private void setDataStructureType(int n) {
        this.m_PropertyDataStructureType = n;
    }

    private String getOldestVersion() {
        return this.m_VersionInfo.getOldestVersion();
    }

    private void setVersionInfo(XMLTagVersionInfo xMLTagVersionInfo) {
        this.m_VersionInfo = xMLTagVersionInfo;
    }

    int getDataType() {
        return this.m_PropertyDataType;
    }

    private void setDataType(int n) {
        this.m_PropertyDataType = n;
    }

    int getRelationshipType() {
        return this.m_PropertyRelType;
    }

    private void setRelationshipType(int n) {
        this.m_PropertyRelType = n;
    }

    public Class getObjectClass() {
        return this.m_PropertyObjectClass;
    }

    private void setObjectClass(Class clazz) {
        this.m_PropertyObjectClass = clazz;
    }

    public Class getKeyObjectClass() {
        return this.m_PropertyKeyObjectClass;
    }

    private void setKeyObjectClass(Class clazz) {
        this.m_PropertyKeyObjectClass = clazz;
    }

    public MetadataObjectClass getMetadataObjectClass() {
        Class clazz = this.getObjectClass();
        if (null == clazz) {
            throw new RuntimeException("Missing class in " + this.toString());
        }
        return MetadataObjectClass.getMetadataObjectClass(clazz);
    }

    private ArrayList<XMLTag> getObjectTags() {
        return this.m_ObjectTags;
    }

    private synchronized void addObjectTag(XMLTag xMLTag) {
        if (null == this.m_ObjectTags) {
            this.m_ObjectTags = new ArrayList();
        }
        this.m_ObjectTags.add(xMLTag);
    }

    public XMLTag findObjectTag(String string, String string2) {
        if (null == this.getObjectTags()) {
            return null;
        }
        for (int i = 0; i < this.getObjectTags().size(); ++i) {
            XMLTag xMLTag = this.getObjectTags().get(i);
            if (!xMLTag.matches(string, string2)) continue;
            return xMLTag;
        }
        return null;
    }

    public String[] getAcceptableValues() {
        return this.m_AcceptableValues;
    }

    public String getDefaultStringValue() {
        return this.m_DefaultStringValue;
    }

    String getDefaultName() {
        String string = this.getVersionedValue(m_DefaultVersion);
        if (string == null) {
            string = this.getVersionedValue("0.1");
        }
        return string;
    }

    private boolean ignoreCase() {
        return this.m_IgnoreCase;
    }

    public MetadataXMLReaderFactory getFactory() {
        return this.m_Factory;
    }

    public void initializeProperty(BaseMetadataObject baseMetadataObject, Object object, short s) {
        XMLReaderPropertyAction xMLReaderPropertyAction = new XMLReaderPropertyAction();
        xMLReaderPropertyAction.setToDefault();
        xMLReaderPropertyAction.setPersistenceType(s);
        this.initializeProperty(baseMetadataObject, object, xMLReaderPropertyAction, null);
    }

    public void initializeProperty(BaseMetadataObject baseMetadataObject, Object object, XMLReaderPropertyAction xMLReaderPropertyAction) {
        this.initializeProperty(baseMetadataObject, object, xMLReaderPropertyAction, null);
    }

    void initializeProperty(BaseMetadataObject baseMetadataObject, Object object, XMLReaderPropertyAction xMLReaderPropertyAction, XMLParserCallback xMLParserCallback) {
        Object object2 = object;
        if (object instanceof String) {
            object2 = this.getPropertyObject(baseMetadataObject, (String)object, this.getDataType(), xMLReaderPropertyAction, xMLParserCallback, this.getObjectClass());
        }
        if (0 == this.getDataStructureType()) {
            this.initializeAssociationProperty(baseMetadataObject, object2, xMLReaderPropertyAction);
        } else if (1 == this.getDataStructureType()) {
            this.initializeListProperty(baseMetadataObject, object2, xMLReaderPropertyAction);
        } else if (3 == this.getDataStructureType()) {
            this.initializeLiteralValueProperty(baseMetadataObject, object2, xMLReaderPropertyAction);
        } else {
            throw new RuntimeException();
        }
    }

    void initializePairProperty(BaseMetadataObject baseMetadataObject, String string, String string2, XMLReaderPropertyAction xMLReaderPropertyAction) {
        Object object = this.getPropertyObject(baseMetadataObject, string, 0, xMLReaderPropertyAction, null, this.getKeyObjectClass());
        Object object2 = null;
        if (xMLReaderPropertyAction.isAdd()) {
            object2 = this.getPropertyObject(baseMetadataObject, string2, this.getDataType(), xMLReaderPropertyAction, null, this.getObjectClass());
        }
        baseMetadataObject.internalMapProperty(this, object, object2, xMLReaderPropertyAction.getPersistenceType());
    }

    private void initializeAssociationProperty(BaseMetadataObject baseMetadataObject, Object object, XMLReaderPropertyAction xMLReaderPropertyAction) {
        baseMetadataObject.internalSetObjectProperty(this, object, xMLReaderPropertyAction.getPersistenceType(), xMLReaderPropertyAction.getIgnoreFixedStatus());
    }

    private void initializeListProperty(BaseMetadataObject baseMetadataObject, Object object, XMLReaderPropertyAction xMLReaderPropertyAction) {
        if (xMLReaderPropertyAction.isAdd()) {
            baseMetadataObject.internalAddToListProperty(this, object, xMLReaderPropertyAction.getListPosition(), xMLReaderPropertyAction.getPersistenceType());
        } else if (xMLReaderPropertyAction.isRemove()) {
            baseMetadataObject.internalRemoveFromListProperty(this, object, xMLReaderPropertyAction.getPersistenceType());
        } else {
            baseMetadataObject.internalClearListProperty(this, xMLReaderPropertyAction.getPersistenceType());
        }
    }

    private void initializeLiteralValueProperty(BaseMetadataObject baseMetadataObject, Object object, XMLReaderPropertyAction xMLReaderPropertyAction) {
        if (this == BaseMetadataXMLTags.ID_NAME) {
            return;
        }
        if (!xMLReaderPropertyAction.isAdd()) {
            return;
        }
        baseMetadataObject.internalSetStringProperty(this, (String)object, xMLReaderPropertyAction.getPersistenceType(), xMLReaderPropertyAction.getIgnoreFixedStatus());
    }

    String validateStringValue(String string) {
        int n;
        if (null == string) {
            return string;
        }
        if (null != this.getDefaultStringValue()) {
            n = 0;
            n = this.ignoreCase() ? (int)(string.equalsIgnoreCase(this.getDefaultStringValue()) ? 1 : 0) : (int)(string.equals(this.getDefaultStringValue()) ? 1 : 0);
            if (n != 0) {
                return null;
            }
        }
        if (-1 == (n = this.validateStringValueByIndex(string))) {
            return string;
        }
        return this.getAcceptableValues()[n];
    }

    int validateStringValueByIndex(String string) {
        if (null == this.getAcceptableValues()) {
            return -1;
        }
        for (int i = 0; i < this.getAcceptableValues().length; ++i) {
            boolean bl = false;
            bl = this.ignoreCase() ? string.equalsIgnoreCase(this.getAcceptableValues()[i]) : string.equals(this.getAcceptableValues()[i]);
            if (!bl) continue;
            return i;
        }
        throw new InvalidValueException("InvalidAttributeValue", string, this.getDefaultName());
    }

    private Object getPropertyObject(BaseMetadataObject baseMetadataObject, String string, int n, XMLReaderPropertyAction xMLReaderPropertyAction, XMLParserCallback xMLParserCallback, Class clazz) {
        if (null == string) {
            return null;
        }
        Object object = null;
        if (0 == n) {
            if (0 == this.getDataStructureType() && string.length() == 0) {
                object = null;
            } else {
                MetadataObjectHolder metadataObjectHolder = baseMetadataObject.getBaseMetadataProvider().getObjectHolder(string);
                object = metadataObjectHolder;
                MetadataObject metadataObject = metadataObjectHolder.getMetadataObject();
                if (xMLReaderPropertyAction.getPersistenceType() == 0 && null == metadataObject && null == (metadataObject = baseMetadataObject.getBaseMetadataProvider().fetchMetadataObject(string))) {
                    throw new InvalidValueException("InvalidIdentifier", string);
                }
                if (null != metadataObject && !clazz.isInstance(metadataObject)) {
                    throw new InvalidValueException("ObjectTypeMismatch", metadataObject.getID(), clazz.getName(), metadataObject.getClass().getName());
                }
            }
        } else if (1 == n) {
            object = string;
        } else if (2 == n) {
            if (string.length() == 0) {
                object = null;
            } else {
                object = SyntaxObject.fromSyntax(string, (MdmMetadataProvider)baseMetadataObject.getBaseMetadataProvider(), baseMetadataObject.getOwnerName(), false, null, xMLParserCallback);
                if (null != object && !clazz.isInstance(object)) {
                    throw new InvalidValueException("SyntaxTypeMismatch", clazz.getName(), object.getClass().getName());
                }
            }
        } else if (3 == n) {
            if (string.length() == 0) {
                object = null;
            } else {
                object = SyntaxObject.fromSyntax(string, (MdmMetadataProvider)baseMetadataObject.getBaseMetadataProvider(), baseMetadataObject.getOwnerName(), true, null, xMLParserCallback);
                if (null != object && !clazz.isInstance(object)) {
                    throw new InvalidValueException("SyntaxTypeMismatch", clazz.getName(), object.getClass().getName());
                }
            }
        } else if (7 == n) {
            object = string.length() == 0 ? null : SQLDataType.getSQLDataType(string);
        } else if (4 == n || 6 == n) {
            object = string;
        } else if (5 == n) {
            object = string;
            try {
                int n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                object = null;
            }
        } else {
            throw new RuntimeException();
        }
        return object;
    }

    private final int getDefaultRelationshipType(int n) {
        String string = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 4: 
            case 5: {
                return 2;
            }
            case 6: 
            case 7: {
                return 1;
            }
            case 9: {
                return -1;
            }
            case 10: {
                return -1;
            }
            case 8: {
                string = "HIDDEN";
                break;
            }
            default: {
                string = "<UNKNOWN TYPE " + n + ">";
            }
        }
        throw new RuntimeException("XMLTag can not have an XMLType of " + string + " without defining the PropertyRelationType for " + this.toString());
    }

    boolean allowsSuppression() {
        return this.m_AllowSuppression;
    }

    private void setAllowSuppression(boolean bl) {
        this.m_AllowSuppression = bl;
    }

    boolean isReadableForVersion(BaseMetadataXMLReader baseMetadataXMLReader) {
        return this.m_VersionInfo.isReadableForVersion(baseMetadataXMLReader);
    }

    boolean isWritableForVersion(MetadataToXMLConverter metadataToXMLConverter) {
        return this.m_VersionInfo.isWritableForVersion(metadataToXMLConverter);
    }

    String getPriorValidXmlVersion(BaseMetadataXMLReader baseMetadataXMLReader) {
        return this.m_VersionInfo.getPriorValidXmlVersion(baseMetadataXMLReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final XMLTag findInAllObjectTags(String string, String string2) {
        ArrayList<XMLTag> arrayList = ALL_OBJECT_TAGS;
        synchronized (arrayList) {
            for (XMLTag xMLTag : ALL_OBJECT_TAGS) {
                if (!xMLTag.matches(string, string2)) continue;
                return xMLTag;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToAllObjectTags(XMLTag xMLTag) {
        ArrayList<XMLTag> arrayList = ALL_OBJECT_TAGS;
        synchronized (arrayList) {
            ALL_OBJECT_TAGS.add(this);
            int n = -1;
            for (int i = 0; i < ALL_CHOICE_TAGS.size(); ++i) {
                XMLTag xMLTag2 = ALL_CHOICE_TAGS.get(i);
                if (xMLTag2 == xMLTag) {
                    n = i;
                    continue;
                }
                Class clazz = xMLTag2.getObjectClass();
                if (!clazz.isAssignableFrom(this.getObjectClass())) continue;
                xMLTag2.addObjectTag(this);
            }
            if (0 <= n) {
                ALL_CHOICE_TAGS.remove(n);
                if (null != xMLTag.getObjectTags()) {
                    xMLTag.getObjectTags().clear();
                }
            }
            if (null != xMLTag) {
                xMLTag.addObjectTag(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToAllChoiceTags() {
        ArrayList<XMLTag> arrayList = ALL_OBJECT_TAGS;
        synchronized (arrayList) {
            ALL_CHOICE_TAGS.add(this);
            for (int i = 0; i < ALL_OBJECT_TAGS.size(); ++i) {
                XMLTag xMLTag = ALL_OBJECT_TAGS.get(i);
                Class clazz = xMLTag.getObjectClass();
                if (!this.getObjectClass().isAssignableFrom(clazz)) continue;
                this.addObjectTag(xMLTag);
            }
        }
    }

    public boolean canDeferOnParse() {
        return this.isSyntaxDataType() || 2 == this.getRelationshipType() || this.isObjectIDAttributeType() && BaseMetadataXMLTags.OWNER != this;
    }

    boolean canUseAsXMLAttribute() {
        if (this.isAttributeXMLType()) {
            return true;
        }
        return this.isXMLObjectReference() && 0 == this.getDataType() && 0 == this.getDataStructureType();
    }

    boolean canUseAsXMLSubElement() {
        if (2 == this.getXMLType() && this.isSyntaxDataType() && 0 == this.getDataStructureType()) {
            return true;
        }
        return !this.isAttributeXMLType();
    }
}

