/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.BaseMetadataXMLReader;
import oracle.olapi.metadata.BaseMetadataXMLReaderState;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.InvalidMetadataException;
import oracle.olapi.metadata.MetadataObjectClass;
import oracle.olapi.metadata.MetadataXMLReaderBuildResultState;
import oracle.olapi.metadata.MetadataXMLReaderCDataAttributeState;
import oracle.olapi.metadata.MetadataXMLReaderElementState;
import oracle.olapi.metadata.MetadataXMLReaderFactory;
import oracle.olapi.metadata.MetadataXMLReaderInitialState;
import oracle.olapi.metadata.MetadataXMLReaderListItemState;
import oracle.olapi.metadata.MetadataXMLReaderMetadataInitialState;
import oracle.olapi.metadata.MetadataXMLReaderPairState;
import oracle.olapi.metadata.MetadataXMLReaderReferenceState;
import oracle.olapi.metadata.MetadataXMLReaderRenameObjectsState;
import oracle.olapi.metadata.MetadataXMLReaderRenameState;
import oracle.olapi.metadata.MetadataXMLReaderRootCommitErrorState;
import oracle.olapi.metadata.MetadataXMLReaderRootCommitState;
import oracle.olapi.metadata.XMLReaderPropertyAction;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.deployment.DeploymentXMLTags;
import oracle.olapi.metadata.mapping.MappingXMLTags;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.metadata.mtm.MtmXMLTags;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MetadataXMLReader
extends BaseMetadataXMLReader {
    private MetadataXMLReaderMetadataInitialState m_MetadataInitialState = new MetadataXMLReaderMetadataInitialState();
    private MetadataXMLReaderElementState m_ElementState = null;
    private MetadataXMLReaderListItemState m_ListItemState = new MetadataXMLReaderListItemState();
    private MetadataXMLReaderReferenceState m_ReferenceState = new MetadataXMLReaderReferenceState();
    private MetadataXMLReaderPairState m_PairState = new MetadataXMLReaderPairState();
    private MetadataXMLReaderCDataAttributeState m_CDataAttributeState = new MetadataXMLReaderCDataAttributeState();
    private MetadataXMLReaderBuildResultState m_BuildResultState = new MetadataXMLReaderBuildResultState();
    private int m_BuildID = -1;
    private MetadataXMLReaderRootCommitState m_RootCommitState = new MetadataXMLReaderRootCommitState();
    private MetadataXMLReaderRootCommitErrorState m_RootCommitErrorState = new MetadataXMLReaderRootCommitErrorState();
    private InvalidMetadataException m_RootCommitError = null;
    private MetadataXMLReaderRenameObjectsState m_RenameObjectsState = new MetadataXMLReaderRenameObjectsState();
    private MetadataXMLReaderRenameState m_RenameState = new MetadataXMLReaderRenameState();

    public MetadataXMLReader(short s, BaseMetadataProvider baseMetadataProvider) {
        super(s, baseMetadataProvider);
    }

    public InvalidMetadataException getRootCommitError() {
        return this.m_RootCommitError;
    }

    public int getBuildID() {
        return this.m_BuildID;
    }

    MetadataXMLReaderElementState getElementState() {
        return this.m_ElementState;
    }

    MetadataXMLReaderRootCommitState getRootCommitState() {
        return this.m_RootCommitState;
    }

    MetadataXMLReaderRootCommitErrorState getRootCommitErrorState() {
        return this.m_RootCommitErrorState;
    }

    MetadataXMLReaderRenameObjectsState getRenameObjectsState() {
        return this.m_RenameObjectsState;
    }

    MetadataXMLReaderRenameState getRenameState() {
        return this.m_RenameState;
    }

    MetadataXMLReaderElementState getNextElementState() {
        MetadataXMLReaderElementState metadataXMLReaderElementState = new MetadataXMLReaderElementState();
        this.addElementState(metadataXMLReaderElementState);
        return metadataXMLReaderElementState;
    }

    private void addElementState(MetadataXMLReaderElementState metadataXMLReaderElementState) {
        this.m_ElementState = metadataXMLReaderElementState;
    }

    void addRootCommitError(String string, String string2, int n, String string3, String string4) {
        if (null == this.m_RootCommitError) {
            this.m_RootCommitError = new InvalidMetadataException();
        }
        this.m_RootCommitError.add(string, string2, n, string3, string4);
    }

    void removeElementState() {
        this.m_ElementState = this.m_ElementState.getParent();
    }

    MetadataXMLReaderMetadataInitialState getMetadataInitialState() {
        return this.m_MetadataInitialState;
    }

    MetadataXMLReaderListItemState getListItemState() {
        return this.m_ListItemState;
    }

    MetadataXMLReaderReferenceState getReferenceState() {
        return this.m_ReferenceState;
    }

    MetadataXMLReaderPairState getPairState() {
        return this.m_PairState;
    }

    MetadataXMLReaderBuildResultState getBuildResultState() {
        return this.m_BuildResultState;
    }

    MetadataXMLReaderCDataAttributeState getCDataAttributeState() {
        return this.m_CDataAttributeState;
    }

    void setBuildID(int n) {
        this.m_BuildID = n;
    }

    BaseMetadataObject findOrCreateMetadataObject(XMLTag xMLTag, BaseMetadataObject baseMetadataObject, Attributes attributes) throws SAXException {
        String string = null;
        if (this.getXMLFormat().is10gMode()) {
            string = this.getAttributeValue(attributes, BaseMetadataXMLTags.ID_NAME);
        } else {
            XMLTag xMLTag2 = BaseMetadataXMLTags.NAME;
            MetadataObjectClass metadataObjectClass = xMLTag.getMetadataObjectClass();
            XMLTag xMLTag3 = metadataObjectClass.getObjRefIDAttribute();
            if (null != xMLTag3) {
                xMLTag2 = xMLTag3;
            }
            string = this.getMetadataObjectID(xMLTag, baseMetadataObject, attributes, xMLTag2, false);
            if (null != xMLTag3) {
                String string2 = this.getMetadataObjectID(xMLTag3, baseMetadataObject, attributes, xMLTag2, true);
                string = this.applyRenameWithIDAttribute(baseMetadataObject, string, string2, xMLTag, xMLTag3);
            } else {
                string = this.renameObject(xMLTag, string);
            }
        }
        return this.findOrCreateMetadataObject(xMLTag, baseMetadataObject, string);
    }

    String getMetadataObjectRefID(XMLTag xMLTag, BaseMetadataObject baseMetadataObject, Attributes attributes) throws SAXException {
        String string = null;
        if (this.getXMLFormat().is10gMode()) {
            string = this.getAttributeValue(attributes, BaseMetadataXMLTags.REF_ID);
        } else {
            XMLTag xMLTag2 = BaseMetadataXMLTags.NAME;
            string = this.getMetadataObjectID(xMLTag, baseMetadataObject, attributes, xMLTag2, this.isInAttributes());
        }
        return string;
    }

    @Override
    protected BaseMetadataXMLReaderState createInitialState() {
        return new MetadataXMLReaderInitialState();
    }

    @Override
    protected void loadXMLTags() {
        MdmXMLTags.init();
        MappingXMLTags.init();
        DeploymentXMLTags.init();
        MtmXMLTags.init();
    }

    @Override
    protected void initializeDeferredProperty(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, Object object, XMLReaderPropertyAction xMLReaderPropertyAction) {
        if (0 == xMLTag.getDataType() && object instanceof String) {
            String string = (String)object;
            object = this.applyRenameForID(baseMetadataObject, string, xMLTag);
        }
        super.initializeDeferredProperty(baseMetadataObject, xMLTag, object, xMLReaderPropertyAction);
    }

    private BaseMetadataObject findOrCreateMetadataObject(XMLTag xMLTag, BaseMetadataObject baseMetadataObject, String string) {
        MetadataXMLReaderFactory metadataXMLReaderFactory = xMLTag.getFactory();
        if (null == metadataXMLReaderFactory) {
            throw new RuntimeException("Missing factory in " + xMLTag.toString());
        }
        return metadataXMLReaderFactory.findOrCreateMetadataObject(xMLTag, baseMetadataObject, string, this);
    }

    private String getMetadataObjectID(XMLTag xMLTag, BaseMetadataObject baseMetadataObject, Attributes attributes, XMLTag xMLTag2, boolean bl) throws SAXException {
        String string;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (bl) {
            string2 = this.getAttributeValue(attributes, xMLTag);
            if (0 == string2.length()) {
                return string2;
            }
        } else {
            string2 = this.getAttributeValue(attributes, xMLTag2, false);
            string3 = this.getAttributeValue(attributes, BaseMetadataXMLTags.OWNER, false);
            string4 = this.getAttributeValue(attributes, BaseMetadataXMLTags.NAMESPACE, false);
        }
        if (BaseMetadataXMLTags.OWNER != xMLTag && (null == string3 || 0 == string3.length())) {
            string3 = this.getCurrentOwner(baseMetadataObject);
        }
        if (null == (string = MetadataXMLReaderFactory.getMetadataObjectID(baseMetadataObject, xMLTag, string2, string3, string4, this))) {
            this.reportError("InvalidXMLObjectID");
        }
        return string;
    }
}

