/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataObjectState;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.MetadataToXMLConverterSince10105;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.XMLWriterCallback;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.parser.Identifier;
import oracle.olapi.transaction.MetadataContext;
import oracle.olapi.transaction.PersistentMetadataContext;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionalObjectInvalidException;
import oracle.olapi.version.Version;

public final class MetadataToFileXMLConverter
extends MetadataToXMLConverterSince10105 {
    private static final Integer MODIFIED = new Integer(2);
    private Map m_BindVariables = null;
    private List m_ContextSchemas = null;
    private Transaction m_SinceTxn = null;
    private XMLWriterCallback m_UserCallback = null;

    public MetadataToFileXMLConverter(DataProvider dataProvider, Version version) {
        super(dataProvider, version);
    }

    @Override
    protected boolean addMetadataObjectAndChildren(BaseMetadataObject baseMetadataObject, List list) {
        if (baseMetadataObject == null) {
            return false;
        }
        Object object = this.getAboutToSendState(baseMetadataObject);
        if (object != null) {
            return object != NOT_MODIFIED;
        }
        if (!this.getXMLFormat().is11gPartialXMLMode()) {
            this.addAboutToSendState(baseMetadataObject, MODIFIED);
            return true;
        }
        boolean bl = baseMetadataObject.isModifiedBetween(this.getTransaction(), this.getSinceTransaction());
        if (bl) {
            this.addAboutToSendState(baseMetadataObject, MODIFIED);
        } else {
            this.addAboutToSendState(baseMetadataObject, NOT_MODIFIED);
        }
        boolean bl2 = baseMetadataObject.addContainedChildrenToXMLWriter(this, list);
        if (bl2 && !bl) {
            this.addAboutToSendState(baseMetadataObject, CHILDREN_MODIFIED);
        }
        return bl2 || bl;
    }

    public void setRenameMap(Map map) {
        if (null != map) {
            for (Map.Entry entry : map.entrySet()) {
                BaseMetadataObject baseMetadataObject = (BaseMetadataObject)entry.getKey();
                String string = (String)entry.getValue();
                Identifier identifier = Identifier.parseID(baseMetadataObject.getID(), baseMetadataObject.getClass());
                Identifier identifier2 = new Identifier(identifier);
                identifier2.setName(string);
                this.getIDRenameMap().put(identifier, identifier2);
            }
        }
    }

    public void setBindVariables(Map map) {
        this.m_BindVariables = map;
    }

    public Map getBindVariables() {
        return this.m_BindVariables;
    }

    private String getRenameValue(BaseMetadataObject baseMetadataObject) {
        if (null == this.getIDRenameMap(false)) {
            return null;
        }
        Identifier identifier = Identifier.parseID(baseMetadataObject.getID(), baseMetadataObject.getClass());
        Identifier identifier2 = this.getIDRenameMap().get(identifier);
        if (null == identifier2) {
            return null;
        }
        return identifier2.getName();
    }

    private String getBindVariable(BaseMetadataObject baseMetadataObject, boolean bl) {
        if (this.getBindVariables() == null) {
            return null;
        }
        String string = (String)this.getBindVariables().get(baseMetadataObject);
        if (null != string && bl) {
            return "&" + string + ";";
        }
        return string;
    }

    public void addContextSchema(MdmDatabaseSchema mdmDatabaseSchema) {
        if (this.m_ContextSchemas == null) {
            this.m_ContextSchemas = new ArrayList();
        } else if (this.containsContextSchema(mdmDatabaseSchema)) {
            return;
        }
        this.m_ContextSchemas.add(mdmDatabaseSchema);
    }

    private boolean containsContextSchema(MdmDatabaseSchema mdmDatabaseSchema) {
        if (this.m_ContextSchemas != null) {
            Iterator iterator = this.m_ContextSchemas.iterator();
            while (iterator.hasNext()) {
                if (mdmDatabaseSchema != iterator.next()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getIDValue(XMLTag xMLTag, String string, BaseMetadataObject baseMetadataObject) {
        if (BaseMetadataXMLTags.NAMESPACE == xMLTag) {
            return super.getIDValue(xMLTag, string, baseMetadataObject);
        }
        String string2 = this.getRenameValue(baseMetadataObject);
        if (null != string2) {
            return this.escapeString(string2);
        }
        String string3 = this.getBindVariable(baseMetadataObject, true);
        if (null != string3) {
            return string3;
        }
        if (baseMetadataObject instanceof MdmDatabaseSchema && this.containsContextSchema((MdmDatabaseSchema)baseMetadataObject)) {
            return null;
        }
        return super.getIDValue(xMLTag, string, baseMetadataObject);
    }

    public final void setSinceTransaction(Transaction transaction) {
        if (transaction != null) {
            if (this.getTransaction() == null) {
                transaction = null;
            } else if (!transaction.isAncestorOf(this.getTransaction())) {
                throw new TransactionalObjectInvalidException();
            }
        }
        this.m_SinceTxn = transaction;
    }

    final Transaction getSinceTransaction() {
        return this.m_SinceTxn;
    }

    @Override
    public final BaseMetadataObjectState getIncrementalSendState(BaseMetadataObject baseMetadataObject) {
        MetadataContext metadataContext = this.getSinceTransaction();
        if (null == metadataContext) {
            metadataContext = PersistentMetadataContext.INSTANCE;
        }
        return baseMetadataObject.getIncrementalChangesSinceState(this.getTransaction(), metadataContext);
    }

    @Override
    public final void resetState() {
        super.resetState();
        this.setSinceTransaction(null);
        this.setRenameMap(null);
        if (this.m_ContextSchemas != null) {
            this.m_ContextSchemas.clear();
        }
    }

    @Override
    protected void generateXMLHeader() {
        if (null == this.getBindVariables()) {
            return;
        }
        String string = "BIND_VALUES";
        this.beginDocType(BaseMetadataXMLTags.METADATA_TAG);
        this.appendParameterEntityDecl(string, "OLAP BIND VALUES", "OLAP METADATA");
        this.appendParameterEntityRef(string);
        this.endDocType();
    }

    public final void setUserCallback(XMLWriterCallback xMLWriterCallback) {
        this.m_UserCallback = xMLWriterCallback;
    }

    public final XMLWriterCallback getUserCallback() {
        return this.m_UserCallback;
    }

    @Override
    final boolean suppressOwnerName(XMLTag xMLTag, SyntaxObject syntaxObject, BaseMetadataObject baseMetadataObject) {
        boolean bl = super.suppressOwnerName(xMLTag, syntaxObject, baseMetadataObject);
        if (null == this.getUserCallback()) {
            return bl;
        }
        String string = xMLTag.getVersionedValue(this.getXMLFormat().getVersion());
        return this.getUserCallback().suppressOwnerName(baseMetadataObject, string, syntaxObject, bl);
    }

    @Override
    final boolean suppressAttribute(XMLTag xMLTag, String string, BaseMetadataObject baseMetadataObject) {
        if (MdmXMLTags.NEW_NAME == xMLTag && this.getXMLFormat().is11gFullXMLMode()) {
            return true;
        }
        boolean bl = super.suppressAttribute(xMLTag, string, baseMetadataObject);
        if (null == this.getUserCallback() || null == baseMetadataObject) {
            return bl;
        }
        String string2 = xMLTag.getVersionedValue(this.getXMLFormat().getVersion());
        return this.getUserCallback().suppressXMLAttribute(baseMetadataObject, string2, string);
    }

    @Override
    final boolean suppressNamespace(XMLTag xMLTag, SyntaxObject syntaxObject, BaseMetadataObject baseMetadataObject) {
        boolean bl = super.suppressNamespace(xMLTag, syntaxObject, baseMetadataObject);
        if (null == this.getUserCallback() || null == baseMetadataObject) {
            return bl;
        }
        XMLTag xMLTag2 = MdmXMLTags.NAMESPACE;
        String string = xMLTag2.getVersionedValue(this.getXMLFormat().getVersion());
        return this.getUserCallback().suppressXMLAttribute(baseMetadataObject, string, "");
    }
}

