/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.NoSuchElementException;
import oracle.express.mdm.MdmMetadataProvider;
import oracle.express.olapi.replay.BaseElementFactory;
import oracle.express.olapi.replay.ElementFactory;
import oracle.express.olapi.replay.InvalidSourceNodeException;
import oracle.express.olapi.replay.NestedNodeContextException;
import oracle.express.olapi.replay.NodeContext;
import oracle.express.olapi.replay.NullSourceNodeException;
import oracle.express.olapi.replay.OracleXMLDocumentFactory;
import oracle.express.olapi.replay.Providers;
import oracle.express.olapi.replay.XMLDocumentFactory;
import oracle.olapi.data.source.Source;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefinitionReader {
    public static final String TOPELEMENT = "Datadescriptors";
    private Providers providers = null;
    private ElementFactory firstHandler = null;
    private XMLDocumentFactory factory = null;

    public DefinitionReader() {
        this.setup();
        this.factory = null;
    }

    public DefinitionReader(XMLDocumentFactory xMLDocumentFactory) {
        this.setup();
        this.factory = xMLDocumentFactory;
    }

    private void setup() {
        this.providers = new Providers();
        this.firstHandler = new BaseElementFactory(this.providers);
    }

    public DefinitionReader(MdmMetadataProvider mdmMetadataProvider) {
        this();
        this.addMetadataProvider(mdmMetadataProvider);
    }

    public DefinitionReader(MdmMetadataProvider mdmMetadataProvider, XMLDocumentFactory xMLDocumentFactory) {
        this(xMLDocumentFactory);
        this.addMetadataProvider(mdmMetadataProvider);
    }

    public DefinitionReader(MdmMetadataProvider[] mdmMetadataProviderArray, XMLDocumentFactory xMLDocumentFactory) {
        this(xMLDocumentFactory);
        this.addMetadataProviders(mdmMetadataProviderArray);
    }

    private XMLDocumentFactory getFactory() {
        return this.factory != null ? this.factory : OracleXMLDocumentFactory.getInstance();
    }

    public void addMetadataProviders(MdmMetadataProvider[] mdmMetadataProviderArray) {
        for (int i = 0; i < mdmMetadataProviderArray.length; ++i) {
            this.providers.addMetadataProvider(mdmMetadataProviderArray[i]);
        }
    }

    public void addMetadataProvider(MdmMetadataProvider mdmMetadataProvider) {
        this.providers.addMetadataProvider(mdmMetadataProvider);
    }

    public Source[] getSources(String string, String string2) throws IOException, NestedNodeContextException {
        return this.getSources(new StringReader(string), string2);
    }

    public Source[] getSources(Reader reader, String string) throws IOException, NestedNodeContextException, NoSuchElementException {
        Document document = this.getFactory().parse(reader);
        return this.getSources(document, string);
    }

    public Source[] getSources(Document document, String string) throws NestedNodeContextException, NoSuchElementException {
        Element element = document.getDocumentElement();
        try {
            if (string != null && string.length() != 0) {
                NodeList nodeList = this.getFactory().selectNodes(element, string);
                element = (Element)nodeList.item(0);
            }
        }
        catch (Exception exception) {
            throw new NoSuchElementException("XML Element '" + string + "' not found.");
        }
        return this.getSources(element);
    }

    public Source[] getSources(Element element) throws NestedNodeContextException, NoSuchElementException {
        String string = element.getNodeName();
        if (!TOPELEMENT.equals(string)) {
            throw new NoSuchElementException("XML tag 'Datadescriptors' not found.");
        }
        Source[] sourceArray = null;
        try {
            NodeList nodeList = this.getFactory().selectNodes(element, "List/*");
            sourceArray = new Source[nodeList.getLength()];
            for (int i = 0; i < sourceArray.length; ++i) {
                try {
                    Element element2 = (Element)nodeList.item(i);
                    DefinitionNodeContext definitionNodeContext = new DefinitionNodeContext(element2, this.getFactory());
                    sourceArray[i] = (Source)((NodeContext)definitionNodeContext).create();
                    continue;
                }
                catch (Exception exception) {
                    sourceArray[i] = null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return sourceArray;
    }

    private Object _create(NodeContext nodeContext) throws InvalidSourceNodeException {
        Object object = this.firstHandler.create(nodeContext);
        return object;
    }

    class InvalidNodeException
    extends Exception {
        private Node node;
        private String required;

        public InvalidNodeException(Node node, String string) {
            this.node = node;
            this.required = string;
        }

        public Node getNode() {
            return this.node;
        }

        public String getRequiredNode() {
            return this.required;
        }

        @Override
        public String toString() {
            return "Invalid node " + this.node.getNodeName() + " encountered. Expected is " + this.required;
        }
    }

    private class DefinitionNodeContext
    extends NodeContext {
        public DefinitionNodeContext(Node node, XMLDocumentFactory xMLDocumentFactory) throws NullSourceNodeException {
            super(node, xMLDocumentFactory);
        }

        @Override
        public String getNodeName() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.getNodeName());
            String string = this.getID();
            if (string.length() != 0) {
                stringBuffer.append("[id=" + string + "]");
            }
            return stringBuffer.toString();
        }

        @Override
        public Object create() throws InvalidSourceNodeException {
            Object object = DefinitionReader.this._create(this);
            return object;
        }

        @Override
        protected NodeContext createNode(Node node) throws InvalidSourceNodeException, NullSourceNodeException {
            return new DefinitionNodeContext(node, this._factory);
        }
    }
}

